/*
 * Decompiled with CFR 0.152.
 */
package com.mucommander.ui.quicklist.item;

import com.mucommander.ui.quicklist.item.QuickListItem;
import com.mucommander.ui.theme.ColorChangedEvent;
import com.mucommander.ui.theme.FontChangedEvent;
import com.mucommander.ui.theme.ThemeManager;
import java.awt.Color;
import java.awt.GradientPaint;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.RenderingHints;
import java.awt.image.BufferedImage;

public class QuickListHeaderItem
extends QuickListItem {
    protected Color foreground = ThemeManager.getCurrentColor(63);
    protected Color background = ThemeManager.getCurrentColor(61);
    protected Color secondaryBackground = ThemeManager.getCurrentColor(62);

    public QuickListHeaderItem(String text) {
        super(text);
        this.setFont(ThemeManager.getCurrentFont(6));
    }

    protected final void paintComponent(Graphics g) {
        Graphics2D graphics = (Graphics2D)g;
        graphics.setRenderingHint(RenderingHints.KEY_TEXT_ANTIALIASING, RenderingHints.VALUE_TEXT_ANTIALIAS_ON);
        graphics.drawImage((Image)this.getBackgroundImage(this.getWidth(), this.getHeight(), graphics, this.background, this.secondaryBackground), 0, 0, null);
        graphics.setFont(this.FONT);
        graphics.setColor(this.foreground);
        graphics.drawString(this.getText(), 5, (int)graphics.getFontMetrics().getLineMetrics(this.getText(), graphics).getHeight());
    }

    private BufferedImage getBackgroundImage(int width, int height, Graphics2D graphics, Color leftColor, Color rightColor) {
        graphics.setColor(Color.white);
        graphics.fillRect(0, 0, width, height);
        BufferedImage image = new BufferedImage(width, height, 2);
        graphics.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        GradientPaint gradient = new GradientPaint(0.0f, 0.0f, leftColor, width, 0.0f, rightColor);
        graphics.setPaint(gradient);
        graphics.fillRect(0, 0, width, height);
        return image;
    }

    public void setForegroundColor(Color foreground) {
        this.foreground = foreground;
        this.repaint();
    }

    public void setBackgroundColors(Color background, Color secondaryBackground) {
        this.background = background;
        this.secondaryBackground = secondaryBackground;
        this.repaint();
    }

    public void colorChanged(ColorChangedEvent event) {
        if (event.getColorId() == 61) {
            this.background = event.getColor();
        } else if (event.getColorId() == 63) {
            this.foreground = event.getColor();
        } else if (event.getColorId() == 62) {
            this.secondaryBackground = event.getColor();
        }
    }

    public void fontChanged(FontChangedEvent event) {
        this.setFont(ThemeManager.getCurrentFont(6));
    }
}

