/*
 * Decompiled with CFR 0.152.
 */
package com.mucommander.ui.quicksearch;

import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import javax.swing.JComponent;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class QuickSearch<T>
extends KeyAdapter
implements Runnable {
    private static final Logger LOGGER = LoggerFactory.getLogger(QuickSearch.class);
    private String searchString;
    private long lastSearchStringChange;
    private Thread timeoutThread;
    private JComponent component;

    protected QuickSearch(JComponent component) {
        this.component = component;
        component.addKeyListener(this);
    }

    protected synchronized void start() {
        if (!this.isActive()) {
            this.searchString = "";
            this.timeoutThread = new Thread((Runnable)this, "QuickSearch timeout thread");
            this.timeoutThread.start();
            this.lastSearchStringChange = System.currentTimeMillis();
            this.searchStarted();
        }
    }

    public synchronized void stop() {
        if (this.isActive()) {
            this.timeoutThread = null;
            this.searchStopped();
        }
    }

    public synchronized boolean isActive() {
        return this.timeoutThread != null;
    }

    public boolean matches(String string) {
        return this.isActive() && string.toLowerCase().indexOf(this.searchString.toLowerCase()) != -1;
    }

    protected boolean isValidQuickSearchInput(KeyEvent e) {
        if ((e.getModifiersEx() & 0x380) != 0) {
            return false;
        }
        char keyChar = e.getKeyChar();
        return keyChar >= ' ' && keyChar != '\u007f' && Character.isDefined(keyChar);
    }

    protected void setLastSearchStringChange(long lastSearchStringChange) {
        this.lastSearchStringChange = lastSearchStringChange;
    }

    protected boolean isSearchStringEmpty() {
        return this.searchString.length() == 0;
    }

    protected void removeLastCharacterFromSearchString() {
        this.searchString = this.searchString.substring(0, this.searchString.length() - 1);
        if (this.searchString.length() != 0) {
            this.component.repaint();
        }
    }

    protected void appendCharacterToSearchString(char keyChar) {
        this.searchString = this.searchString + keyChar;
        this.component.repaint();
    }

    protected void findMatch(int startRow, boolean descending, boolean findBestMatch) {
        LOGGER.trace("startRow=" + startRow + " descending=" + descending + " findMatch=" + findBestMatch);
        if (this.searchString.length() == 0) {
            this.searchStringBecameEmpty(this.searchString);
        } else {
            int bestMatch = this.getBestMatch(startRow, descending, findBestMatch);
            if (bestMatch != -1) {
                this.matchFound(bestMatch, this.searchString);
            } else {
                this.matchNotFound(this.searchString);
            }
        }
    }

    private int getBestMatch(int startRow, boolean descending, boolean findBestMatch) {
        String searchStringLC = this.searchString.toLowerCase();
        int searchStringLen = this.searchString.length();
        int startsWithCaseMatch = -1;
        int startsWithNoCaseMatch = -1;
        int containsCaseMatch = -1;
        int containsNoCaseMatch = -1;
        int nbRows = this.getNumOfItems();
        int i = startRow;
        while ((descending ? i < nbRows : i >= 0) && (findBestMatch || startsWithCaseMatch == -1 && startsWithNoCaseMatch == -1 && containsCaseMatch == -1 && containsNoCaseMatch == -1)) {
            String item = this.getItemString(i);
            int itemLen = item.length();
            if (itemLen >= searchStringLen) {
                if (item.startsWith(this.searchString)) {
                    startsWithCaseMatch = i;
                    break;
                }
                if (startsWithNoCaseMatch == -1) {
                    String itemLC = item.toLowerCase();
                    if (itemLC.startsWith(searchStringLC)) {
                        startsWithNoCaseMatch = i;
                    }
                    if (itemLen != searchStringLen && containsCaseMatch == -1) {
                        if (item.indexOf(this.searchString) != -1) {
                            containsCaseMatch = i;
                        } else if (containsNoCaseMatch == -1 && itemLC.indexOf(searchStringLC) != -1) {
                            containsNoCaseMatch = i;
                        }
                    }
                }
            }
            i = descending ? i + 1 : i - 1;
        }
        int bestMatch = startsWithCaseMatch != -1 ? startsWithCaseMatch : (startsWithNoCaseMatch != -1 ? startsWithNoCaseMatch : (containsCaseMatch != -1 ? containsCaseMatch : (containsNoCaseMatch != -1 ? containsNoCaseMatch : -1)));
        LOGGER.trace("startsWithCaseMatch=" + startsWithCaseMatch + " containsCaseMatch=" + containsCaseMatch + " startsWithNoCaseMatch=" + startsWithNoCaseMatch + " containsNoCaseMatch=" + containsNoCaseMatch);
        LOGGER.trace("bestMatch=" + bestMatch);
        return bestMatch;
    }

    protected abstract void searchStarted();

    protected abstract void searchStopped();

    protected abstract int getNumOfItems();

    protected abstract String getItemString(int var1);

    protected abstract void searchStringBecameEmpty(String var1);

    protected abstract void matchFound(int var1, String var2);

    protected abstract void matchNotFound(String var1);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        do {
            try {
                Thread.sleep(100L);
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
            QuickSearch quickSearch = this;
            synchronized (quickSearch) {
                if (this.timeoutThread != null && System.currentTimeMillis() - this.lastSearchStringChange >= 2000L) {
                    this.stop();
                }
            }
        } while (this.timeoutThread != null);
    }

    @Override
    public synchronized void keyReleased(KeyEvent e) {
        if (this.isActive() && e.getKeyCode() == 8 && this.searchString.equals("")) {
            e.consume();
            this.stop();
        }
    }
}

