/*
 * Decompiled with CFR 0.152.
 */
package com.mucommander.ui.tabs;

import com.mucommander.ui.tabs.Tab;
import com.mucommander.ui.tabs.TabsChangeListener;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import java.util.WeakHashMap;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TabsCollection<T extends Tab>
implements Iterable<T> {
    private List<T> collection = new ArrayList<T>();
    private WeakHashMap<TabsChangeListener, ?> tabsListeners = new WeakHashMap();

    public void add(T tab) {
        this.add(tab, this.count());
    }

    public void add(T tab, int index) {
        this.collection.add(index, tab);
        this.fireTabAdded(this.count() - 1);
    }

    public void updateTab(int index, T tab) {
        this.collection.set(index, tab);
        this.fireTabUpdated(index);
    }

    public void remove(int index) {
        this.collection.remove(index);
        this.fireTabRemoved(index);
    }

    public T get(int index) {
        return (T)((Tab)this.collection.get(index));
    }

    public int count() {
        return this.collection.size();
    }

    public synchronized void addTabsListener(TabsChangeListener listener) {
        this.tabsListeners.put(listener, null);
    }

    public synchronized void removeTabsListener(TabsChangeListener listener) {
        this.tabsListeners.remove(listener);
    }

    public synchronized void fireTabAdded(int index) {
        HashSet<TabsChangeListener> listeners = new HashSet<TabsChangeListener>(this.tabsListeners.keySet());
        for (TabsChangeListener listener : listeners) {
            listener.tabAdded(index);
        }
    }

    public synchronized void fireTabRemoved(int index) {
        Set<TabsChangeListener> listeners = this.tabsListeners.keySet();
        for (TabsChangeListener listener : listeners) {
            listener.tabRemoved(index);
        }
    }

    public synchronized void fireTabUpdated(int index) {
        Set<TabsChangeListener> listeners = this.tabsListeners.keySet();
        for (TabsChangeListener listener : listeners) {
            listener.tabUpdated(index);
        }
    }

    @Override
    public Iterator<T> iterator() {
        return this.collection.iterator();
    }
}

