/*
 * Decompiled with CFR 0.152.
 */
package com.mucommander.ui.theme;

import com.mucommander.ui.theme.ColorChangedEvent;
import com.mucommander.ui.theme.FontChangedEvent;
import com.mucommander.ui.theme.ThemeListener;
import com.mucommander.ui.theme.ThemeManager;
import java.awt.Color;
import java.awt.Font;
import java.util.WeakHashMap;

public class ThemeCache
implements ThemeListener {
    public static Color[][][] foregroundColors;
    public static Color[][] backgroundColors;
    public static Color unmatchedForeground;
    public static Color unmatchedBackground;
    public static Color activeOutlineColor;
    public static Color inactiveOutlineColor;
    public static Font tableFont;
    public static final ThemeCache instance;
    private static WeakHashMap<ThemeListener, ?> listeners;

    private ThemeCache() {
    }

    public static void addThemeListener(ThemeListener listener) {
        listeners.put(listener, null);
    }

    private static void fireColorChanged(ColorChangedEvent event) {
        for (ThemeListener listener : listeners.keySet()) {
            listener.colorChanged(event);
        }
    }

    private static void fireFontChanged(FontChangedEvent event) {
        for (ThemeListener listener : listeners.keySet()) {
            listener.fontChanged(event);
        }
    }

    public void colorChanged(ColorChangedEvent event) {
        switch (event.getColorId()) {
            case 29: {
                ThemeCache.foregroundColors[1][0][5] = event.getColor();
                break;
            }
            case 31: {
                ThemeCache.foregroundColors[1][1][5] = event.getColor();
                break;
            }
            case 9: {
                ThemeCache.foregroundColors[1][0][0] = event.getColor();
                break;
            }
            case 11: {
                ThemeCache.foregroundColors[1][1][0] = event.getColor();
                break;
            }
            case 13: {
                ThemeCache.foregroundColors[1][0][1] = event.getColor();
                break;
            }
            case 15: {
                ThemeCache.foregroundColors[1][1][1] = event.getColor();
                break;
            }
            case 17: {
                ThemeCache.foregroundColors[1][0][2] = event.getColor();
                break;
            }
            case 19: {
                ThemeCache.foregroundColors[1][1][2] = event.getColor();
                break;
            }
            case 21: {
                ThemeCache.foregroundColors[1][0][3] = event.getColor();
                break;
            }
            case 23: {
                ThemeCache.foregroundColors[1][1][3] = event.getColor();
                break;
            }
            case 25: {
                ThemeCache.foregroundColors[1][0][4] = event.getColor();
                break;
            }
            case 27: {
                ThemeCache.foregroundColors[1][1][4] = event.getColor();
                break;
            }
            case 30: {
                ThemeCache.foregroundColors[0][0][5] = event.getColor();
                break;
            }
            case 32: {
                ThemeCache.foregroundColors[0][1][5] = event.getColor();
                break;
            }
            case 10: {
                ThemeCache.foregroundColors[0][0][0] = event.getColor();
                break;
            }
            case 12: {
                ThemeCache.foregroundColors[0][1][0] = event.getColor();
                break;
            }
            case 14: {
                ThemeCache.foregroundColors[0][0][1] = event.getColor();
                break;
            }
            case 16: {
                ThemeCache.foregroundColors[0][1][1] = event.getColor();
                break;
            }
            case 18: {
                ThemeCache.foregroundColors[0][0][2] = event.getColor();
                break;
            }
            case 20: {
                ThemeCache.foregroundColors[0][1][2] = event.getColor();
                break;
            }
            case 22: {
                ThemeCache.foregroundColors[0][0][3] = event.getColor();
                break;
            }
            case 24: {
                ThemeCache.foregroundColors[0][1][3] = event.getColor();
                break;
            }
            case 26: {
                ThemeCache.foregroundColors[0][0][4] = event.getColor();
                break;
            }
            case 28: {
                ThemeCache.foregroundColors[0][1][4] = event.getColor();
                break;
            }
            case 6: {
                unmatchedForeground = event.getColor();
                break;
            }
            case 5: {
                unmatchedBackground = event.getColor();
                break;
            }
            case 1: {
                ThemeCache.backgroundColors[1][0] = event.getColor();
                break;
            }
            case 7: {
                ThemeCache.backgroundColors[1][1] = event.getColor();
                break;
            }
            case 2: {
                ThemeCache.backgroundColors[1][2] = event.getColor();
                break;
            }
            case 3: {
                ThemeCache.backgroundColors[0][0] = event.getColor();
                break;
            }
            case 8: {
                ThemeCache.backgroundColors[0][1] = event.getColor();
                break;
            }
            case 4: {
                ThemeCache.backgroundColors[0][2] = event.getColor();
                break;
            }
            case 57: {
                activeOutlineColor = event.getColor();
                break;
            }
            case 58: {
                inactiveOutlineColor = event.getColor();
                break;
            }
            case 59: {
                ThemeCache.backgroundColors[1][3] = event.getColor();
                break;
            }
            case 60: {
                ThemeCache.backgroundColors[0][3] = event.getColor();
                break;
            }
            default: {
                return;
            }
        }
        ThemeCache.fireColorChanged(event);
    }

    public void fontChanged(FontChangedEvent event) {
        switch (event.getFontId()) {
            case 0: {
                tableFont = event.getFont();
                break;
            }
            default: {
                return;
            }
        }
        ThemeCache.fireFontChanged(event);
    }

    static {
        instance = new ThemeCache();
        foregroundColors = new Color[2][2][6];
        backgroundColors = new Color[2][4];
        ThemeCache.backgroundColors[1][0] = ThemeManager.getCurrentColor(1);
        ThemeCache.backgroundColors[1][1] = ThemeManager.getCurrentColor(7);
        ThemeCache.backgroundColors[1][2] = ThemeManager.getCurrentColor(2);
        ThemeCache.backgroundColors[1][3] = ThemeManager.getCurrentColor(59);
        ThemeCache.backgroundColors[0][0] = ThemeManager.getCurrentColor(3);
        ThemeCache.backgroundColors[0][1] = ThemeManager.getCurrentColor(8);
        ThemeCache.backgroundColors[0][2] = ThemeManager.getCurrentColor(4);
        ThemeCache.backgroundColors[0][3] = ThemeManager.getCurrentColor(60);
        ThemeCache.foregroundColors[1][0][0] = ThemeManager.getCurrentColor(9);
        ThemeCache.foregroundColors[1][0][1] = ThemeManager.getCurrentColor(13);
        ThemeCache.foregroundColors[1][0][2] = ThemeManager.getCurrentColor(17);
        ThemeCache.foregroundColors[1][0][3] = ThemeManager.getCurrentColor(21);
        ThemeCache.foregroundColors[1][0][4] = ThemeManager.getCurrentColor(25);
        ThemeCache.foregroundColors[1][0][5] = ThemeManager.getCurrentColor(29);
        ThemeCache.foregroundColors[0][0][0] = ThemeManager.getCurrentColor(10);
        ThemeCache.foregroundColors[0][0][1] = ThemeManager.getCurrentColor(14);
        ThemeCache.foregroundColors[0][0][2] = ThemeManager.getCurrentColor(18);
        ThemeCache.foregroundColors[0][0][3] = ThemeManager.getCurrentColor(22);
        ThemeCache.foregroundColors[0][0][4] = ThemeManager.getCurrentColor(26);
        ThemeCache.foregroundColors[0][0][5] = ThemeManager.getCurrentColor(30);
        ThemeCache.foregroundColors[1][1][0] = ThemeManager.getCurrentColor(11);
        ThemeCache.foregroundColors[1][1][1] = ThemeManager.getCurrentColor(15);
        ThemeCache.foregroundColors[1][1][2] = ThemeManager.getCurrentColor(19);
        ThemeCache.foregroundColors[1][1][3] = ThemeManager.getCurrentColor(23);
        ThemeCache.foregroundColors[1][1][4] = ThemeManager.getCurrentColor(27);
        ThemeCache.foregroundColors[1][1][5] = ThemeManager.getCurrentColor(31);
        ThemeCache.foregroundColors[0][1][0] = ThemeManager.getCurrentColor(12);
        ThemeCache.foregroundColors[0][1][1] = ThemeManager.getCurrentColor(16);
        ThemeCache.foregroundColors[0][1][2] = ThemeManager.getCurrentColor(20);
        ThemeCache.foregroundColors[0][1][3] = ThemeManager.getCurrentColor(24);
        ThemeCache.foregroundColors[0][1][4] = ThemeManager.getCurrentColor(28);
        ThemeCache.foregroundColors[0][1][5] = ThemeManager.getCurrentColor(32);
        unmatchedForeground = ThemeManager.getCurrentColor(6);
        unmatchedBackground = ThemeManager.getCurrentColor(5);
        tableFont = ThemeManager.getCurrentFont(0);
        activeOutlineColor = ThemeManager.getCurrentColor(57);
        inactiveOutlineColor = ThemeManager.getCurrentColor(58);
        ThemeManager.addCurrentThemeListener(instance);
        listeners = new WeakHashMap();
    }
}

