/*
 * Decompiled with CFR 0.152.
 */
package com.mucommander.ui.theme;

import com.mucommander.ui.theme.ColorChangedEvent;
import com.mucommander.ui.theme.ComponentMapper;
import com.mucommander.ui.theme.DefaultColor;
import com.mucommander.ui.theme.DefaultFont;
import com.mucommander.ui.theme.FixedDefaultColor;
import com.mucommander.ui.theme.FontChangedEvent;
import com.mucommander.ui.theme.LinkedDefaultColor;
import com.mucommander.ui.theme.SystemDefaultColor;
import com.mucommander.ui.theme.SystemDefaultFont;
import com.mucommander.ui.theme.ThemeListener;
import java.awt.Color;
import java.awt.Font;
import java.util.Hashtable;
import java.util.Map;
import java.util.WeakHashMap;
import javax.swing.JComponent;
import javax.swing.JInternalFrame;
import javax.swing.JLabel;
import javax.swing.JTable;
import javax.swing.JTextArea;
import javax.swing.JTextField;

public class ThemeData {
    private static WeakHashMap<ThemeListener, ?> listeners = new WeakHashMap();
    private static final Map<Integer, DefaultColor> COLORS = new Hashtable<Integer, DefaultColor>();
    private static final Map<String, DefaultColor> DEFAULT_COLORS = new Hashtable<String, DefaultColor>();
    private static final Map<Integer, DefaultFont> FONTS = new Hashtable<Integer, DefaultFont>();
    private static final Map<String, DefaultFont> DEFAULT_FONTS = new Hashtable<String, DefaultFont>();
    private Color[] colors = new Color[68];
    private Font[] fonts = new Font[8];

    public static void registerDefaultColor(String name, DefaultColor color) {
        DEFAULT_COLORS.put(name, color);
    }

    public static void registerDefaultFont(String name, DefaultFont font) {
        DEFAULT_FONTS.put(name, font);
    }

    public static void registerColor(int id, String defaultColor) {
        DefaultColor color = DEFAULT_COLORS.get(defaultColor);
        if (color == null) {
            throw new IllegalArgumentException("Not a registered default color: " + defaultColor);
        }
        ThemeData.registerColor(id, color);
    }

    public static void registerFont(int id, String defaultFont) {
        DefaultFont font = DEFAULT_FONTS.get(defaultFont);
        if (font == null) {
            throw new IllegalArgumentException("Not a registered default font: " + defaultFont);
        }
        ThemeData.registerFont(id, font);
    }

    public static void registerColor(int id, Color color) {
        ThemeData.registerColor(id, new FixedDefaultColor(color));
    }

    public static void registerColor(int id, int defaultId) {
        ThemeData.registerColor(id, new LinkedDefaultColor(defaultId));
    }

    public static void registerColor(int id, DefaultColor color) {
        Integer colorId = id;
        COLORS.put(colorId, color);
        color.link(colorId);
    }

    public static void registerFont(int id, DefaultFont font) {
        Integer fontId = id;
        FONTS.put(fontId, font);
        font.link(fontId);
    }

    public ThemeData() {
    }

    ThemeData(ThemeData from) {
        this();
        this.fonts = from.fonts;
        this.colors = from.colors;
    }

    public ThemeData cloneData(boolean freezeDefaults) {
        int i;
        ThemeData data = new ThemeData();
        for (i = 0; i < 68; ++i) {
            data.colors[i] = freezeDefaults ? this.getColor(i) : this.colors[i];
        }
        for (i = 0; i < 8; ++i) {
            data.fonts[i] = freezeDefaults ? this.getFont(i) : this.fonts[i];
        }
        return data;
    }

    public ThemeData cloneData() {
        return this.cloneData(false);
    }

    public void importData(ThemeData data) {
        int i;
        for (i = 0; i < 68; ++i) {
            this.setColor(i, data.colors[i]);
        }
        for (i = 0; i < 8; ++i) {
            this.setFont(i, data.fonts[i]);
        }
    }

    public synchronized boolean setColor(int id, Color color) {
        boolean buffer = this.isColorDifferent(id, color);
        this.colors[id] = color;
        switch (id) {
            case 57: 
            case 58: 
            case 59: 
            case 60: {
                ThemeData.triggerColorEvent(id, color);
            }
        }
        return buffer;
    }

    public synchronized boolean setFont(int id, Font font) {
        boolean buffer = this.isFontDifferent(id, font);
        this.fonts[id] = font;
        return buffer;
    }

    public synchronized Color getColor(int id) {
        ThemeData.checkColorIdentifier(id);
        return this.colors[id] == null ? ThemeData.getDefaultColor(id, this) : this.colors[id];
    }

    public synchronized Font getFont(int id) {
        ThemeData.checkFontIdentifier(id);
        return this.fonts[id] == null ? ThemeData.getDefaultFont(id, this) : this.fonts[id];
    }

    public boolean isColorSet(int id) {
        return this.colors[id] != null;
    }

    public boolean isFontSet(int id) {
        return this.fonts[id] != null;
    }

    private static Color getDefaultColor(int id, ThemeData data) {
        ThemeData.checkColorIdentifier(id);
        return COLORS.get(id).getColor(data);
    }

    private static Font getDefaultFont(int id, ThemeData data) {
        ThemeData.checkFontIdentifier(id);
        return FONTS.get(id).getFont(data);
    }

    public boolean isIdentical(ThemeData data, boolean ignoreDefaults) {
        int i;
        for (i = 0; i < 68; ++i) {
            if (!this.isColorDifferent(i, data.colors[i], ignoreDefaults)) continue;
            return false;
        }
        for (i = 0; i < 8; ++i) {
            if (!this.isFontDifferent(i, data.fonts[i], ignoreDefaults)) continue;
            return false;
        }
        return true;
    }

    public boolean isIdentical(ThemeData data) {
        return this.isIdentical(data, false);
    }

    public boolean isFontDifferent(int id, Font font) {
        return this.isFontDifferent(id, font, false);
    }

    public synchronized boolean isFontDifferent(int id, Font font, boolean ignoreDefaults) {
        ThemeData.checkFontIdentifier(id);
        if (font == null) {
            return this.fonts[id] != null;
        }
        if (this.fonts[id] == null) {
            return ignoreDefaults || !ThemeData.getDefaultFont(id, this).equals(font);
        }
        return !font.equals(this.fonts[id]);
    }

    public boolean isColorDifferent(int id, Color color) {
        return this.isColorDifferent(id, color, false);
    }

    public synchronized boolean isColorDifferent(int id, Color color, boolean ignoreDefaults) {
        ThemeData.checkColorIdentifier(id);
        if (color == null) {
            return this.colors[id] != null;
        }
        if (this.colors[id] == null) {
            return ignoreDefaults || !ThemeData.getDefaultColor(id, this).equals(color);
        }
        return !color.equals(this.colors[id]);
    }

    public static void addDefaultValuesListener(ThemeListener listener) {
        listeners.put(listener, null);
    }

    static void triggerFontEvent(int id, Font font) {
        FontChangedEvent event = new FontChangedEvent(null, id, font);
        for (ThemeListener listener : listeners.keySet()) {
            listener.fontChanged(event);
        }
    }

    static void triggerColorEvent(int id, Color color) {
        ColorChangedEvent event = new ColorChangedEvent(null, id, color);
        for (ThemeListener listener : listeners.keySet()) {
            listener.colorChanged(event);
        }
    }

    private static void checkColorIdentifier(int id) {
        if (id < 0 || id >= 68) {
            throw new IllegalArgumentException("Illegal color identifier: " + id);
        }
    }

    private static void checkFontIdentifier(int id) {
        if (id < 0 || id >= 8) {
            throw new IllegalArgumentException("Illegal font identifier: " + id);
        }
    }

    static {
        ComponentMapper mapper = new ComponentMapper(){

            public JComponent getComponent() {
                return new JTextArea();
            }
        };
        ThemeData.registerDefaultFont("TextArea.font", new SystemDefaultFont("TextArea.font", mapper));
        ThemeData.registerDefaultColor("TextArea.foreground", new SystemDefaultColor(1, "TextArea.foreground", mapper));
        ThemeData.registerDefaultColor("TextArea.background", new SystemDefaultColor(2, "TextArea.background", mapper));
        ThemeData.registerDefaultColor("TextArea.selectionForeground", new SystemDefaultColor(3, "TextArea.selectionForeground", mapper));
        ThemeData.registerDefaultColor("TextArea.selectionBackground", new SystemDefaultColor(4, "TextArea.selectionBackground", mapper));
        mapper = new ComponentMapper(){

            public JComponent getComponent() {
                return new JTextField();
            }
        };
        ThemeData.registerDefaultFont("TextField.font", new SystemDefaultFont("TextField.font", mapper));
        ThemeData.registerDefaultColor("TextField.foreground", new SystemDefaultColor(1, "TextField.foreground", mapper));
        ThemeData.registerDefaultColor("TextField.background", new SystemDefaultColor(2, "TextField.background", mapper));
        ThemeData.registerDefaultColor("TextField.selectionForeground", new SystemDefaultColor(3, "TextField.selectionForeground", mapper));
        ThemeData.registerDefaultColor("TextField.selectionBackground", new SystemDefaultColor(4, "TextField.selectionBackground", mapper));
        ThemeData.registerDefaultColor("TextField.progress", new SystemDefaultColor(4, "TextField.selectionBackground", mapper){

            public Color getColor(ThemeData data) {
                Color color = super.getColor(data);
                return new Color(color.getRed(), color.getGreen(), color.getBlue(), 64);
            }
        });
        mapper = new ComponentMapper(){

            public JComponent getComponent() {
                return new JTable();
            }
        };
        ThemeData.registerDefaultFont("Table.font", new SystemDefaultFont("Table.font", mapper));
        ThemeData.registerDefaultColor("Table.foreground", new SystemDefaultColor(1, "Table.foreground", mapper));
        ThemeData.registerDefaultColor("Table.background", new SystemDefaultColor(2, "Table.background", mapper));
        ThemeData.registerDefaultColor("Table.selectionForeground", new SystemDefaultColor(3, "Table.selectionForeground", mapper));
        ThemeData.registerDefaultColor("Table.selectionBackground", new SystemDefaultColor(4, "Table.selectionBackground", mapper));
        ThemeData.registerDefaultColor("Table.unmatchedForeground", new SystemDefaultColor(1, "Table.foreground", mapper){

            public Color getColor(ThemeData data) {
                return super.getColor(data).darker();
            }
        });
        ThemeData.registerDefaultColor("Table.unmatchedBackground", new SystemDefaultColor(2, "Table.background", mapper){

            public Color getColor(ThemeData data) {
                return super.getColor(data).darker();
            }
        });
        mapper = new ComponentMapper(){

            public JComponent getComponent() {
                return new JInternalFrame();
            }
        };
        ThemeData.registerDefaultFont("MenuHeader.font", new SystemDefaultFont("InternalFrame.font", mapper));
        ThemeData.registerDefaultColor("MenuHeader.background", new SystemDefaultColor(2, "InternalFrame.activeTitleBackground", mapper));
        ThemeData.registerDefaultColor("MenuHeader.foreground", new SystemDefaultColor(1, "InternalFrame.activeTitleForeground", mapper));
        mapper = new ComponentMapper(){

            public JComponent getComponent() {
                return new JLabel();
            }
        };
        ThemeData.registerDefaultFont("Label.font", new SystemDefaultFont("Label.font", mapper));
        ThemeData.registerFont(7, "Table.font");
        ThemeData.registerFont(6, "MenuHeader.font");
        ThemeData.registerColor(62, "MenuHeader.background");
        ThemeData.registerColor(61, "MenuHeader.background");
        ThemeData.registerColor(63, "MenuHeader.foreground");
        ThemeData.registerColor(64, 1);
        ThemeData.registerColor(65, 29);
        ThemeData.registerColor(66, 7);
        ThemeData.registerColor(67, 31);
        ThemeData.registerColor(9, Color.GRAY);
        ThemeData.registerColor(13, "Table.foreground");
        ThemeData.registerColor(17, "Table.foreground");
        ThemeData.registerColor(21, "Table.foreground");
        ThemeData.registerColor(30, "Table.foreground");
        ThemeData.registerColor(10, Color.GRAY);
        ThemeData.registerColor(14, "Table.foreground");
        ThemeData.registerColor(18, "Table.foreground");
        ThemeData.registerColor(22, "Table.foreground");
        ThemeData.registerColor(29, "Table.foreground");
        ThemeData.registerColor(11, "Table.selectionForeground");
        ThemeData.registerColor(15, "Table.selectionForeground");
        ThemeData.registerColor(19, "Table.selectionForeground");
        ThemeData.registerColor(23, "Table.selectionForeground");
        ThemeData.registerColor(12, "Table.selectionForeground");
        ThemeData.registerColor(16, "Table.selectionForeground");
        ThemeData.registerColor(20, "Table.selectionForeground");
        ThemeData.registerColor(24, "Table.selectionForeground");
        ThemeData.registerColor(32, "Table.selectionForeground");
        ThemeData.registerColor(31, "Table.selectionForeground");
        ThemeData.registerFont(0, "Table.font");
        ThemeData.registerColor(1, "Table.background");
        ThemeData.registerColor(3, "Table.background");
        ThemeData.registerColor(2, "Table.background");
        ThemeData.registerColor(4, "Table.background");
        ThemeData.registerColor(7, "Table.selectionBackground");
        ThemeData.registerColor(8, "Table.selectionBackground");
        ThemeData.registerColor(6, "Table.unmatchedForeground");
        ThemeData.registerColor(5, "Table.unmatchedBackground");
        ThemeData.registerColor(51, new Color(0xD5D5D5));
        ThemeData.registerColor(25, Color.RED);
        ThemeData.registerColor(26, Color.RED);
        ThemeData.registerColor(27, Color.RED);
        ThemeData.registerColor(28, Color.RED);
        ThemeData.registerColor(0, Color.GRAY);
        ThemeData.registerColor(56, Color.GRAY);
        ThemeData.registerColor(59, 7);
        ThemeData.registerColor(57, 7);
        ThemeData.registerColor(60, 8);
        ThemeData.registerColor(58, 8);
        ThemeData.registerFont(1, "TextArea.font");
        ThemeData.registerFont(4, "TextField.font");
        ThemeData.registerColor(33, "TextArea.foreground");
        ThemeData.registerColor(34, "TextArea.background");
        ThemeData.registerColor(35, "TextArea.selectionForeground");
        ThemeData.registerColor(36, "TextArea.selectionBackground");
        ThemeData.registerColor(37, "TextField.foreground");
        ThemeData.registerColor(38, "TextField.background");
        ThemeData.registerColor(39, "TextField.selectionForeground");
        ThemeData.registerColor(40, "TextField.selectionBackground");
        ThemeData.registerFont(2, "TextArea.font");
        ThemeData.registerColor(41, "TextArea.foreground");
        ThemeData.registerColor(42, "TextArea.background");
        ThemeData.registerColor(43, "TextArea.selectionForeground");
        ThemeData.registerColor(44, "TextArea.selectionBackground");
        ThemeData.registerFont(3, "TextField.font");
        ThemeData.registerColor(45, "TextField.foreground");
        ThemeData.registerColor(46, "TextField.background");
        ThemeData.registerColor(47, "TextField.selectionForeground");
        ThemeData.registerColor(48, "TextField.selectionBackground");
        ThemeData.registerColor(49, "TextField.progress");
        ThemeData.registerFont(5, "Label.font");
        ThemeData.registerColor(50, "TextField.foreground");
        ThemeData.registerColor(55, Color.RED);
        ThemeData.registerColor(52, Color.GRAY);
        ThemeData.registerColor(51, new Color(0xD5D5D5));
        ThemeData.registerColor(53, new Color(7400491));
        ThemeData.registerColor(54, new Color(0xFF7F00));
    }
}

