/*
 * Decompiled with CFR 0.152.
 */
package com.mucommander.ui.theme;

import com.mucommander.PlatformManager;
import com.mucommander.commons.file.AbstractFile;
import com.mucommander.commons.file.FileFactory;
import com.mucommander.commons.file.filter.ExtensionFilenameFilter;
import com.mucommander.commons.file.util.ResourceLoader;
import com.mucommander.commons.io.StreamUtils;
import com.mucommander.commons.util.StringUtils;
import com.mucommander.conf.MuConfigurations;
import com.mucommander.conf.MuPreference;
import com.mucommander.io.backup.BackupInputStream;
import com.mucommander.io.backup.BackupOutputStream;
import com.mucommander.text.Translator;
import com.mucommander.ui.theme.ColorChangedEvent;
import com.mucommander.ui.theme.FontChangedEvent;
import com.mucommander.ui.theme.Theme;
import com.mucommander.ui.theme.ThemeData;
import com.mucommander.ui.theme.ThemeListener;
import com.mucommander.ui.theme.ThemeReader;
import com.mucommander.ui.theme.ThemeWriter;
import java.awt.Color;
import java.awt.Font;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.Iterator;
import java.util.Vector;
import java.util.WeakHashMap;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ThemeManager {
    private static final Logger LOGGER = LoggerFactory.getLogger(ThemeManager.class);
    private static AbstractFile userThemeFile;
    private static final WeakHashMap<ThemeListener, Object> listeners;
    private static final String[] PREDEFINED_THEME_NAMES;
    private static boolean wasUserThemeModified;
    private static Theme currentTheme;
    private static ThemeListener listener;

    private ThemeManager() {
    }

    public static void loadCurrentTheme() {
        String name;
        boolean wasUserThemeLoaded;
        int type;
        try {
            type = ThemeManager.getThemeTypeFromLabel(MuConfigurations.getPreferences().getVariable(MuPreference.THEME_TYPE, "predefined"));
        }
        catch (Exception e) {
            type = ThemeManager.getThemeTypeFromLabel("predefined");
        }
        if (type != 0) {
            wasUserThemeLoaded = false;
            name = MuConfigurations.getPreferences().getVariable(MuPreference.THEME_NAME, "Native");
        } else {
            name = null;
            wasUserThemeLoaded = true;
        }
        currentTheme = null;
        try {
            currentTheme = ThemeManager.readTheme(type, name);
        }
        catch (Exception e1) {
            block12: {
                type = ThemeManager.getThemeTypeFromLabel("predefined");
                name = "Native";
                if (type == 0) {
                    wasUserThemeLoaded = true;
                }
                try {
                    currentTheme = ThemeManager.readTheme(type, name);
                }
                catch (Exception e2) {
                    if (!wasUserThemeLoaded) {
                        try {
                            currentTheme = ThemeManager.readTheme(0, null);
                        }
                        catch (Exception e3) {
                            // empty catch block
                        }
                    }
                    if (currentTheme != null) break block12;
                    currentTheme = new Theme(listener);
                    wasUserThemeModified = true;
                }
            }
            ThemeManager.setConfigurationTheme(currentTheme);
        }
    }

    private static Iterator<String> predefinedThemeNames() {
        return Arrays.asList(PREDEFINED_THEME_NAMES).iterator();
    }

    private static Iterator<String> customThemeNames() throws IOException {
        return ThemeManager.getThemeNames(FileFactory.getFile(ThemeManager.getCustomThemesFolder().getAbsolutePath()));
    }

    private static Iterator<String> getThemeNames(AbstractFile themeFolder) {
        try {
            AbstractFile[] files = themeFolder.ls(new ExtensionFilenameFilter(".xml"));
            Vector<String> names = new Vector<String>();
            for (AbstractFile file : files) {
                names.add(ThemeManager.getThemeName(file));
            }
            return names.iterator();
        }
        catch (Exception e) {
            return new Vector().iterator();
        }
    }

    public static Vector<Theme> getAvailableThemes() {
        String name;
        Vector<Theme> themes = new Vector<Theme>();
        try {
            themes.add(ThemeManager.readTheme(0, null));
        }
        catch (Exception e) {
            themes.add(new Theme(listener));
        }
        Iterator<String> iterator = ThemeManager.predefinedThemeNames();
        while (iterator.hasNext()) {
            name = iterator.next();
            try {
                themes.add(ThemeManager.readTheme(1, name));
            }
            catch (Exception e) {
                LOGGER.warn("Failed to load predefined theme " + name, e);
            }
        }
        try {
            iterator = ThemeManager.customThemeNames();
            while (iterator.hasNext()) {
                name = iterator.next();
                try {
                    themes.add(ThemeManager.readTheme(2, name));
                }
                catch (Exception e) {
                    LOGGER.warn("Failed to load custom theme " + name, e);
                }
            }
        }
        catch (Exception e) {
            LOGGER.warn("Failed to load custom themes", e);
        }
        Collections.sort(themes, new Comparator<Theme>(){

            @Override
            public int compare(Theme t1, Theme t2) {
                return t1.getName().compareTo(t2.getName());
            }
        });
        return themes;
    }

    public static Vector<String> getAvailableThemeNames() {
        Vector<String> themes = new Vector<String>();
        themes.add(Translator.get("theme.custom_theme", new String[0]));
        Iterator<String> iterator = ThemeManager.predefinedThemeNames();
        while (iterator.hasNext()) {
            themes.add(iterator.next());
        }
        try {
            iterator = ThemeManager.customThemeNames();
            while (iterator.hasNext()) {
                themes.add(iterator.next());
            }
        }
        catch (Exception e) {
            LOGGER.debug("Failed to load custom theme names", e);
        }
        Collections.sort(themes);
        return themes;
    }

    public static synchronized Iterator<Theme> availableThemes() {
        return ThemeManager.getAvailableThemes().iterator();
    }

    public static AbstractFile getUserThemeFile() throws IOException {
        if (userThemeFile == null) {
            return PlatformManager.getPreferencesFolder().getChild("user_theme.xml");
        }
        return userThemeFile;
    }

    public static AbstractFile getCustomThemesFolder() throws IOException {
        AbstractFile customFolder = PlatformManager.getPreferencesFolder().getChild("themes");
        if (!customFolder.exists()) {
            customFolder.mkdir();
        }
        return customFolder;
    }

    public static void deleteCustomTheme(String name) throws IOException {
        if (ThemeManager.isCurrentTheme(2, name)) {
            throw new IllegalArgumentException("Cannot delete current theme.");
        }
        AbstractFile file = ThemeManager.getCustomThemesFolder().getChild(name + ".xml");
        if (file.exists()) {
            file.delete();
        }
    }

    public static void renameCustomTheme(Theme theme, String name) throws IOException {
        if (theme.getType() != 2) {
            throw new IllegalArgumentException("Cannot rename non-custom themes.");
        }
        if (theme.getName().equals(name)) {
            return;
        }
        name = ThemeManager.getAvailableCustomThemeName(name);
        ThemeManager.getCustomThemesFolder().getChild(theme.getName() + ".xml").renameTo(ThemeManager.getCustomThemesFolder().getChild(name + ".xml"));
        theme.setName(name);
        if (ThemeManager.isCurrentTheme(theme)) {
            ThemeManager.setConfigurationTheme(theme);
        }
    }

    private static BackupOutputStream getCustomThemeOutputStream(String name) throws IOException {
        return new BackupOutputStream(ThemeManager.getCustomThemesFolder().getChild(name + ".xml"));
    }

    private static BackupOutputStream getUserThemeOutputStream() throws IOException {
        return new BackupOutputStream(ThemeManager.getUserThemeFile());
    }

    private static BackupOutputStream getOutputStream(int type, String name) throws IOException {
        switch (type) {
            case 1: {
                throw new IllegalArgumentException("Can not open output streams on predefined themes.");
            }
            case 2: {
                return ThemeManager.getCustomThemeOutputStream(name);
            }
            case 0: {
                return ThemeManager.getUserThemeOutputStream();
            }
        }
        throw new IllegalArgumentException("Illegal theme type: " + type);
    }

    public static void writeThemeData(ThemeData data, OutputStream out) throws IOException {
        ThemeWriter.write(data, out);
    }

    public static void writeTheme(Theme theme) throws IOException {
        ThemeManager.writeTheme(theme, theme.getType(), theme.getName());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void writeTheme(ThemeData data, int type, String name) throws IOException {
        BackupOutputStream out = null;
        try {
            out = ThemeManager.getOutputStream(type, name);
            ThemeManager.writeThemeData(data, out);
        }
        finally {
            if (out != null) {
                try {
                    ((OutputStream)out).close();
                }
                catch (Exception e) {}
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void exportTheme(int type, String name, OutputStream out) throws IOException {
        InputStream in = null;
        try {
            in = ThemeManager.getInputStream(type, name);
            StreamUtils.copyStream(in, out);
        }
        finally {
            if (in != null) {
                try {
                    in.close();
                }
                catch (Exception e) {}
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void exportTheme(int type, String name, File file) throws IOException {
        OutputStream out = null;
        try {
            out = new FileOutputStream(file);
            ThemeManager.exportTheme(type, name, out);
        }
        finally {
            if (out != null) {
                try {
                    out.close();
                }
                catch (Exception e) {}
            }
        }
    }

    public static void exportTheme(Theme theme, File file) throws IOException {
        ThemeManager.exportTheme(theme.getType(), theme.getName(), file);
    }

    private static String getAvailableCustomThemeName(File file) {
        String name = file.getName();
        if (StringUtils.endsWithIgnoreCase(name, ".xml")) {
            name = name.substring(0, name.length() - 4);
        }
        return ThemeManager.getAvailableCustomThemeName(name);
    }

    private static boolean isNameAvailable(String name, Iterator<String> names) {
        while (names.hasNext()) {
            if (!names.next().equals(name)) continue;
            return false;
        }
        return true;
    }

    private static String getAvailableCustomThemeName(String name) {
        String buffer;
        Vector<String> names = ThemeManager.getAvailableThemeNames();
        if (ThemeManager.isNameAvailable(name, names.iterator())) {
            return name;
        }
        if ((name = name.replaceFirst("\\([0-9]+\\)$", "")).charAt(name.length() - 1) != ' ') {
            name = name + ' ';
        }
        int i = 1;
        while (!ThemeManager.isNameAvailable(buffer = name + '(' + ++i + ')', names.iterator())) {
        }
        return buffer;
    }

    public static Theme duplicateTheme(Theme theme) throws IOException, Exception {
        return ThemeManager.importTheme(theme.cloneData(), theme.getName());
    }

    public static Theme importTheme(ThemeData data, String name) throws IOException, Exception {
        name = ThemeManager.getAvailableCustomThemeName(name);
        ThemeManager.writeTheme(data, 2, name);
        return new Theme(listener, data, 2, name);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Theme importTheme(File file) throws IOException, Exception {
        ThemeData data = ThemeManager.readThemeData(file);
        String name = ThemeManager.getAvailableCustomThemeName(file);
        OutputStream out = null;
        FileInputStream in = null;
        try {
            in = new FileInputStream(file);
            out = ThemeManager.getCustomThemeOutputStream(name);
            StreamUtils.copyStream(in, out);
        }
        finally {
            if (in != null) {
                try {
                    ((InputStream)in).close();
                }
                catch (Exception e) {}
            }
            if (out != null) {
                try {
                    out.close();
                }
                catch (Exception e) {}
            }
        }
        return new Theme(listener, data, 2, name);
    }

    private static InputStream getUserThemeInputStream() throws IOException {
        return new BackupInputStream(ThemeManager.getUserThemeFile());
    }

    private static InputStream getPredefinedThemeInputStream(String name) throws IOException {
        return ResourceLoader.getResourceAsStream("/themes/" + name + ".xml");
    }

    private static InputStream getCustomThemeInputStream(String name) throws IOException {
        return new BackupInputStream(ThemeManager.getCustomThemesFolder().getChild(name + ".xml"));
    }

    private static InputStream getInputStream(int type, String name) throws IOException {
        switch (type) {
            case 0: {
                return ThemeManager.getUserThemeInputStream();
            }
            case 1: {
                return ThemeManager.getPredefinedThemeInputStream(name);
            }
            case 2: {
                return ThemeManager.getCustomThemeInputStream(name);
            }
        }
        throw new IllegalArgumentException("Illegal theme type: " + type);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Theme readTheme(int type, String name) throws Exception {
        ThemeData data;
        if (currentTheme != null && ThemeManager.isCurrentTheme(type, name)) {
            return currentTheme;
        }
        InputStream in = null;
        try {
            in = ThemeManager.getInputStream(type, name);
            data = ThemeManager.readThemeData(in);
        }
        finally {
            if (in != null) {
                try {
                    in.close();
                }
                catch (Exception e) {}
            }
        }
        return new Theme(listener, data, type, name);
    }

    public static ThemeData readThemeData(InputStream in) throws Exception {
        ThemeData data = new ThemeData();
        ThemeReader.read(in, data);
        return data;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static ThemeData readThemeData(File file) throws Exception {
        FileInputStream in = null;
        try {
            in = new FileInputStream(file);
            ThemeData themeData = ThemeManager.readThemeData(in);
            return themeData;
        }
        finally {
            if (in != null) {
                try {
                    ((InputStream)in).close();
                }
                catch (Exception exception) {}
            }
        }
    }

    private static void setConfigurationTheme(int type, String name) {
        switch (type) {
            case 0: {
                MuConfigurations.getPreferences().setVariable(MuPreference.THEME_TYPE, "user");
                MuConfigurations.getPreferences().setVariable(MuPreference.THEME_NAME, null);
                break;
            }
            case 1: {
                MuConfigurations.getPreferences().setVariable(MuPreference.THEME_TYPE, "predefined");
                MuConfigurations.getPreferences().setVariable(MuPreference.THEME_NAME, name);
                break;
            }
            case 2: {
                MuConfigurations.getPreferences().setVariable(MuPreference.THEME_TYPE, "custom");
                MuConfigurations.getPreferences().setVariable(MuPreference.THEME_NAME, name);
                break;
            }
            default: {
                throw new IllegalStateException("Illegal theme type: " + type);
            }
        }
    }

    private static void setConfigurationTheme(Theme theme) {
        ThemeManager.setConfigurationTheme(theme.getType(), theme.getName());
    }

    public static void saveCurrentTheme() throws IOException {
        if (currentTheme == null) {
            return;
        }
        if (currentTheme.getType() == 0 && wasUserThemeModified) {
            ThemeManager.writeTheme(currentTheme);
            wasUserThemeModified = false;
        }
    }

    public static Theme getCurrentTheme() {
        return currentTheme;
    }

    public static synchronized void setCurrentTheme(Theme theme) {
        if (ThemeManager.isCurrentTheme(theme)) {
            return;
        }
        try {
            ThemeManager.saveCurrentTheme();
        }
        catch (IOException e) {
            LOGGER.warn("Couldn't save current theme", e);
        }
        Theme oldTheme = currentTheme;
        currentTheme = theme;
        ThemeManager.setConfigurationTheme(currentTheme);
        ThemeManager.triggerThemeChange(oldTheme, currentTheme);
    }

    public static synchronized Font getCurrentFont(int id) {
        return currentTheme.getFont(id);
    }

    public static synchronized Color getCurrentColor(int id) {
        return currentTheme.getColor(id);
    }

    public static synchronized Theme overwriteUserTheme(ThemeData themeData) throws IOException {
        if (currentTheme.getType() == 0) {
            currentTheme.importData(themeData);
            ThemeManager.writeTheme(currentTheme);
            return currentTheme;
        }
        ThemeManager.writeTheme(themeData, 0, null);
        return new Theme(listener, themeData);
    }

    public static boolean isCurrentTheme(Theme theme) {
        return theme == currentTheme;
    }

    private static boolean isCurrentTheme(int type, String name) {
        if (type != currentTheme.getType()) {
            return false;
        }
        if (type == 0) {
            return true;
        }
        return name.equals(currentTheme.getName());
    }

    private static void triggerThemeChange(Theme oldTheme, Theme newTheme) {
        int i;
        for (i = 0; i < 8; ++i) {
            if (!oldTheme.isFontDifferent(i, newTheme.getFont(i))) continue;
            ThemeManager.triggerFontEvent(new FontChangedEvent(currentTheme, i, newTheme.getFont(i)));
        }
        for (i = 0; i < 68; ++i) {
            if (!oldTheme.isColorDifferent(i, newTheme.getColor(i))) continue;
            ThemeManager.triggerColorEvent(new ColorChangedEvent(currentTheme, i, newTheme.getColor(i)));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void addCurrentThemeListener(ThemeListener listener) {
        WeakHashMap<ThemeListener, Object> weakHashMap = listeners;
        synchronized (weakHashMap) {
            listeners.put(listener, null);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void triggerFontEvent(FontChangedEvent event) {
        WeakHashMap<ThemeListener, Object> weakHashMap = listeners;
        synchronized (weakHashMap) {
            for (ThemeListener listener : listeners.keySet()) {
                listener.fontChanged(event);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void triggerColorEvent(ColorChangedEvent event) {
        WeakHashMap<ThemeListener, Object> weakHashMap = listeners;
        synchronized (weakHashMap) {
            for (ThemeListener listener : listeners.keySet()) {
                listener.colorChanged(event);
            }
        }
    }

    private static int getThemeTypeFromLabel(String label) {
        if (label.equals("user")) {
            return 0;
        }
        if (label.equals("predefined")) {
            return 1;
        }
        if (label.equals("custom")) {
            return 2;
        }
        throw new IllegalStateException("Unknown theme type: " + label);
    }

    private static String getThemeName(AbstractFile themeFile) {
        return themeFile.getNameWithoutExtension();
    }

    static {
        listeners = new WeakHashMap();
        PREDEFINED_THEME_NAMES = new String[]{"ClassicCommander", "Native", "RetroCommander", "Striped"};
        listener = new CurrentThemeListener();
    }

    private static class CurrentThemeListener
    implements ThemeListener {
        private CurrentThemeListener() {
        }

        public void fontChanged(FontChangedEvent event) {
            if (event.getSource().getType() == 0) {
                wasUserThemeModified = true;
            }
            if (event.getSource() == currentTheme) {
                ThemeManager.triggerFontEvent(event);
            }
        }

        public void colorChanged(ColorChangedEvent event) {
            if (event.getSource().getType() == 0) {
                wasUserThemeModified = true;
            }
            if (event.getSource() == currentTheme) {
                ThemeManager.triggerColorEvent(event);
            }
        }
    }
}

