/*
 * Decompiled with CFR 0.152.
 */
package com.mucommander.ui.viewer;

import com.mucommander.commons.file.AbstractFile;
import com.mucommander.commons.runtime.OsFamilies;
import com.mucommander.commons.runtime.OsVersions;
import com.mucommander.text.Translator;
import com.mucommander.ui.dialog.QuestionDialog;
import com.mucommander.ui.main.MainFrame;
import com.mucommander.ui.main.WindowManager;
import com.mucommander.ui.viewer.EditorFactory;
import com.mucommander.ui.viewer.EditorFrame;
import com.mucommander.ui.viewer.FileEditor;
import com.mucommander.ui.viewer.FileFrame;
import com.mucommander.ui.viewer.UserCancelledException;
import com.mucommander.ui.viewer.WarnUserException;
import com.mucommander.ui.viewer.text.TextFactory;
import java.awt.Frame;
import java.awt.Image;
import java.util.List;
import java.util.Vector;

public class EditorRegistrar {
    private static final List<EditorFactory> editorFactories = new Vector<EditorFactory>();

    public static void registerFileEditor(EditorFactory factory) {
        editorFactories.add(factory);
    }

    public static FileFrame createEditorFrame(MainFrame mainFrame, AbstractFile file, Image icon) {
        EditorFrame frame = new EditorFrame(mainFrame, file, icon);
        if (OsFamilies.MAC_OS_X.isCurrent() && OsVersions.MAC_OS_X_10_5.isCurrentOrHigher() && file.getURL().getScheme().equals("file")) {
            frame.getRootPane().putClientProperty("Window.documentFile", file.getUnderlyingFileObject());
        }
        frame.addWindowListener(WindowManager.getInstance());
        return frame;
    }

    public static FileEditor createFileEditor(AbstractFile file, EditorFrame frame) throws UserCancelledException, Exception {
        FileEditor editor = null;
        for (EditorFactory factory : editorFactories) {
            try {
                if (!factory.canEditFile(file)) continue;
                editor = factory.createFileEditor();
                break;
            }
            catch (WarnUserException e) {
                QuestionDialog dialog = new QuestionDialog((Frame)null, Translator.get("warning", new String[0]), Translator.get(e.getMessage(), new String[0]), null, new String[]{Translator.get("file_editor.open_anyway", new String[0]), Translator.get("cancel", new String[0])}, new int[]{0, 1}, 0);
                int ret = dialog.getActionValue();
                if (ret == 1 || ret == -1) {
                    throw new UserCancelledException();
                }
                editor = factory.createFileEditor();
            }
        }
        if (editor == null) {
            throw new Exception("No suitable editor found");
        }
        editor.setFrame(frame);
        return editor;
    }

    static {
        EditorRegistrar.registerFileEditor(new TextFactory());
    }
}

