/*
 * Decompiled with CFR 0.152.
 */
package com.mucommander.ui.viewer;

import com.mucommander.commons.file.AbstractFile;
import com.mucommander.commons.runtime.OsFamilies;
import com.mucommander.commons.runtime.OsVersions;
import com.mucommander.text.Translator;
import com.mucommander.ui.dialog.QuestionDialog;
import com.mucommander.ui.main.MainFrame;
import com.mucommander.ui.main.WindowManager;
import com.mucommander.ui.viewer.FileFrame;
import com.mucommander.ui.viewer.FileViewer;
import com.mucommander.ui.viewer.UserCancelledException;
import com.mucommander.ui.viewer.ViewerFactory;
import com.mucommander.ui.viewer.ViewerFrame;
import com.mucommander.ui.viewer.WarnUserException;
import com.mucommander.ui.viewer.image.ImageFactory;
import com.mucommander.ui.viewer.text.TextFactory;
import java.awt.Component;
import java.awt.Frame;
import java.awt.Image;
import java.util.List;
import java.util.Vector;

public class ViewerRegistrar {
    private static final List<ViewerFactory> viewerFactories = new Vector<ViewerFactory>();

    public static void registerFileViewer(ViewerFactory factory) {
        viewerFactories.add(factory);
    }

    public static FileFrame createViewerFrame(MainFrame mainFrame, AbstractFile file, Image icon) {
        ViewerFrame frame = new ViewerFrame(mainFrame, file, icon);
        if (OsFamilies.MAC_OS_X.isCurrent() && OsVersions.MAC_OS_X_10_5.isCurrentOrHigher() && file.getURL().getScheme().equals("file")) {
            frame.getRootPane().putClientProperty("Window.documentFile", file.getUnderlyingFileObject());
        }
        frame.addWindowListener(WindowManager.getInstance());
        return frame;
    }

    public static FileViewer createFileViewer(AbstractFile file, ViewerFrame frame) throws UserCancelledException, Exception {
        FileViewer viewer = null;
        for (ViewerFactory factory : viewerFactories) {
            try {
                if (!factory.canViewFile(file)) continue;
                viewer = factory.createFileViewer();
                break;
            }
            catch (WarnUserException e) {
                QuestionDialog dialog = new QuestionDialog((Frame)null, Translator.get("warning", new String[0]), Translator.get(e.getMessage(), new String[0]), (Component)frame, new String[]{Translator.get("file_editor.open_anyway", new String[0]), Translator.get("cancel", new String[0])}, new int[]{0, 1}, 0);
                int ret = dialog.getActionValue();
                if (ret == 1 || ret == -1) {
                    throw new UserCancelledException();
                }
                viewer = factory.createFileViewer();
            }
        }
        if (viewer == null) {
            throw new Exception("No suitable viewer found");
        }
        viewer.setFrame(frame);
        return viewer;
    }

    static {
        ViewerRegistrar.registerFileViewer(new ImageFactory());
        ViewerRegistrar.registerFileViewer(new TextFactory());
    }
}

