/*
 * Decompiled with CFR 0.152.
 */
package com.mucommander.ui.viewer.image;

import com.mucommander.commons.file.AbstractFile;
import com.mucommander.text.Translator;
import com.mucommander.ui.helper.MenuToolkit;
import com.mucommander.ui.helper.MnemonicHelper;
import com.mucommander.ui.theme.ColorChangedEvent;
import com.mucommander.ui.theme.FontChangedEvent;
import com.mucommander.ui.theme.ThemeListener;
import com.mucommander.ui.theme.ThemeManager;
import com.mucommander.ui.viewer.FileFrame;
import com.mucommander.ui.viewer.FileViewer;
import java.awt.Color;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.MediaTracker;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JPanel;
import javax.swing.KeyStroke;

class ImageViewer
extends FileViewer
implements ActionListener {
    private Image image;
    private Image scaledImage;
    private double zoomFactor;
    private JMenu controlsMenu;
    private JMenuItem zoomInItem;
    private JMenuItem zoomOutItem;
    private ImageViewerImpl imageViewerImpl = new ImageViewerImpl();

    public ImageViewer() {
        this.setComponentToPresent(this.imageViewerImpl);
        MnemonicHelper menuMnemonicHelper = new MnemonicHelper();
        this.controlsMenu = MenuToolkit.addMenu(Translator.get("image_viewer.controls_menu", new String[0]), menuMnemonicHelper, null);
        this.zoomInItem = MenuToolkit.addMenuItem(this.controlsMenu, Translator.get("image_viewer.zoom_in", new String[0]), menuMnemonicHelper, KeyStroke.getKeyStroke(107, 0), this);
        this.zoomOutItem = MenuToolkit.addMenuItem(this.controlsMenu, Translator.get("image_viewer.zoom_out", new String[0]), menuMnemonicHelper, KeyStroke.getKeyStroke(109, 0), this);
    }

    public JMenuBar getMenuBar() {
        JMenuBar menuBar = super.getMenuBar();
        menuBar.add(this.controlsMenu);
        return menuBar;
    }

    private synchronized void loadImage(AbstractFile file) throws IOException {
        int read;
        FileFrame frame = this.getFrame();
        frame.setCursor(new Cursor(3));
        byte[] buffer = new byte[1024];
        ByteArrayOutputStream bout = new ByteArrayOutputStream();
        InputStream in = file.getInputStream();
        while ((read = in.read(buffer, 0, buffer.length)) != -1) {
            bout.write(buffer, 0, read);
        }
        byte[] imageBytes = bout.toByteArray();
        bout.close();
        in.close();
        this.scaledImage = null;
        this.image = this.imageViewerImpl.getToolkit().createImage(imageBytes);
        this.waitForImage(this.image);
        int width = this.image.getWidth(null);
        int height = this.image.getHeight(null);
        this.zoomFactor = 1.0;
        Dimension d = Toolkit.getDefaultToolkit().getScreenSize();
        while (width > d.width || height > d.height) {
            width /= 2;
            height /= 2;
            this.zoomFactor /= 2.0;
        }
        if (this.zoomFactor == 1.0) {
            this.scaledImage = this.image;
        } else {
            this.zoom(this.zoomFactor);
        }
        this.checkZoom();
        frame.setCursor(Cursor.getDefaultCursor());
    }

    private void waitForImage(Image image) {
        MediaTracker tracker = new MediaTracker(this.imageViewerImpl);
        tracker.addImage(image, 0);
        try {
            tracker.waitForID(0);
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
        tracker.removeImage(image);
    }

    private synchronized void zoom(double factor) {
        FileFrame frame = this.getFrame();
        frame.setCursor(new Cursor(3));
        this.scaledImage = this.image.getScaledInstance((int)((double)this.image.getWidth(null) * factor), (int)((double)this.image.getHeight(null) * factor), 1);
        this.waitForImage(this.scaledImage);
        frame.setCursor(Cursor.getDefaultCursor());
    }

    private void updateFrame() {
        FileFrame frame = this.getFrame();
        frame.setTitle(this.getTitle());
        this.imageViewerImpl.revalidate();
        frame.pack();
        frame.getContentPane().repaint();
    }

    private void checkZoom() {
        Dimension d = Toolkit.getDefaultToolkit().getScreenSize();
        this.zoomInItem.setEnabled(this.zoomFactor < 1.0 || 2.0 * this.zoomFactor * (double)this.image.getWidth(null) < (double)d.width && 2.0 * this.zoomFactor * (double)this.image.getHeight(null) < (double)d.height);
        this.zoomOutItem.setEnabled(this.zoomFactor > 1.0 || this.zoomFactor / 2.0 * (double)this.image.getWidth(null) > 160.0 && this.zoomFactor / 2.0 * (double)this.image.getHeight(null) > 120.0);
    }

    public void show(AbstractFile file) throws IOException {
        this.loadImage(file);
    }

    public String getTitle() {
        return super.getTitle() + " - " + this.image.getWidth(null) + "x" + this.image.getHeight(null) + " - " + (int)(this.zoomFactor * 100.0) + "%";
    }

    public void actionPerformed(ActionEvent e) {
        Object source = e.getSource();
        if (source == this.zoomInItem && this.zoomInItem.isEnabled()) {
            this.zoomFactor *= 2.0;
            this.zoom(this.zoomFactor);
            this.updateFrame();
        } else if (source == this.zoomOutItem && this.zoomOutItem.isEnabled()) {
            this.zoomFactor /= 2.0;
            this.zoom(this.zoomFactor);
            this.updateFrame();
        } else {
            super.actionPerformed(e);
            return;
        }
        this.checkZoom();
    }

    private class ImageViewerImpl
    extends JPanel
    implements ThemeListener {
        private Color backgroundColor = ThemeManager.getCurrentColor(42);

        ImageViewerImpl() {
            ThemeManager.addCurrentThemeListener(this);
        }

        public void paint(Graphics g) {
            int width = this.getWidth();
            int height = this.getHeight();
            g.setColor(this.backgroundColor);
            g.fillRect(0, 0, width, height);
            if (ImageViewer.this.scaledImage != null) {
                int imageWidth = ImageViewer.this.scaledImage.getWidth(null);
                int imageHeight = ImageViewer.this.scaledImage.getHeight(null);
                g.drawImage(ImageViewer.this.scaledImage, Math.max(0, (width - imageWidth) / 2), Math.max(0, (height - imageHeight) / 2), null);
            }
        }

        public synchronized Dimension getPreferredSize() {
            return new Dimension(ImageViewer.this.scaledImage.getWidth(null), ImageViewer.this.scaledImage.getHeight(null));
        }

        public void colorChanged(ColorChangedEvent event) {
            if (event.getColorId() == 42) {
                this.backgroundColor = event.getColor();
                this.repaint();
            }
        }

        public void fontChanged(FontChangedEvent event) {
        }
    }
}

