/*
 * Decompiled with CFR 0.152.
 */
package com.mucommander.ui.viewer.text;

import com.mucommander.ui.theme.ColorChangedEvent;
import com.mucommander.ui.theme.FontChangedEvent;
import com.mucommander.ui.theme.ThemeListener;
import com.mucommander.ui.theme.ThemeManager;
import com.mucommander.ui.viewer.text.FindDialog;
import java.awt.Font;
import java.awt.Insets;
import java.awt.Toolkit;
import java.awt.event.MouseWheelEvent;
import java.awt.event.MouseWheelListener;
import java.io.BufferedWriter;
import java.io.IOException;
import java.io.Reader;
import java.io.Writer;
import javax.swing.JFrame;
import javax.swing.JTextArea;
import javax.swing.event.DocumentListener;
import javax.swing.text.BadLocationException;
import javax.swing.text.Document;

class TextEditorImpl
implements ThemeListener {
    private String searchString;
    private JFrame frame;
    private JTextArea textArea;

    public TextEditorImpl(boolean isEditable) {
        this.initTextArea(isEditable);
        ThemeManager.addCurrentThemeListener(this);
    }

    private void initTextArea(boolean isEditable) {
        this.textArea = new JTextArea(){

            public Insets getInsets() {
                return new Insets(4, 3, 4, 3);
            }
        };
        this.textArea.setEditable(isEditable);
        this.textArea.setForeground(ThemeManager.getCurrentColor(41));
        this.textArea.setCaretColor(ThemeManager.getCurrentColor(41));
        this.textArea.setBackground(ThemeManager.getCurrentColor(42));
        this.textArea.setSelectedTextColor(ThemeManager.getCurrentColor(43));
        this.textArea.setSelectionColor(ThemeManager.getCurrentColor(44));
        this.textArea.setFont(ThemeManager.getCurrentFont(2));
        this.textArea.setWrapStyleWord(true);
        this.textArea.addMouseWheelListener(new MouseWheelListener(){

            public void mouseWheelMoved(MouseWheelEvent e) {
                boolean isCtrlPressed;
                boolean bl = isCtrlPressed = (e.getModifiers() & 2) != 0;
                if (isCtrlPressed) {
                    boolean rotationUp;
                    Font currentFont = TextEditorImpl.this.textArea.getFont();
                    int currentFontSize = currentFont.getSize();
                    boolean bl2 = rotationUp = e.getWheelRotation() < 0;
                    if (!rotationUp && currentFontSize > 1 || rotationUp) {
                        Font newFont = new Font(currentFont.getName(), currentFont.getStyle(), currentFontSize + (rotationUp ? 1 : -1));
                        TextEditorImpl.this.textArea.setFont(newFont);
                    }
                } else {
                    TextEditorImpl.this.textArea.getParent().dispatchEvent(e);
                }
            }
        });
    }

    void find() {
        FindDialog findDialog = new FindDialog(this.frame);
        if (findDialog.wasValidated()) {
            this.searchString = findDialog.getSearchString().toLowerCase();
            if (!this.searchString.equals("")) {
                this.doSearch(0, true);
            }
        }
        this.textArea.requestFocus();
    }

    void findNext() {
        this.doSearch(this.textArea.getSelectionEnd(), true);
    }

    void findPrevious() {
        this.doSearch(this.textArea.getSelectionStart() - 1, false);
    }

    private String getTextLC() {
        return this.textArea.getText().toLowerCase();
    }

    private void doSearch(int startPos, boolean forward) {
        if (this.searchString == null || this.searchString.length() == 0) {
            return;
        }
        int pos = forward ? this.getTextLC().indexOf(this.searchString, startPos) : this.getTextLC().lastIndexOf(this.searchString, startPos);
        if (pos >= 0) {
            this.textArea.select(pos, pos + this.searchString.length());
        } else {
            new Thread(){

                public void run() {
                    Toolkit.getDefaultToolkit().beep();
                }
            }.start();
        }
    }

    public boolean isWrap() {
        return this.textArea.getLineWrap();
    }

    void wrap(boolean isWrap) {
        this.textArea.setLineWrap(isWrap);
        this.textArea.repaint();
    }

    void copy() {
        this.textArea.copy();
    }

    void cut() {
        this.textArea.cut();
    }

    void paste() {
        this.textArea.paste();
    }

    void selectAll() {
        this.textArea.selectAll();
    }

    JTextArea getTextArea() {
        return this.textArea;
    }

    void addDocumentListener(DocumentListener documentListener) {
        this.textArea.getDocument().addDocumentListener(documentListener);
    }

    void read(Reader reader) throws IOException {
        this.textArea.read(reader, null);
        this.textArea.setCaretPosition(0);
    }

    void write(Writer writer) throws IOException {
        Document document = this.textArea.getDocument();
        try {
            this.textArea.getUI().getEditorKit(this.textArea).write(new BufferedWriter(writer), document, 0, document.getLength());
        }
        catch (BadLocationException e) {
            throw new IOException(e.getMessage());
        }
    }

    public void colorChanged(ColorChangedEvent event) {
        switch (event.getColorId()) {
            case 41: {
                this.textArea.setForeground(event.getColor());
                break;
            }
            case 42: {
                this.textArea.setBackground(event.getColor());
                break;
            }
            case 43: {
                this.textArea.setSelectedTextColor(event.getColor());
                break;
            }
            case 44: {
                this.textArea.setSelectionColor(event.getColor());
            }
        }
    }

    public void fontChanged(FontChangedEvent event) {
        if (event.getFontId() == 2) {
            this.textArea.setFont(event.getFont());
        }
    }
}

