/*
 * Decompiled with CFR 0.152.
 */
package com.mucommander.ui.viewer.text;

import com.mucommander.commons.file.AbstractFile;
import com.mucommander.commons.io.BinaryDetector;
import com.mucommander.text.Translator;
import com.mucommander.ui.viewer.EditorFactory;
import com.mucommander.ui.viewer.FileEditor;
import com.mucommander.ui.viewer.FileViewer;
import com.mucommander.ui.viewer.ViewerFactory;
import com.mucommander.ui.viewer.WarnUserException;
import com.mucommander.ui.viewer.text.TextEditor;
import com.mucommander.ui.viewer.text.TextViewer;
import java.io.IOException;
import java.io.InputStream;

public class TextFactory
implements EditorFactory,
ViewerFactory {
    public boolean canViewFile(AbstractFile file) throws WarnUserException {
        return this.doGenericChecks(file);
    }

    public boolean canEditFile(AbstractFile file) throws WarnUserException {
        return this.doGenericChecks(file);
    }

    public FileViewer createFileViewer() {
        return new TextViewer();
    }

    public FileEditor createFileEditor() {
        return new TextEditor();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean doGenericChecks(AbstractFile file) throws WarnUserException {
        if (file.isDirectory()) {
            return false;
        }
        if (file.getSize() > 0x100000L) {
            throw new WarnUserException(Translator.get("file_viewer.large_file_warning", new String[0]));
        }
        InputStream in = null;
        try {
            in = file.getInputStream();
            if (BinaryDetector.guessBinary(in)) {
                boolean bl = false;
                return bl;
            }
        }
        catch (IOException e) {
        }
        finally {
            if (in != null) {
                try {
                    in.close();
                }
                catch (IOException e2) {}
            }
        }
        return true;
    }
}

