/*
 * Decompiled with CFR 0.152.
 */
package com.mucommander.ui.viewer.text;

import java.awt.Color;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Insets;
import java.awt.Point;
import java.awt.Rectangle;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.HashMap;
import javax.swing.JPanel;
import javax.swing.SwingUtilities;
import javax.swing.border.Border;
import javax.swing.border.CompoundBorder;
import javax.swing.border.EmptyBorder;
import javax.swing.event.CaretEvent;
import javax.swing.event.CaretListener;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.text.AttributeSet;
import javax.swing.text.BadLocationException;
import javax.swing.text.Element;
import javax.swing.text.JTextComponent;
import javax.swing.text.StyleConstants;
import javax.swing.text.Utilities;

public class TextLineNumbersPanel
extends JPanel
implements PropertyChangeListener,
CaretListener,
DocumentListener {
    private JTextComponent component;
    private Color currentLineForeground;
    private int minimumDisplayDigits;
    private double digitAlignment;
    private int lastDigits;
    private int lastHeight;
    private int lastLine;
    private HashMap<String, FontMetrics> fonts;

    public TextLineNumbersPanel(JTextComponent component) {
        this(component, 3);
    }

    public TextLineNumbersPanel(JTextComponent component, int minimumDisplayDigits) {
        this(component, minimumDisplayDigits, new EmptyBorder(0, 0, 0, 2), 4, ALIGNMENT.CENTER);
    }

    public TextLineNumbersPanel(JTextComponent component, int minimumDisplayDigits, Border border, int borderGap, ALIGNMENT alignment) {
        this.component = component;
        this.setBackground(Color.LIGHT_GRAY);
        this.setForeground(Color.black);
        this.setCurrentLineForeground(new Color(0, 0, 255));
        this.setDigitAlignment(alignment);
        this.setBorder(border, borderGap);
        this.setMinimumDisplayDigits(minimumDisplayDigits);
        this.setFont(component.getFont());
        component.getDocument().addDocumentListener(this);
        component.addPropertyChangeListener("font", this);
        component.addCaretListener(this);
    }

    private void setDigitAlignment(ALIGNMENT alignment) {
        switch (alignment) {
            case LEFT: {
                this.digitAlignment = 0.0;
            }
            case RIGHT: {
                this.digitAlignment = 1.0;
            }
            case CENTER: {
                this.digitAlignment = 0.5;
            }
        }
    }

    private void setCurrentLineForeground(Color currentLineForeground) {
        this.currentLineForeground = currentLineForeground;
    }

    private void setBorder(Border border, int borderGap) {
        EmptyBorder inner = new EmptyBorder(0, borderGap, 0, borderGap);
        this.setBorder(new CompoundBorder(border, inner));
        this.lastDigits = 0;
        this.setPreferredWidth();
    }

    private void setMinimumDisplayDigits(int minimumDisplayDigits) {
        this.minimumDisplayDigits = minimumDisplayDigits;
        this.setPreferredWidth();
    }

    private void setPreferredWidth() {
        Element root = this.component.getDocument().getDefaultRootElement();
        int lines = root.getElementCount();
        int digits = Math.max(String.valueOf(lines).length(), this.minimumDisplayDigits);
        if (this.lastDigits != digits) {
            this.lastDigits = digits;
            FontMetrics fontMetrics = this.getFontMetrics(this.getFont());
            int width = fontMetrics.charWidth('0') * digits;
            Insets insets = this.getInsets();
            int preferredWidth = insets.left + insets.right + width;
            Dimension d = this.getPreferredSize();
            d.setSize(preferredWidth, 2146483647);
            this.setPreferredSize(d);
            this.setSize(d);
        }
    }

    private boolean isCurrentLine(int rowStartOffset) {
        if (this.currentLineForeground == null) {
            return false;
        }
        int caretPosition = this.component.getCaretPosition();
        Element root = this.component.getDocument().getDefaultRootElement();
        return root.getElementIndex(rowStartOffset) == root.getElementIndex(caretPosition);
    }

    public void paintComponent(Graphics g) {
        super.paintComponent(g);
        FontMetrics fontMetrics = this.component.getFontMetrics(this.component.getFont());
        Insets insets = this.getInsets();
        int availableWidth = this.getSize().width - insets.left - insets.right;
        Rectangle clip = g.getClipBounds();
        int rowStartOffset = this.component.viewToModel(new Point(0, clip.y));
        int endOffset = this.component.viewToModel(new Point(0, clip.y + clip.height));
        while (rowStartOffset <= endOffset) {
            try {
                g.setColor(this.isCurrentLine(rowStartOffset) ? this.currentLineForeground : this.getForeground());
                String lineNumber = this.getTextLineNumber(rowStartOffset);
                int stringWidth = fontMetrics.stringWidth(lineNumber);
                int x = this.getOffsetX(availableWidth, stringWidth) + insets.left;
                int y = this.getOffsetY(rowStartOffset, fontMetrics);
                g.drawString(lineNumber, x, y);
                rowStartOffset = Utilities.getRowEnd(this.component, rowStartOffset) + 1;
            }
            catch (Exception e) {}
        }
    }

    protected String getTextLineNumber(int rowStartOffset) {
        int index;
        Element root = this.component.getDocument().getDefaultRootElement();
        Element line = root.getElement(index = root.getElementIndex(rowStartOffset));
        return line.getStartOffset() == rowStartOffset ? String.valueOf(index + 1) : "";
    }

    private int getOffsetX(int availableWidth, int stringWidth) {
        return (int)((double)(availableWidth - stringWidth) * this.digitAlignment);
    }

    private int getOffsetY(int rowStartOffset, FontMetrics fontMetrics) throws BadLocationException {
        Rectangle r = this.component.modelToView(rowStartOffset);
        int lineHeight = fontMetrics.getHeight();
        int y = r.y + r.height;
        int descent = 0;
        if (r.height == lineHeight) {
            descent = fontMetrics.getDescent();
        } else {
            if (this.fonts == null) {
                this.fonts = new HashMap();
            }
            Element root = this.component.getDocument().getDefaultRootElement();
            int index = root.getElementIndex(rowStartOffset);
            Element line = root.getElement(index);
            for (int i = 0; i < line.getElementCount(); ++i) {
                Element child = line.getElement(i);
                AttributeSet as = child.getAttributes();
                String fontFamily = (String)as.getAttribute(StyleConstants.FontFamily);
                Integer fontSize = (Integer)as.getAttribute(StyleConstants.FontSize);
                String key = fontFamily + fontSize;
                FontMetrics fm = this.fonts.get(key);
                if (fm == null) {
                    Font font = new Font(fontFamily, 0, fontSize);
                    fm = this.component.getFontMetrics(font);
                    this.fonts.put(key, fm);
                }
                descent = Math.max(descent, fm.getDescent());
            }
        }
        return y - descent;
    }

    public void changedUpdate(DocumentEvent e) {
        this.documentChanged();
    }

    public void insertUpdate(DocumentEvent e) {
        this.documentChanged();
    }

    public void removeUpdate(DocumentEvent e) {
        this.documentChanged();
    }

    private void documentChanged() {
        SwingUtilities.invokeLater(new Runnable(){

            public void run() {
                int preferredHeight = ((TextLineNumbersPanel)TextLineNumbersPanel.this).component.getPreferredSize().height;
                if (TextLineNumbersPanel.this.lastHeight != preferredHeight) {
                    TextLineNumbersPanel.this.setPreferredWidth();
                    TextLineNumbersPanel.this.repaint();
                    TextLineNumbersPanel.this.lastHeight = preferredHeight;
                }
            }
        });
    }

    public void caretUpdate(CaretEvent e) {
        if (this.currentLineForeground == null) {
            return;
        }
        int caretPosition = this.component.getCaretPosition();
        Element root = this.component.getDocument().getDefaultRootElement();
        int currentLine = root.getElementIndex(caretPosition);
        if (this.lastLine != currentLine) {
            this.repaint();
            this.lastLine = currentLine;
        }
    }

    public void propertyChange(PropertyChangeEvent evt) {
        if (evt.getNewValue() instanceof Font) {
            this.setFont((Font)evt.getNewValue());
            this.lastDigits = 0;
            this.setPreferredWidth();
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum ALIGNMENT {
        LEFT,
        CENTER,
        RIGHT;

    }
}

