/*
 * Decompiled with CFR 0.152.
 */
package com.mucommander.xml;

import com.mucommander.xml.XmlAttributes;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.io.Writer;
import java.util.Iterator;

public class XmlWriter {
    private static final String[] ENTITIES = new String[]{"&", "\"", "'", "<", ">"};
    private static final String[] ENTITY_REPLACEMENTS = new String[]{"&amp;", "&quot;", "&apos;", "&lt;", "&gt;"};
    private PrintWriter out;
    private int offset;
    private boolean printIndentation;

    public XmlWriter(OutputStream stream) throws IOException {
        this.init(new OutputStreamWriter(stream, "UTF-8"), "UTF-8");
    }

    private void init(Writer writer, String encoding) throws IOException {
        this.out = new PrintWriter(writer, true);
        this.out.print("<?xml version=\"1.0\" encoding=\"");
        this.out.print(encoding);
        this.out.println("\"?>");
        if (this.out.checkError()) {
            throw new IOException();
        }
    }

    public void startElement(String name) throws IOException {
        this.startElement(name, false, null, false);
    }

    public void writeStandAloneElement(String name) throws IOException {
        this.startElement(name, true, null, true);
    }

    public void writeCommentLine(String comment) throws IOException {
        this.out.print("<!-- " + comment + " -->");
        this.println();
    }

    public void startElement(String name, XmlAttributes attributes) throws IOException {
        this.startElement(name, false, attributes, false);
    }

    public void startElement(String name, XmlAttributes attributes, boolean lineBreak) throws IOException {
        this.startElement(name, false, attributes, lineBreak);
    }

    public void writeStandAloneElement(String name, XmlAttributes attributes) throws IOException {
        this.startElement(name, true, attributes, true);
    }

    private void startElement(String name, boolean isStandAlone, XmlAttributes attributes, boolean lineBreak) throws IOException {
        this.indent();
        this.out.print('<');
        this.out.print(name);
        if (attributes != null) {
            Iterator<String> names = attributes.names();
            while (names.hasNext()) {
                String attName = names.next();
                this.out.print(' ');
                this.out.print(attName);
                this.out.print("=\"");
                this.out.print(this.escape(attributes.getValue(attName)));
                this.out.print("\"");
            }
        }
        if (isStandAlone) {
            this.out.print('/');
        } else {
            this.offset += 4;
        }
        this.out.print('>');
        if (lineBreak) {
            this.println();
        }
        if (this.out.checkError()) {
            throw new IOException();
        }
    }

    public void endElement(String name) throws IOException {
        this.offset -= 4;
        this.indent();
        this.out.print("</");
        this.out.print(name);
        this.out.print('>');
        this.println();
        if (this.out.checkError()) {
            throw new IOException();
        }
    }

    public void writeCData(String cdata) throws IOException {
        this.indent();
        this.out.print(this.escape(cdata));
        if (this.out.checkError()) {
            throw new IOException();
        }
    }

    public String escape(String data) throws IOException {
        for (int i = 0; i < ENTITIES.length; ++i) {
            int position = 0;
            while ((position = data.indexOf(ENTITIES[i], position)) != -1) {
                data = data.substring(0, position) + ENTITY_REPLACEMENTS[i] + (position == data.length() - 1 ? "" : data.substring(position + 1, data.length()));
                position += ENTITY_REPLACEMENTS[i].length();
            }
        }
        return data;
    }

    public void println() throws IOException {
        this.out.println();
        this.printIndentation = true;
        if (this.out.checkError()) {
            throw new IOException();
        }
    }

    private void indent() throws IOException {
        if (this.printIndentation) {
            for (int i = 0; i < this.offset; ++i) {
                this.out.print(' ');
            }
            this.printIndentation = false;
        }
        if (this.out.checkError()) {
            throw new IOException();
        }
    }
}

