/*
 * Decompiled with CFR 0.152.
 */
package com.sshtools.j2ssh.authentication;

import com.sshtools.j2ssh.SshException;
import com.sshtools.j2ssh.authentication.AuthenticationProtocolException;
import com.sshtools.j2ssh.authentication.AuthenticationProtocolListener;
import com.sshtools.j2ssh.authentication.SshAuthenticationClient;
import com.sshtools.j2ssh.authentication.SshMsgUserAuthFailure;
import com.sshtools.j2ssh.authentication.SshMsgUserAuthRequest;
import com.sshtools.j2ssh.authentication.SshMsgUserAuthSuccess;
import com.sshtools.j2ssh.authentication.TerminatedStateException;
import com.sshtools.j2ssh.transport.MessageStoreEOFException;
import com.sshtools.j2ssh.transport.Service;
import com.sshtools.j2ssh.transport.SshMessage;
import java.io.IOException;
import java.util.List;
import java.util.Vector;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class AuthenticationProtocolClient
extends Service {
    private static Log log = LogFactory.getLog(class$com$sshtools$j2ssh$authentication$AuthenticationProtocolClient == null ? (class$com$sshtools$j2ssh$authentication$AuthenticationProtocolClient = AuthenticationProtocolClient.class$("com.sshtools.j2ssh.authentication.AuthenticationProtocolClient")) : class$com$sshtools$j2ssh$authentication$AuthenticationProtocolClient);
    private int[] resultFilter = new int[2];
    private int[] singleIdFilter = new int[3];
    private Vector listeners = new Vector();
    static /* synthetic */ Class class$com$sshtools$j2ssh$authentication$AuthenticationProtocolClient;
    static /* synthetic */ Class class$com$sshtools$j2ssh$authentication$SshMsgUserAuthFailure;
    static /* synthetic */ Class class$com$sshtools$j2ssh$authentication$SshMsgUserAuthSuccess;
    static /* synthetic */ Class class$com$sshtools$j2ssh$authentication$SshMsgUserAuthBanner;

    public AuthenticationProtocolClient() {
        super("ssh-userauth");
        this.resultFilter[0] = 52;
        this.resultFilter[1] = 51;
        this.singleIdFilter[0] = 52;
        this.singleIdFilter[1] = 51;
    }

    protected void onServiceAccept() throws IOException {
    }

    protected void onStart() {
    }

    protected void onServiceInit(int n) throws IOException {
        if (n == 2) {
            throw new IOException("The Authentication Protocol client cannot be accepted");
        }
        this.messageStore.registerMessage(51, class$com$sshtools$j2ssh$authentication$SshMsgUserAuthFailure == null ? (class$com$sshtools$j2ssh$authentication$SshMsgUserAuthFailure = AuthenticationProtocolClient.class$("com.sshtools.j2ssh.authentication.SshMsgUserAuthFailure")) : class$com$sshtools$j2ssh$authentication$SshMsgUserAuthFailure);
        this.messageStore.registerMessage(52, class$com$sshtools$j2ssh$authentication$SshMsgUserAuthSuccess == null ? (class$com$sshtools$j2ssh$authentication$SshMsgUserAuthSuccess = AuthenticationProtocolClient.class$("com.sshtools.j2ssh.authentication.SshMsgUserAuthSuccess")) : class$com$sshtools$j2ssh$authentication$SshMsgUserAuthSuccess);
        this.messageStore.registerMessage(53, class$com$sshtools$j2ssh$authentication$SshMsgUserAuthBanner == null ? (class$com$sshtools$j2ssh$authentication$SshMsgUserAuthBanner = AuthenticationProtocolClient.class$("com.sshtools.j2ssh.authentication.SshMsgUserAuthBanner")) : class$com$sshtools$j2ssh$authentication$SshMsgUserAuthBanner);
    }

    protected void onServiceRequest() throws IOException {
        throw new IOException("This class implements the client protocol only!");
    }

    public void addEventListener(AuthenticationProtocolListener authenticationProtocolListener) {
        if (authenticationProtocolListener != null) {
            this.listeners.add(authenticationProtocolListener);
        }
    }

    public List getAvailableAuths(String string, String string2) throws IOException {
        log.info("Requesting authentication methods");
        SshMessage sshMessage = new SshMsgUserAuthRequest(string, string2, "none", null);
        this.transport.sendMessage(sshMessage, this);
        try {
            sshMessage = this.messageStore.getMessage(this.resultFilter);
        }
        catch (InterruptedException interruptedException) {
            throw new SshException("The thread was interrupted whilst waiting for an authentication message");
        }
        if (sshMessage instanceof SshMsgUserAuthFailure) {
            return ((SshMsgUserAuthFailure)sshMessage).getAvailableAuthentications();
        }
        throw new IOException("None request returned success! Insecure feature not supported");
    }

    public int authenticate(SshAuthenticationClient sshAuthenticationClient, Service service) throws IOException {
        try {
            Object object;
            if (!sshAuthenticationClient.canAuthenticate() && sshAuthenticationClient.canPrompt() && !(object = sshAuthenticationClient.getAuthenticationPrompt()).showPrompt(sshAuthenticationClient)) {
                return 5;
            }
            sshAuthenticationClient.authenticate(this, service.getServiceName());
            object = this.parseMessage(this.messageStore.getMessage(this.resultFilter));
            throw new AuthenticationProtocolException(new StringBuffer().append("Unexpected authentication message ").append(((SshMessage)object).getMessageName()).toString());
        }
        catch (TerminatedStateException terminatedStateException) {
            if (terminatedStateException.getState() == 4) {
                service.init(2, this.transport);
                service.start();
                for (AuthenticationProtocolListener authenticationProtocolListener : this.listeners) {
                    if (authenticationProtocolListener == null) continue;
                    authenticationProtocolListener.onAuthenticationComplete();
                }
            }
            return terminatedStateException.getState();
        }
        catch (InterruptedException interruptedException) {
            throw new SshException("The thread was interrupted whilst waiting for an authentication message");
        }
    }

    public void sendMessage(SshMessage sshMessage) throws IOException {
        this.transport.sendMessage(sshMessage, this);
    }

    public byte[] getSessionIdentifier() {
        return this.transport.getSessionIdentifier();
    }

    public void registerMessage(Class clazz, int n) {
        this.messageStore.registerMessage(n, clazz);
    }

    public SshMessage readMessage(int n) throws TerminatedStateException, IOException {
        this.singleIdFilter[2] = n;
        return this.internalReadMessage(this.singleIdFilter);
    }

    private SshMessage internalReadMessage(int[] nArray) throws TerminatedStateException, IOException {
        try {
            SshMessage sshMessage = this.messageStore.getMessage(nArray);
            return this.parseMessage(sshMessage);
        }
        catch (MessageStoreEOFException messageStoreEOFException) {
            throw new AuthenticationProtocolException("Failed to read messages");
        }
        catch (InterruptedException interruptedException) {
            throw new SshException("The thread was interrupted whilst waiting for an authentication message");
        }
    }

    private SshMessage parseMessage(SshMessage sshMessage) throws TerminatedStateException {
        if (sshMessage instanceof SshMsgUserAuthFailure) {
            if (((SshMsgUserAuthFailure)sshMessage).getPartialSuccess()) {
                throw new TerminatedStateException(3);
            }
            throw new TerminatedStateException(2);
        }
        if (sshMessage instanceof SshMsgUserAuthSuccess) {
            throw new TerminatedStateException(4);
        }
        return sshMessage;
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError().initCause(classNotFoundException);
        }
    }
}

