/*
 * Decompiled with CFR 0.152.
 */
package com.sshtools.j2ssh.authentication;

import com.sshtools.j2ssh.authentication.AuthenticationProtocolClient;
import com.sshtools.j2ssh.authentication.AuthenticationProtocolException;
import com.sshtools.j2ssh.authentication.SshAuthenticationClient;
import com.sshtools.j2ssh.authentication.SshMsgUserAuthRequest;
import com.sshtools.j2ssh.authentication.TerminatedStateException;
import com.sshtools.j2ssh.io.ByteArrayWriter;
import com.sshtools.j2ssh.transport.publickey.SshPrivateKey;
import com.sshtools.j2ssh.transport.publickey.SshPublicKey;
import java.io.IOException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class PublicKeyAuthenticationClient
extends SshAuthenticationClient {
    private static Log log = LogFactory.getLog(class$com$sshtools$j2ssh$authentication$PublicKeyAuthenticationClient == null ? (class$com$sshtools$j2ssh$authentication$PublicKeyAuthenticationClient = PublicKeyAuthenticationClient.class$("com.sshtools.j2ssh.authentication.PublicKeyAuthenticationClient")) : class$com$sshtools$j2ssh$authentication$PublicKeyAuthenticationClient);
    protected SshPrivateKey key;
    private String privateKeyFile = null;
    private String passphrase = null;
    static /* synthetic */ Class class$com$sshtools$j2ssh$authentication$PublicKeyAuthenticationClient;

    public void setKey(SshPrivateKey sshPrivateKey) {
        this.key = sshPrivateKey;
    }

    public String getMethodName() {
        return "publickey";
    }

    public void authenticate(AuthenticationProtocolClient authenticationProtocolClient, String string) throws IOException, TerminatedStateException {
        if (this.getUsername() == null || this.key == null) {
            throw new AuthenticationProtocolException("You must supply a username and a key");
        }
        ByteArrayWriter byteArrayWriter = new ByteArrayWriter();
        log.info("Generating data to sign");
        SshPublicKey sshPublicKey = this.key.getPublicKey();
        log.info("Preparing public key authentication request");
        byteArrayWriter.write(1);
        byteArrayWriter.writeString(sshPublicKey.getAlgorithmName());
        byteArrayWriter.writeBinaryString(sshPublicKey.getEncoded());
        ByteArrayWriter byteArrayWriter2 = new ByteArrayWriter();
        byteArrayWriter2.writeBinaryString(authenticationProtocolClient.getSessionIdentifier());
        byteArrayWriter2.write(50);
        byteArrayWriter2.writeString(this.getUsername());
        byteArrayWriter2.writeString(string);
        byteArrayWriter2.writeString(this.getMethodName());
        byteArrayWriter2.write(1);
        byteArrayWriter2.writeString(sshPublicKey.getAlgorithmName());
        byteArrayWriter2.writeBinaryString(sshPublicKey.getEncoded());
        byteArrayWriter.writeBinaryString(this.key.generateSignature(byteArrayWriter2.toByteArray()));
        SshMsgUserAuthRequest sshMsgUserAuthRequest = new SshMsgUserAuthRequest(this.getUsername(), string, this.getMethodName(), byteArrayWriter.toByteArray());
        authenticationProtocolClient.sendMessage(sshMsgUserAuthRequest);
    }

    public boolean canAuthenticate() {
        return this.getUsername() != null && this.key != null;
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError().initCause(classNotFoundException);
        }
    }
}

