/*
 * Decompiled with CFR 0.152.
 */
package com.sshtools.j2ssh.configuration;

import com.sshtools.j2ssh.configuration.ConfigurationContext;
import com.sshtools.j2ssh.configuration.ConfigurationException;
import com.sshtools.j2ssh.util.ExtensionClassLoader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FilenameFilter;
import java.io.InputStream;
import java.security.AccessControlException;
import java.security.AccessController;
import java.security.Provider;
import java.security.SecureRandom;
import java.security.Security;
import java.util.Properties;
import java.util.PropertyPermission;
import java.util.Vector;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class ConfigurationLoader {
    private static Vector contexts = new Vector();
    private static SecureRandom rnd;
    private static ExtensionClassLoader ext;
    private static ClassLoader clsLoader;
    private static Log log;
    private static String homedir;
    private static boolean initialized;
    private static Object initializationLock;
    static /* synthetic */ Class class$com$sshtools$j2ssh$configuration$ConfigurationLoader;

    public static SecureRandom getRND() {
        return rnd;
    }

    public static String getVersionString(String string, String string2) {
        Properties properties = new Properties();
        String string3 = string;
        try {
            properties.load(ConfigurationLoader.loadFile(string2));
            String string4 = string.toLowerCase();
            String string5 = properties.getProperty(new StringBuffer().append(string4).append(".version.major").toString());
            String string6 = properties.getProperty(new StringBuffer().append(string4).append(".version.minor").toString());
            String string7 = properties.getProperty(new StringBuffer().append(string4).append(".version.build").toString());
            String string8 = properties.getProperty(new StringBuffer().append(string4).append(".project.type").toString());
            if (string5 != null && string6 != null && string7 != null) {
                string3 = new StringBuffer().append(string3).append(" ").append(string5).append(".").append(string6).append(".").append(string7).toString();
            }
            if (string8 != null) {
                string3 = new StringBuffer().append(string3).append(" ").append(string8).toString();
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return string3;
    }

    public static String checkAndGetProperty(String string, String string2) {
        try {
            if (System.getSecurityManager() != null) {
                AccessController.checkPermission(new PropertyPermission(string, "read"));
            }
            return System.getProperty(string, string2);
        }
        catch (AccessControlException accessControlException) {
            return string2;
        }
    }

    public static void initialize(boolean bl) throws ConfigurationException {
        ConfigurationLoader.initialize(bl, new DefaultConfigurationContext());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void initialize(boolean bl, ConfigurationContext configurationContext) throws ConfigurationException {
        Object object;
        try {
            object = System.getProperty("java.version");
            log.info(new StringBuffer().append("JAVA version is ").append((String)object).toString());
            if (((String)object).startsWith("1.3")) {
                boolean bl2 = false;
                for (int i = 0; i < Security.getProviders().length; ++i) {
                    log.info(new StringBuffer().append(Security.getProviders()[i].getName()).append(" security provider found").toString());
                    if (!Security.getProviders()[i].getClass().getName().equals("org.bouncycastle.jce.provider.BouncyCastleProvider")) continue;
                    bl2 = true;
                }
                if (!bl2) {
                    log.info("Attempting to load the bouncycastle jce provider");
                    Class<?> clazz = Class.forName("org.bouncycastle.jce.provider.BouncyCastleProvider");
                    Security.addProvider((Provider)clazz.newInstance());
                }
            }
        }
        catch (Exception exception) {
            log.info("Failed to load the bouncycastle jce provider", exception);
            if (Security.getProviders().length <= 0) {
                throw new ConfigurationException("There are no security providers available; install jce-jdk13-119.jar available from http://www.bouncycastle.org");
            }
            log.info("An existing provider has been detected");
        }
        object = initializationLock;
        synchronized (object) {
            if (initialized && !bl) {
                return;
            }
            configurationContext.initialize();
            contexts.add(configurationContext);
            if (ext == null) {
                ext = new ExtensionClassLoader((class$com$sshtools$j2ssh$configuration$ConfigurationLoader == null ? (class$com$sshtools$j2ssh$configuration$ConfigurationLoader = ConfigurationLoader.class$("com.sshtools.j2ssh.configuration.ConfigurationLoader")) : class$com$sshtools$j2ssh$configuration$ConfigurationLoader).getClassLoader());
                try {
                    File file = new File(new StringBuffer().append(homedir).append("lib").append(File.separator).append("ext").toString());
                    FilenameFilter filenameFilter = new FilenameFilter(){

                        public boolean accept(File file, String string) {
                            return string.endsWith(".jar");
                        }
                    };
                    File[] fileArray = file.listFiles(filenameFilter);
                    Vector vector = new Vector();
                    if (fileArray != null) {
                        for (int i = 0; i < fileArray.length; ++i) {
                            log.info(new StringBuffer().append("Extension ").append(fileArray[i].getAbsolutePath()).append(" being added to classpath").toString());
                            ext.add(fileArray[i]);
                        }
                    }
                }
                catch (AccessControlException accessControlException) {
                    log.info("Cannot access lib/ext directory, extension classes will not be loaded");
                }
            }
            initialized = true;
        }
    }

    public static boolean isConfigurationAvailable(Class clazz) throws ConfigurationException {
        if (!initialized) {
            ConfigurationLoader.initialize(false);
        }
        if (contexts.size() > 0) {
            for (ConfigurationContext configurationContext : contexts) {
                if (!configurationContext.isConfigurationAvailable(clazz)) continue;
                return true;
            }
            return false;
        }
        return false;
    }

    public static Object getConfiguration(Class clazz) throws ConfigurationException {
        if (contexts.size() > 0) {
            for (ConfigurationContext configurationContext : contexts) {
                if (!configurationContext.isConfigurationAvailable(clazz)) continue;
                return configurationContext.getConfiguration(clazz);
            }
        }
        throw new ConfigurationException(new StringBuffer().append("No ").append(clazz.getName()).append(" configuration is available in this context").toString());
    }

    public static String getConfigurationDirectory() {
        return new StringBuffer().append(homedir).append("conf/").toString();
    }

    public static Class getExtensionClass(String string) throws ClassNotFoundException, ConfigurationException {
        if (!initialized) {
            ConfigurationLoader.initialize(false);
        }
        if (ext == null) {
            throw new ClassNotFoundException("Configuration not initialized");
        }
        return ext.loadClass(string);
    }

    public static ExtensionClassLoader getExtensionClassLoader() {
        return ext;
    }

    public static ClassLoader getContextClassLoader() {
        return clsLoader;
    }

    public static boolean isContextClassLoader() {
        return clsLoader != null;
    }

    public static InputStream loadFile(String string) throws FileNotFoundException {
        try {
            FileInputStream fileInputStream = new FileInputStream(new StringBuffer().append(ConfigurationLoader.getConfigurationDirectory()).append(string).toString());
            return fileInputStream;
        }
        catch (FileNotFoundException fileNotFoundException) {
            try {
                FileInputStream fileInputStream = new FileInputStream(new StringBuffer().append(homedir).append(string).toString());
                return fileInputStream;
            }
            catch (FileNotFoundException fileNotFoundException2) {
                FileInputStream fileInputStream = new FileInputStream(string);
                return fileInputStream;
            }
        }
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError().initCause(classNotFoundException);
        }
    }

    static {
        ext = null;
        clsLoader = null;
        log = LogFactory.getLog(class$com$sshtools$j2ssh$configuration$ConfigurationLoader == null ? (class$com$sshtools$j2ssh$configuration$ConfigurationLoader = ConfigurationLoader.class$("com.sshtools.j2ssh.configuration.ConfigurationLoader")) : class$com$sshtools$j2ssh$configuration$ConfigurationLoader);
        initialized = false;
        initializationLock = new Object();
        homedir = ConfigurationLoader.checkAndGetProperty("sshtools.home", System.getProperty("java.home"));
        if (homedir != null && !homedir.endsWith(File.separator)) {
            homedir = new StringBuffer().append(homedir).append(File.separator).toString();
        }
        rnd = new SecureRandom();
        rnd.nextInt();
    }

    static class DefaultConfigurationContext
    implements ConfigurationContext {
        DefaultConfigurationContext() {
        }

        public void initialize() throws ConfigurationException {
        }

        public boolean isConfigurationAvailable(Class clazz) {
            return false;
        }

        public Object getConfiguration(Class clazz) throws ConfigurationException {
            throw new ConfigurationException(new StringBuffer().append("Default configuration does not contain ").append(clazz.getName()).toString());
        }
    }
}

