/*
 * Decompiled with CFR 0.152.
 */
package com.sshtools.j2ssh.connection;

import com.sshtools.j2ssh.SshException;
import com.sshtools.j2ssh.connection.Channel;
import com.sshtools.j2ssh.connection.ChannelDataWindow;
import com.sshtools.j2ssh.connection.ChannelEventListener;
import com.sshtools.j2ssh.connection.ChannelFactory;
import com.sshtools.j2ssh.connection.ChannelState;
import com.sshtools.j2ssh.connection.GlobalRequestHandler;
import com.sshtools.j2ssh.connection.GlobalRequestResponse;
import com.sshtools.j2ssh.connection.InvalidChannelException;
import com.sshtools.j2ssh.connection.SshMsgChannelClose;
import com.sshtools.j2ssh.connection.SshMsgChannelData;
import com.sshtools.j2ssh.connection.SshMsgChannelEOF;
import com.sshtools.j2ssh.connection.SshMsgChannelExtendedData;
import com.sshtools.j2ssh.connection.SshMsgChannelFailure;
import com.sshtools.j2ssh.connection.SshMsgChannelOpen;
import com.sshtools.j2ssh.connection.SshMsgChannelOpenConfirmation;
import com.sshtools.j2ssh.connection.SshMsgChannelOpenFailure;
import com.sshtools.j2ssh.connection.SshMsgChannelRequest;
import com.sshtools.j2ssh.connection.SshMsgChannelWindowAdjust;
import com.sshtools.j2ssh.connection.SshMsgGlobalRequest;
import com.sshtools.j2ssh.connection.SshMsgRequestFailure;
import com.sshtools.j2ssh.connection.SshMsgRequestSuccess;
import com.sshtools.j2ssh.transport.AsyncService;
import com.sshtools.j2ssh.transport.MessageStoreEOFException;
import com.sshtools.j2ssh.transport.SshMessage;
import java.io.IOException;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class ConnectionProtocol
extends AsyncService {
    private static Log log = LogFactory.getLog(class$com$sshtools$j2ssh$connection$ConnectionProtocol == null ? (class$com$sshtools$j2ssh$connection$ConnectionProtocol = ConnectionProtocol.class$("com.sshtools.j2ssh.connection.ConnectionProtocol")) : class$com$sshtools$j2ssh$connection$ConnectionProtocol);
    private HashSet reusableChannels = new HashSet();
    private Map activeChannels = new ConcurrentHashMap();
    private Map allowedChannels = new HashMap();
    private Map globalRequests = new HashMap();
    private long nextChannelId = 0L;
    static /* synthetic */ Class class$com$sshtools$j2ssh$connection$ConnectionProtocol;
    static /* synthetic */ Class class$com$sshtools$j2ssh$connection$SshMsgChannelOpenConfirmation;
    static /* synthetic */ Class class$com$sshtools$j2ssh$connection$SshMsgChannelOpenFailure;
    static /* synthetic */ Class class$com$sshtools$j2ssh$connection$SshMsgChannelOpen;
    static /* synthetic */ Class class$com$sshtools$j2ssh$connection$SshMsgChannelClose;
    static /* synthetic */ Class class$com$sshtools$j2ssh$connection$SshMsgChannelEOF;
    static /* synthetic */ Class class$com$sshtools$j2ssh$connection$SshMsgChannelData;
    static /* synthetic */ Class class$com$sshtools$j2ssh$connection$SshMsgChannelExtendedData;
    static /* synthetic */ Class class$com$sshtools$j2ssh$connection$SshMsgChannelFailure;
    static /* synthetic */ Class class$com$sshtools$j2ssh$connection$SshMsgChannelRequest;
    static /* synthetic */ Class class$com$sshtools$j2ssh$connection$SshMsgChannelSuccess;
    static /* synthetic */ Class class$com$sshtools$j2ssh$connection$SshMsgChannelWindowAdjust;
    static /* synthetic */ Class class$com$sshtools$j2ssh$connection$SshMsgGlobalRequest;
    static /* synthetic */ Class class$com$sshtools$j2ssh$connection$SshMsgRequestFailure;
    static /* synthetic */ Class class$com$sshtools$j2ssh$connection$SshMsgRequestSuccess;

    public ConnectionProtocol() {
        super("ssh-connection");
    }

    public void addChannelFactory(String string, ChannelFactory channelFactory) throws IOException {
        this.allowedChannels.put(string, channelFactory);
    }

    public synchronized boolean openChannel(Channel channel) throws IOException {
        return this.openChannel(channel, null);
    }

    public boolean isConnected() {
        return (this.transport.getState().getValue() == 4 || this.transport.getState().getValue() == 3) && this.getState().getValue() == 2;
    }

    private Long getChannelId() {
        if (this.reusableChannels.size() <= 0) {
            return new Long(this.nextChannelId++);
        }
        return (Long)this.reusableChannels.iterator().next();
    }

    public synchronized boolean openChannel(Channel channel, ChannelEventListener channelEventListener) throws IOException {
        Long l = this.getChannelId();
        SshMsgChannelOpen sshMsgChannelOpen = new SshMsgChannelOpen(channel.getChannelType(), l, channel.getLocalWindow().getWindowSpace(), channel.getLocalPacketSize(), channel.getChannelOpenData());
        this.transport.sendMessage(sshMsgChannelOpen, this);
        int[] nArray = new int[]{91, 92};
        try {
            SshMessage sshMessage = this.messageStore.getMessage(nArray);
            if (sshMessage.getMessageId() == 91) {
                SshMsgChannelOpenConfirmation sshMsgChannelOpenConfirmation = (SshMsgChannelOpenConfirmation)sshMessage;
                this.activeChannels.put(l, channel);
                log.debug("Initiating channel");
                channel.init(this, l, sshMsgChannelOpenConfirmation.getSenderChannel(), sshMsgChannelOpenConfirmation.getInitialWindowSize(), sshMsgChannelOpenConfirmation.getMaximumPacketSize(), channelEventListener);
                channel.open();
                log.info(new StringBuffer().append("Channel ").append(String.valueOf(channel.getLocalChannelId())).append(" is open [").append(channel.getName()).append("]").toString());
                return true;
            }
            channel.getState().setValue(3);
            return false;
        }
        catch (MessageStoreEOFException messageStoreEOFException) {
            throw new IOException(messageStoreEOFException.getMessage());
        }
        catch (InterruptedException interruptedException) {
            throw new SshException("The thread was interrupted whilst waiting for a connection protocol message");
        }
    }

    protected synchronized void onStop() {
        log.info("Closing all active channels");
        log.info(new StringBuffer().append("thread has ").append(this.activeChannels.values().size()).append(" active channels to stop").toString());
        try {
            for (Channel channel : this.activeChannels.values()) {
                if (channel == null) continue;
                if (log.isDebugEnabled()) {
                    log.debug(new StringBuffer().append("Closing ").append(channel.getName()).append(" id=").append(String.valueOf(channel.getLocalChannelId())).toString());
                }
                channel.close();
            }
        }
        catch (Throwable throwable) {
            log.error(new StringBuffer().append("Unable to close all channels: ").append(throwable.getMessage()).toString(), throwable);
        }
        this.activeChannels.clear();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void sendChannelData(Channel channel, byte[] byArray) throws IOException {
        ChannelState channelState = channel.getState();
        synchronized (channelState) {
            int n;
            if (log.isDebugEnabled()) {
                log.debug(new StringBuffer().append("Sending ").append(String.valueOf(byArray.length)).append(" bytes for channel id ").append(String.valueOf(channel.getLocalChannelId())).toString());
            }
            ChannelDataWindow channelDataWindow = channel.getRemoteWindow();
            for (int i = 0; i < byArray.length; i += n) {
                int n2 = byArray.length - i;
                long l = channelDataWindow.getWindowSpace() < channel.getRemotePacketSize() && channelDataWindow.getWindowSpace() > 0L ? channelDataWindow.getWindowSpace() : channel.getRemotePacketSize();
                n = l < (long)n2 ? (int)l : n2;
                channel.remoteWindow.consumeWindowSpace(n);
                byte[] byArray2 = new byte[n];
                System.arraycopy(byArray, i, byArray2, 0, n);
                SshMsgChannelData sshMsgChannelData = new SshMsgChannelData(channel.getRemoteChannelId(), byArray2);
                this.transport.sendMessage(sshMsgChannelData, this);
            }
        }
    }

    public void sendChannelEOF(Channel channel) throws IOException {
        if (!this.activeChannels.containsValue(channel)) {
            throw new IOException(new StringBuffer().append("Attempt to send EOF for a non existent channel ").append(String.valueOf(channel.getLocalChannelId())).toString());
        }
        log.info(new StringBuffer().append("Local computer has set channel ").append(String.valueOf(channel.getLocalChannelId())).append(" to EOF [").append(channel.getName()).append("]").toString());
        SshMsgChannelEOF sshMsgChannelEOF = new SshMsgChannelEOF(channel.getRemoteChannelId());
        this.transport.sendMessage(sshMsgChannelEOF, this);
    }

    public synchronized boolean sendChannelRequest(Channel channel, String string, boolean bl, byte[] byArray) throws IOException {
        boolean bl2 = true;
        log.info(new StringBuffer().append("Sending ").append(string).append(" request for the ").append(channel.getChannelType()).append(" channel").toString());
        SshMsgChannelRequest sshMsgChannelRequest = new SshMsgChannelRequest(channel.getRemoteChannelId(), string, bl, byArray);
        this.transport.sendMessage(sshMsgChannelRequest, this);
        if (bl) {
            int[] nArray = new int[]{99, 100};
            log.info("Waiting for channel request reply");
            try {
                SshMessage sshMessage = this.messageStore.getMessage(nArray);
                switch (sshMessage.getMessageId()) {
                    case 99: {
                        log.info("Channel request succeeded");
                        bl2 = true;
                        break;
                    }
                    case 100: {
                        log.info("Channel request failed");
                        bl2 = false;
                    }
                }
            }
            catch (InterruptedException interruptedException) {
                throw new SshException("The thread was interrupted whilst waiting for a connection protocol message");
            }
        }
        return bl2;
    }

    public void sendChannelRequestFailure(Channel channel) throws IOException {
        SshMsgChannelFailure sshMsgChannelFailure = new SshMsgChannelFailure(channel.getRemoteChannelId());
        this.transport.sendMessage(sshMsgChannelFailure, this);
    }

    public void sendChannelWindowAdjust(Channel channel, long l) throws IOException {
        log.debug(new StringBuffer().append("Increasing window size by ").append(String.valueOf(l)).append(" bytes").toString());
        SshMsgChannelWindowAdjust sshMsgChannelWindowAdjust = new SshMsgChannelWindowAdjust(channel.getRemoteChannelId(), l);
        this.transport.sendMessage(sshMsgChannelWindowAdjust, this);
    }

    public synchronized byte[] sendGlobalRequest(String string, boolean bl, byte[] byArray) throws IOException {
        boolean bl2 = true;
        SshMsgGlobalRequest sshMsgGlobalRequest = new SshMsgGlobalRequest(string, true, byArray);
        this.transport.sendMessage(sshMsgGlobalRequest, this);
        if (bl) {
            int[] nArray = new int[]{81, 82};
            log.debug("Waiting for global request reply");
            try {
                SshMessage sshMessage = this.messageStore.getMessage(nArray);
                switch (sshMessage.getMessageId()) {
                    case 81: {
                        log.debug("Global request succeeded");
                        return ((SshMsgRequestSuccess)sshMessage).getRequestData();
                    }
                    case 82: {
                        log.debug("Global request failed");
                        throw new SshException("The request failed");
                    }
                }
            }
            catch (InterruptedException interruptedException) {
                throw new SshException("The thread was interrupted whilst waiting for a connection protocol message");
            }
        }
        return null;
    }

    protected int[] getAsyncMessageFilter() {
        int[] nArray = new int[10];
        nArray[0] = 80;
        nArray[3] = 90;
        nArray[4] = 97;
        nArray[5] = 96;
        nArray[6] = 95;
        nArray[7] = 94;
        nArray[8] = 98;
        nArray[9] = 93;
        return nArray;
    }

    protected void closeChannel(Channel channel) throws IOException {
        SshMsgChannelClose sshMsgChannelClose = new SshMsgChannelClose(channel.getRemoteChannelId());
        log.info(new StringBuffer().append("Local computer has closed channel ").append(String.valueOf(channel.getLocalChannelId())).append("[").append(channel.getName()).append("]").toString());
        this.transport.sendMessage(sshMsgChannelClose, this);
    }

    protected void onGlobalRequest(String string, boolean bl, byte[] byArray) throws IOException {
        log.debug(new StringBuffer().append("Processing ").append(string).append(" global request").toString());
        if (!this.globalRequests.containsKey(string)) {
            this.sendGlobalRequestFailure();
        } else {
            GlobalRequestHandler globalRequestHandler = (GlobalRequestHandler)this.globalRequests.get(string);
            GlobalRequestResponse globalRequestResponse = globalRequestHandler.processGlobalRequest(string, byArray);
            if (bl) {
                if (globalRequestResponse.hasSucceeded()) {
                    this.sendGlobalRequestSuccess(globalRequestResponse.getResponseData());
                } else {
                    this.sendGlobalRequestFailure();
                }
            }
        }
    }

    protected void onMessageReceived(SshMessage sshMessage) throws IOException {
        switch (sshMessage.getMessageId()) {
            case 80: {
                this.onMsgGlobalRequest((SshMsgGlobalRequest)sshMessage);
                break;
            }
            case 90: {
                this.onMsgChannelOpen((SshMsgChannelOpen)sshMessage);
                break;
            }
            case 97: {
                this.onMsgChannelClose((SshMsgChannelClose)sshMessage);
                break;
            }
            case 96: {
                this.onMsgChannelEOF((SshMsgChannelEOF)sshMessage);
                break;
            }
            case 94: {
                this.onMsgChannelData((SshMsgChannelData)sshMessage);
                break;
            }
            case 95: {
                this.onMsgChannelExtendedData((SshMsgChannelExtendedData)sshMessage);
                break;
            }
            case 98: {
                this.onMsgChannelRequest((SshMsgChannelRequest)sshMessage);
                break;
            }
            case 93: {
                this.onMsgChannelWindowAdjust((SshMsgChannelWindowAdjust)sshMessage);
                break;
            }
            default: {
                log.debug("Message not handled");
                throw new IOException("Unregistered message received!");
            }
        }
    }

    protected void onServiceAccept() {
    }

    protected void onServiceInit(int n) throws IOException {
        log.info("Registering connection protocol messages");
        this.messageStore.registerMessage(91, class$com$sshtools$j2ssh$connection$SshMsgChannelOpenConfirmation == null ? (class$com$sshtools$j2ssh$connection$SshMsgChannelOpenConfirmation = ConnectionProtocol.class$("com.sshtools.j2ssh.connection.SshMsgChannelOpenConfirmation")) : class$com$sshtools$j2ssh$connection$SshMsgChannelOpenConfirmation);
        this.messageStore.registerMessage(92, class$com$sshtools$j2ssh$connection$SshMsgChannelOpenFailure == null ? (class$com$sshtools$j2ssh$connection$SshMsgChannelOpenFailure = ConnectionProtocol.class$("com.sshtools.j2ssh.connection.SshMsgChannelOpenFailure")) : class$com$sshtools$j2ssh$connection$SshMsgChannelOpenFailure);
        this.messageStore.registerMessage(90, class$com$sshtools$j2ssh$connection$SshMsgChannelOpen == null ? (class$com$sshtools$j2ssh$connection$SshMsgChannelOpen = ConnectionProtocol.class$("com.sshtools.j2ssh.connection.SshMsgChannelOpen")) : class$com$sshtools$j2ssh$connection$SshMsgChannelOpen);
        this.messageStore.registerMessage(97, class$com$sshtools$j2ssh$connection$SshMsgChannelClose == null ? (class$com$sshtools$j2ssh$connection$SshMsgChannelClose = ConnectionProtocol.class$("com.sshtools.j2ssh.connection.SshMsgChannelClose")) : class$com$sshtools$j2ssh$connection$SshMsgChannelClose);
        this.messageStore.registerMessage(96, class$com$sshtools$j2ssh$connection$SshMsgChannelEOF == null ? (class$com$sshtools$j2ssh$connection$SshMsgChannelEOF = ConnectionProtocol.class$("com.sshtools.j2ssh.connection.SshMsgChannelEOF")) : class$com$sshtools$j2ssh$connection$SshMsgChannelEOF);
        this.messageStore.registerMessage(94, class$com$sshtools$j2ssh$connection$SshMsgChannelData == null ? (class$com$sshtools$j2ssh$connection$SshMsgChannelData = ConnectionProtocol.class$("com.sshtools.j2ssh.connection.SshMsgChannelData")) : class$com$sshtools$j2ssh$connection$SshMsgChannelData);
        this.messageStore.registerMessage(95, class$com$sshtools$j2ssh$connection$SshMsgChannelExtendedData == null ? (class$com$sshtools$j2ssh$connection$SshMsgChannelExtendedData = ConnectionProtocol.class$("com.sshtools.j2ssh.connection.SshMsgChannelExtendedData")) : class$com$sshtools$j2ssh$connection$SshMsgChannelExtendedData);
        this.messageStore.registerMessage(100, class$com$sshtools$j2ssh$connection$SshMsgChannelFailure == null ? (class$com$sshtools$j2ssh$connection$SshMsgChannelFailure = ConnectionProtocol.class$("com.sshtools.j2ssh.connection.SshMsgChannelFailure")) : class$com$sshtools$j2ssh$connection$SshMsgChannelFailure);
        this.messageStore.registerMessage(98, class$com$sshtools$j2ssh$connection$SshMsgChannelRequest == null ? (class$com$sshtools$j2ssh$connection$SshMsgChannelRequest = ConnectionProtocol.class$("com.sshtools.j2ssh.connection.SshMsgChannelRequest")) : class$com$sshtools$j2ssh$connection$SshMsgChannelRequest);
        this.messageStore.registerMessage(99, class$com$sshtools$j2ssh$connection$SshMsgChannelSuccess == null ? (class$com$sshtools$j2ssh$connection$SshMsgChannelSuccess = ConnectionProtocol.class$("com.sshtools.j2ssh.connection.SshMsgChannelSuccess")) : class$com$sshtools$j2ssh$connection$SshMsgChannelSuccess);
        this.messageStore.registerMessage(93, class$com$sshtools$j2ssh$connection$SshMsgChannelWindowAdjust == null ? (class$com$sshtools$j2ssh$connection$SshMsgChannelWindowAdjust = ConnectionProtocol.class$("com.sshtools.j2ssh.connection.SshMsgChannelWindowAdjust")) : class$com$sshtools$j2ssh$connection$SshMsgChannelWindowAdjust);
        this.messageStore.registerMessage(80, class$com$sshtools$j2ssh$connection$SshMsgGlobalRequest == null ? (class$com$sshtools$j2ssh$connection$SshMsgGlobalRequest = ConnectionProtocol.class$("com.sshtools.j2ssh.connection.SshMsgGlobalRequest")) : class$com$sshtools$j2ssh$connection$SshMsgGlobalRequest);
        this.messageStore.registerMessage(82, class$com$sshtools$j2ssh$connection$SshMsgRequestFailure == null ? (class$com$sshtools$j2ssh$connection$SshMsgRequestFailure = ConnectionProtocol.class$("com.sshtools.j2ssh.connection.SshMsgRequestFailure")) : class$com$sshtools$j2ssh$connection$SshMsgRequestFailure);
        this.messageStore.registerMessage(81, class$com$sshtools$j2ssh$connection$SshMsgRequestSuccess == null ? (class$com$sshtools$j2ssh$connection$SshMsgRequestSuccess = ConnectionProtocol.class$("com.sshtools.j2ssh.connection.SshMsgRequestSuccess")) : class$com$sshtools$j2ssh$connection$SshMsgRequestSuccess);
    }

    protected void onServiceRequest() {
    }

    protected void sendChannelOpenConfirmation(Channel channel) throws IOException {
        SshMsgChannelOpenConfirmation sshMsgChannelOpenConfirmation = new SshMsgChannelOpenConfirmation(channel.getRemoteChannelId(), channel.getLocalChannelId(), channel.getLocalWindow().getWindowSpace(), channel.getLocalPacketSize(), channel.getChannelConfirmationData());
        this.transport.sendMessage(sshMsgChannelOpenConfirmation, this);
    }

    protected void sendChannelOpenFailure(long l, long l2, String string, String string2) throws IOException {
        SshMsgChannelOpenFailure sshMsgChannelOpenFailure = new SshMsgChannelOpenFailure(l, l2, string, string2);
        this.transport.sendMessage(sshMsgChannelOpenFailure, this);
    }

    protected void sendGlobalRequestFailure() throws IOException {
        SshMsgRequestFailure sshMsgRequestFailure = new SshMsgRequestFailure();
        this.transport.sendMessage(sshMsgRequestFailure, this);
    }

    protected void sendGlobalRequestSuccess(byte[] byArray) throws IOException {
        SshMsgRequestSuccess sshMsgRequestSuccess = new SshMsgRequestSuccess(byArray);
        this.transport.sendMessage(sshMsgRequestSuccess, this);
    }

    private Channel getChannel(long l) throws IOException {
        Long l2 = new Long(l);
        if (!this.activeChannels.containsKey(l2)) {
            throw new IOException(new StringBuffer().append("Non existent channel ").append(l2.toString()).append(" requested").toString());
        }
        return (Channel)this.activeChannels.get(l2);
    }

    private void onMsgChannelClose(SshMsgChannelClose sshMsgChannelClose) throws IOException {
        Channel channel = this.getChannel(sshMsgChannelClose.getRecipientChannel());
        if (channel == null) {
            throw new IOException(new StringBuffer().append("Remote computer tried to close a non existent channel ").append(String.valueOf(sshMsgChannelClose.getRecipientChannel())).toString());
        }
        log.info(new StringBuffer().append("Remote computer has closed channel ").append(String.valueOf(channel.getLocalChannelId())).append("[").append(channel.getName()).append("]").toString());
        if (channel.getState().getValue() != 3) {
            channel.remoteClose();
        }
    }

    private void onMsgChannelData(SshMsgChannelData sshMsgChannelData) throws IOException {
        if (log.isDebugEnabled()) {
            log.debug(new StringBuffer().append("Received ").append(String.valueOf(sshMsgChannelData.getChannelData().length)).append(" bytes of data for channel id ").append(String.valueOf(sshMsgChannelData.getRecipientChannel())).toString());
        }
        Channel channel = this.getChannel(sshMsgChannelData.getRecipientChannel());
        channel.processChannelData(sshMsgChannelData);
    }

    private void onMsgChannelEOF(SshMsgChannelEOF sshMsgChannelEOF) throws IOException {
        Channel channel = this.getChannel(sshMsgChannelEOF.getRecipientChannel());
        try {
            log.info(new StringBuffer().append("Remote computer has set channel ").append(String.valueOf(sshMsgChannelEOF.getRecipientChannel())).append(" to EOF [").append(channel.getName()).append("]").toString());
            channel.setRemoteEOF();
        }
        catch (IOException iOException) {
            log.info("Failed to close the ChannelInputStream after EOF event");
        }
    }

    private void onMsgChannelExtendedData(SshMsgChannelExtendedData sshMsgChannelExtendedData) throws IOException {
        Channel channel = this.getChannel(sshMsgChannelExtendedData.getRecipientChannel());
        if (channel == null) {
            throw new IOException("Remote computer sent data for non existent channel");
        }
        channel.getLocalWindow().consumeWindowSpace(sshMsgChannelExtendedData.getChannelData().length);
        channel.processChannelData(sshMsgChannelExtendedData);
    }

    private void onMsgChannelOpen(SshMsgChannelOpen sshMsgChannelOpen) throws IOException {
        log.info(new StringBuffer().append("Request for ").append(sshMsgChannelOpen.getChannelType()).append(" channel recieved").toString());
        ChannelFactory channelFactory = (ChannelFactory)this.allowedChannels.get(sshMsgChannelOpen.getChannelType());
        if (channelFactory == null) {
            this.sendChannelOpenFailure(sshMsgChannelOpen.getSenderChannelId(), 2L, "The channel type is not supported", "");
            log.info(new StringBuffer().append("Request for channel type ").append(sshMsgChannelOpen.getChannelType()).append(" refused").toString());
            return;
        }
        try {
            log.info(new StringBuffer().append("Creating channel ").append(sshMsgChannelOpen.getChannelType()).toString());
            Channel channel = channelFactory.createChannel(sshMsgChannelOpen.getChannelType(), sshMsgChannelOpen.getChannelData());
            log.info("Initiating channel");
            Long l = this.getChannelId();
            channel.init(this, l, sshMsgChannelOpen.getSenderChannelId(), sshMsgChannelOpen.getInitialWindowSize(), sshMsgChannelOpen.getMaximumPacketSize());
            this.activeChannels.put(l, channel);
            log.info("Sending channel open confirmation");
            this.sendChannelOpenConfirmation(channel);
            channel.open();
        }
        catch (InvalidChannelException invalidChannelException) {
            this.sendChannelOpenFailure(sshMsgChannelOpen.getSenderChannelId(), 2L, invalidChannelException.getMessage(), "");
        }
    }

    private void onMsgChannelRequest(SshMsgChannelRequest sshMsgChannelRequest) throws IOException {
        Channel channel = this.getChannel(sshMsgChannelRequest.getRecipientChannel());
        if (channel == null) {
            log.warn("Remote computer tried to make a request for a non existence channel!");
        }
        channel.onChannelRequest(sshMsgChannelRequest.getRequestType(), sshMsgChannelRequest.getWantReply(), sshMsgChannelRequest.getChannelData());
    }

    private void onMsgChannelWindowAdjust(SshMsgChannelWindowAdjust sshMsgChannelWindowAdjust) throws IOException {
        Channel channel = this.getChannel(sshMsgChannelWindowAdjust.getRecipientChannel());
        if (channel == null) {
            throw new IOException(new StringBuffer().append("Remote computer tried to increase window space for non existent channel ").append(String.valueOf(sshMsgChannelWindowAdjust.getRecipientChannel())).toString());
        }
        channel.getRemoteWindow().increaseWindowSpace(sshMsgChannelWindowAdjust.getBytesToAdd());
        if (log.isDebugEnabled()) {
            log.debug(new StringBuffer().append(String.valueOf(sshMsgChannelWindowAdjust.getBytesToAdd())).append(" bytes added to remote window").toString());
            log.debug(new StringBuffer().append("Remote window space is ").append(String.valueOf(channel.getRemoteWindow().getWindowSpace())).toString());
        }
    }

    private void onMsgGlobalRequest(SshMsgGlobalRequest sshMsgGlobalRequest) throws IOException {
        this.onGlobalRequest(sshMsgGlobalRequest.getRequestName(), sshMsgGlobalRequest.getWantReply(), sshMsgGlobalRequest.getRequestData());
    }

    protected void freeChannel(Channel channel) {
        log.info(new StringBuffer().append("Freeing channel ").append(String.valueOf(channel.getLocalChannelId())).append(" [").append(channel.getName()).append("]").toString());
        Long l = new Long(channel.getLocalChannelId());
        this.activeChannels.remove(l);
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError().initCause(classNotFoundException);
        }
    }
}

