/*
 * Decompiled with CFR 0.152.
 */
package com.sshtools.j2ssh.connection;

import com.sshtools.j2ssh.io.ByteArrayReader;
import com.sshtools.j2ssh.io.ByteArrayWriter;
import com.sshtools.j2ssh.transport.InvalidMessageException;
import com.sshtools.j2ssh.transport.SshMessage;
import java.io.IOException;

public class SshMsgChannelOpenConfirmation
extends SshMessage {
    private byte[] channelData;
    private long initialWindowSize;
    private long maximumPacketSize;
    private long recipientChannel;
    private long senderChannel;

    public SshMsgChannelOpenConfirmation(long l, long l2, long l3, long l4, byte[] byArray) {
        super(91);
        this.recipientChannel = l;
        this.senderChannel = l2;
        this.initialWindowSize = l3;
        this.maximumPacketSize = l4;
        this.channelData = byArray;
    }

    public SshMsgChannelOpenConfirmation() {
        super(91);
    }

    public long getInitialWindowSize() {
        return this.initialWindowSize;
    }

    public long getMaximumPacketSize() {
        return this.maximumPacketSize;
    }

    public String getMessageName() {
        return "SSH_MSG_CHANNEL_OPEN_CONFIRMATION";
    }

    public long getSenderChannel() {
        return this.senderChannel;
    }

    protected void constructByteArray(ByteArrayWriter byteArrayWriter) throws InvalidMessageException {
        try {
            byteArrayWriter.writeInt(this.recipientChannel);
            byteArrayWriter.writeInt(this.senderChannel);
            byteArrayWriter.writeInt(this.initialWindowSize);
            byteArrayWriter.writeInt(this.maximumPacketSize);
            if (this.channelData != null) {
                byteArrayWriter.write(this.channelData);
            }
        }
        catch (IOException iOException) {
            throw new InvalidMessageException("Invalid message data");
        }
    }

    protected void constructMessage(ByteArrayReader byteArrayReader) throws InvalidMessageException {
        try {
            this.recipientChannel = byteArrayReader.readInt();
            this.senderChannel = byteArrayReader.readInt();
            this.initialWindowSize = byteArrayReader.readInt();
            this.maximumPacketSize = byteArrayReader.readInt();
            if (byteArrayReader.available() > 0) {
                this.channelData = new byte[byteArrayReader.available()];
                byteArrayReader.read(this.channelData);
            }
        }
        catch (IOException iOException) {
            throw new InvalidMessageException("Invalid message data");
        }
    }
}

