/*
 * Decompiled with CFR 0.152.
 */
package com.sshtools.j2ssh.forwarding;

import com.sshtools.j2ssh.SshThread;
import com.sshtools.j2ssh.connection.ConnectionProtocol;
import com.sshtools.j2ssh.forwarding.ForwardingConfiguration;
import com.sshtools.j2ssh.forwarding.ForwardingConfigurationException;
import com.sshtools.j2ssh.forwarding.ForwardingSocketChannel;
import java.io.IOException;
import java.net.InetAddress;
import java.net.ServerSocket;
import java.net.Socket;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public abstract class ForwardingListener
extends ForwardingConfiguration
implements Runnable {
    private static Log log = LogFactory.getLog(class$com$sshtools$j2ssh$forwarding$ForwardingListener == null ? (class$com$sshtools$j2ssh$forwarding$ForwardingListener = ForwardingListener.class$("com.sshtools.j2ssh.forwarding.ForwardingListener")) : class$com$sshtools$j2ssh$forwarding$ForwardingListener);
    private ConnectionProtocol connection;
    private ServerSocket server;
    private Thread thread;
    private boolean listening;
    static /* synthetic */ Class class$com$sshtools$j2ssh$forwarding$ForwardingListener;

    public ForwardingListener(String string, ConnectionProtocol connectionProtocol, String string2, int n, String string3, int n2) {
        super(string, string2, n, string3, n2);
        log.info(new StringBuffer().append("Creating forwarding listener named '").append(string).append("'").toString());
        this.connection = connectionProtocol;
        if (log.isDebugEnabled()) {
            log.debug(new StringBuffer().append("Address to bind: ").append(this.getAddressToBind()).toString());
            log.debug(new StringBuffer().append("Port to bind: ").append(String.valueOf(this.getPortToBind())).toString());
            log.debug(new StringBuffer().append("Host to connect: ").append(string3).toString());
            log.debug(new StringBuffer().append("Port to connect: ").append(n2).toString());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void run() {
        try {
            log.info(new StringBuffer().append("Starting forwarding listener thread for '").append(this.name).append("'").toString());
            while (this.state.getValue() == 1) {
                this.listening = true;
                Socket socket = this.server.accept();
                if (this.state.getValue() == 2) break;
                if (socket == null) {
                    break;
                }
                log.info("Connection accepted, creating forwarding channel");
                try {
                    ForwardingSocketChannel forwardingSocketChannel = this.createChannel(this.hostToConnect, this.portToConnect, socket);
                    forwardingSocketChannel.bindSocket(socket);
                    if (this.connection.openChannel(forwardingSocketChannel)) {
                        log.info(new StringBuffer().append("Forwarding channel for '").append(this.name).append("' is open").toString());
                        continue;
                    }
                    log.warn(new StringBuffer().append("Failed to open forwarding chanel ").append(this.name).toString());
                    socket.close();
                }
                catch (Exception exception) {
                    log.warn(new StringBuffer().append("Failed to open forwarding chanel ").append(this.name).toString(), exception);
                    try {
                        socket.close();
                    }
                    catch (IOException iOException) {}
                }
            }
        }
        catch (IOException iOException) {
            if (this.state.getValue() == 1) {
                log.warn(new StringBuffer().append("Local forwarding listener to ").append(this.hostToConnect).append(":").append(String.valueOf(this.portToConnect)).append(" has failed").toString(), iOException);
            }
        }
        finally {
            this.stop();
        }
    }

    public void start() throws IOException {
        super.start();
        try {
            this.server = new ServerSocket(this.getPortToBind(), 50, InetAddress.getByName(this.getAddressToBind()));
        }
        catch (IOException iOException) {
            super.stop();
            throw iOException;
        }
        this.thread = new SshThread(this, "Forwarding listener", true);
        this.thread = new SshThread(this, "Forwarding listener", true);
        this.thread.start();
    }

    public void stop() {
        super.stop();
        try {
            if (this.server != null) {
                this.server.close();
            }
        }
        catch (IOException iOException) {
            log.warn("Forwarding listener failed to stop", iOException);
        }
        this.thread = null;
        this.listening = false;
    }

    protected abstract ForwardingSocketChannel createChannel(String var1, int var2, Socket var3) throws ForwardingConfigurationException;

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError().initCause(classNotFoundException);
        }
    }
}

