/*
 * Decompiled with CFR 0.152.
 */
package com.sshtools.j2ssh.net;

import com.sshtools.j2ssh.net.TransportProvider;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.InetAddress;
import java.net.Socket;
import java.net.SocketException;
import java.net.UnknownHostException;

public class SocksProxySocket
extends Socket
implements TransportProvider {
    private static final String[] SOCKSV5_ERROR = new String[]{"Success", "General SOCKS server failure", "Connection not allowed by ruleset", "Network unreachable", "Host unreachable", "Connection refused", "TTL expired", "Command not supported", "Address type not supported"};
    private static final String[] SOCKSV4_ERROR = new String[]{"Request rejected or failed", "SOCKS server cannot connect to identd on the client", "The client program and identd report different user-ids"};
    private String proxyHost;
    private int proxyPort;
    private String remoteHost;
    private int remotePort;
    private String providerDetail;

    private SocksProxySocket(String string, int n, String string2, int n2) throws IOException, UnknownHostException {
        super(string2, n2);
        this.proxyHost = string2;
        this.proxyPort = n2;
        this.remoteHost = string;
        this.remotePort = n;
    }

    public static SocksProxySocket connectViaSocks4Proxy(String string, int n, String string2, int n2, String string3) throws IOException, UnknownHostException {
        SocksProxySocket socksProxySocket = new SocksProxySocket(string, n, string2, n2);
        try {
            InputStream inputStream = socksProxySocket.getInputStream();
            OutputStream outputStream = socksProxySocket.getOutputStream();
            InetAddress inetAddress = InetAddress.getByName(string);
            outputStream.write(4);
            outputStream.write(1);
            outputStream.write(n >>> 8 & 0xFF);
            outputStream.write(n & 0xFF);
            outputStream.write(inetAddress.getAddress());
            outputStream.write(string3.getBytes());
            outputStream.write(0);
            outputStream.flush();
            int n3 = inputStream.read();
            if (n3 == -1) {
                throw new IOException(new StringBuffer().append("SOCKS4 server ").append(string2).append(":").append(n2).append(" disconnected").toString());
            }
            if (n3 != 0) {
                throw new IOException(new StringBuffer().append("Invalid response from SOCKS4 server (").append(n3).append(") ").append(string2).append(":").append(n2).toString());
            }
            int n4 = inputStream.read();
            if (n4 != 90) {
                if (n4 > 90 && n4 < 93) {
                    throw new IOException(new StringBuffer().append("SOCKS4 server unable to connect, reason: ").append(SOCKSV4_ERROR[n4 - 91]).toString());
                }
                throw new IOException(new StringBuffer().append("SOCKS4 server unable to connect, reason: ").append(n4).toString());
            }
            byte[] byArray = new byte[6];
            if (inputStream.read(byArray, 0, 6) != 6) {
                throw new IOException("SOCKS4 error reading destination address/port");
            }
            socksProxySocket.providerDetail = new StringBuffer().append(byArray[2]).append(".").append(byArray[3]).append(".").append(byArray[4]).append(".").append(byArray[5]).append(":").append(byArray[0] << 8 | byArray[1]).toString();
        }
        catch (SocketException socketException) {
            throw new SocketException(new StringBuffer().append("Error communicating with SOCKS4 server ").append(string2).append(":").append(n2).append(", ").append(socketException.getMessage()).toString());
        }
        return socksProxySocket;
    }

    public static SocksProxySocket connectViaSocks5Proxy(String string, int n, String string2, int n2, boolean bl, String string3, String string4) throws IOException, UnknownHostException {
        SocksProxySocket socksProxySocket = new SocksProxySocket(string, n, string2, n2);
        try {
            InputStream inputStream = socksProxySocket.getInputStream();
            OutputStream outputStream = socksProxySocket.getOutputStream();
            byte[] byArray = new byte[]{5, 2, 0, 2};
            byte[] byArray2 = new byte[2];
            outputStream.write(byArray);
            outputStream.flush();
            int n3 = inputStream.read();
            if (n3 == -1) {
                throw new IOException(new StringBuffer().append("SOCKS5 server ").append(string2).append(":").append(n2).append(" disconnected").toString());
            }
            if (n3 != 5) {
                throw new IOException(new StringBuffer().append("Invalid response from SOCKS5 server (").append(n3).append(") ").append(string2).append(":").append(n2).toString());
            }
            int n4 = inputStream.read();
            switch (n4) {
                case 0: {
                    break;
                }
                case 2: {
                    SocksProxySocket.performAuthentication(inputStream, outputStream, string3, string4, string2, n2);
                    break;
                }
                default: {
                    throw new IOException("SOCKS5 server does not support our authentication methods");
                }
            }
            if (bl) {
                InetAddress inetAddress;
                try {
                    inetAddress = InetAddress.getByName(string);
                }
                catch (UnknownHostException unknownHostException) {
                    throw new IOException(new StringBuffer().append("Can't do local lookup on: ").append(string).append(", try socks5 without local lookup").toString());
                }
                byArray = new byte[]{5, 1, 0, 1};
                outputStream.write(byArray);
                outputStream.write(inetAddress.getAddress());
            } else {
                byArray = new byte[]{5, 1, 0, 3};
                outputStream.write(byArray);
                outputStream.write(string.length());
                outputStream.write(string.getBytes());
            }
            outputStream.write(n >>> 8 & 0xFF);
            outputStream.write(n & 0xFF);
            outputStream.flush();
            n3 = inputStream.read();
            if (n3 != 5) {
                throw new IOException(new StringBuffer().append("Invalid response from SOCKS5 server (").append(n3).append(") ").append(string2).append(":").append(n2).toString());
            }
            int n5 = inputStream.read();
            if (n5 != 0) {
                if (n5 > 0 && n5 < 9) {
                    throw new IOException(new StringBuffer().append("SOCKS5 server unable to connect, reason: ").append(SOCKSV5_ERROR[n5]).toString());
                }
                throw new IOException(new StringBuffer().append("SOCKS5 server unable to connect, reason: ").append(n5).toString());
            }
            inputStream.read();
            int n6 = inputStream.read();
            byte[] byArray3 = new byte[255];
            switch (n6) {
                case 1: {
                    if (inputStream.read(byArray3, 0, 4) != 4) {
                        throw new IOException("SOCKS5 error reading address");
                    }
                    socksProxySocket.providerDetail = new StringBuffer().append(byArray3[0]).append(".").append(byArray3[1]).append(".").append(byArray3[2]).append(".").append(byArray3[3]).toString();
                    break;
                }
                case 3: {
                    int n7 = inputStream.read();
                    if (inputStream.read(byArray3, 0, n7) != n7) {
                        throw new IOException("SOCKS5 error reading address");
                    }
                    socksProxySocket.providerDetail = new String(byArray3);
                    break;
                }
                default: {
                    throw new IOException(new StringBuffer().append("SOCKS5 gave unsupported address type: ").append(n6).toString());
                }
            }
            if (inputStream.read(byArray3, 0, 2) != 2) {
                throw new IOException("SOCKS5 error reading port");
            }
            socksProxySocket.providerDetail = new StringBuffer().append(socksProxySocket.providerDetail).append(":").append(byArray3[0] << 8 | byArray3[1]).toString();
        }
        catch (SocketException socketException) {
            throw new SocketException(new StringBuffer().append("Error communicating with SOCKS5 server ").append(string2).append(":").append(n2).append(", ").append(socketException.getMessage()).toString());
        }
        return socksProxySocket;
    }

    private static void performAuthentication(InputStream inputStream, OutputStream outputStream, String string, String string2, String string3, int n) throws IOException {
        outputStream.write(1);
        outputStream.write(string.length());
        outputStream.write(string.getBytes());
        outputStream.write(string2.length());
        outputStream.write(string2.getBytes());
        int n2 = inputStream.read();
        if (n2 != 1 && n2 != 5) {
            throw new IOException(new StringBuffer().append("Invalid response from SOCKS5 server (").append(n2).append(") ").append(string3).append(":").append(n).toString());
        }
        if (inputStream.read() != 0) {
            throw new IOException("Invalid username/password for SOCKS5 server");
        }
    }

    public String toString() {
        return new StringBuffer().append("SocksProxySocket[addr=").append(this.getInetAddress()).append(",port=").append(this.getPort()).append(",localport=").append(this.getLocalPort()).append("]").toString();
    }

    public static SocksProxySocket connectViaSocks5Proxy(String string, int n, String string2, int n2, String string3, String string4) throws IOException, UnknownHostException {
        return SocksProxySocket.connectViaSocks5Proxy(string, n, string2, n2, false, string3, string4);
    }
}

