/*
 * Decompiled with CFR 0.152.
 */
package com.sshtools.j2ssh.openssh;

import com.sshtools.j2ssh.util.SimpleASNReader;
import java.io.IOException;
import java.math.BigInteger;

public class RSAKeyInfo {
    private BigInteger modulus;
    private BigInteger publicExponent;
    private BigInteger privateExponent;
    private BigInteger primeP;
    private BigInteger primeQ;
    private BigInteger primeExponentP;
    private BigInteger primeExponentQ;
    private BigInteger crtCoefficient;

    public RSAKeyInfo(BigInteger bigInteger, BigInteger bigInteger2, BigInteger bigInteger3, BigInteger bigInteger4, BigInteger bigInteger5, BigInteger bigInteger6, BigInteger bigInteger7, BigInteger bigInteger8) {
        this.modulus = bigInteger;
        this.publicExponent = bigInteger2;
        this.privateExponent = bigInteger3;
        this.primeP = bigInteger4;
        this.primeQ = bigInteger5;
        this.primeExponentP = bigInteger6;
        this.primeExponentQ = bigInteger7;
        this.crtCoefficient = bigInteger8;
    }

    public BigInteger getModulus() {
        return this.modulus;
    }

    public BigInteger getPrivateExponent() {
        return this.privateExponent;
    }

    public BigInteger getPublicExponent() {
        return this.publicExponent;
    }

    public static RSAKeyInfo getRSAKeyInfo(SimpleASNReader simpleASNReader) throws IOException {
        simpleASNReader.assertByte(48);
        int n = simpleASNReader.getLength();
        simpleASNReader.assertByte(2);
        byte[] byArray = simpleASNReader.getData();
        simpleASNReader.assertByte(2);
        byte[] byArray2 = simpleASNReader.getData();
        simpleASNReader.assertByte(2);
        byte[] byArray3 = simpleASNReader.getData();
        simpleASNReader.assertByte(2);
        byte[] byArray4 = simpleASNReader.getData();
        simpleASNReader.assertByte(2);
        byte[] byArray5 = simpleASNReader.getData();
        simpleASNReader.assertByte(2);
        byte[] byArray6 = simpleASNReader.getData();
        simpleASNReader.assertByte(2);
        byte[] byArray7 = simpleASNReader.getData();
        simpleASNReader.assertByte(2);
        byte[] byArray8 = simpleASNReader.getData();
        simpleASNReader.assertByte(2);
        byte[] byArray9 = simpleASNReader.getData();
        return new RSAKeyInfo(new BigInteger(byArray2), new BigInteger(byArray3), new BigInteger(byArray4), new BigInteger(byArray5), new BigInteger(byArray6), new BigInteger(byArray7), new BigInteger(byArray8), new BigInteger(byArray9));
    }
}

