/*
 * Decompiled with CFR 0.152.
 */
package com.sshtools.j2ssh.sftp;

import com.sshtools.j2ssh.io.ByteArrayReader;
import com.sshtools.j2ssh.io.ByteArrayWriter;
import com.sshtools.j2ssh.io.UnsignedInteger32;
import com.sshtools.j2ssh.io.UnsignedInteger64;
import java.io.IOException;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Vector;

public class FileAttributes {
    int version = 3;
    long flags = 0L;
    UnsignedInteger64 size = null;
    UnsignedInteger32 uid = null;
    UnsignedInteger32 gid = null;
    String owner = null;
    String group = null;
    UnsignedInteger32 permissions = null;
    UnsignedInteger32 atime = null;
    UnsignedInteger32 createtime = null;
    UnsignedInteger32 mtime = null;
    List acl = new Vector();
    Map extended = new HashMap();
    char[] types = new char[]{'p', 'c', 'd', 'b', '-', 'l', 's'};

    public FileAttributes() {
    }

    public FileAttributes(ByteArrayReader byteArrayReader) throws IOException {
        this.flags = byteArrayReader.readInt();
        if (this.isFlagSet(1)) {
            this.size = byteArrayReader.readUINT64();
        }
        if (this.isFlagSet(2)) {
            this.uid = byteArrayReader.readUINT32();
            this.gid = byteArrayReader.readUINT32();
        }
        if (this.isFlagSet(4)) {
            this.permissions = byteArrayReader.readUINT32();
        }
        if (this.isFlagSet(8)) {
            this.atime = byteArrayReader.readUINT32();
            this.mtime = byteArrayReader.readUINT32();
        }
        if (this.isFlagSet(0x8000000)) {
            int n = (int)byteArrayReader.readInt();
            for (int i = 0; i < n; ++i) {
                String string = byteArrayReader.readString();
                String string2 = byteArrayReader.readString();
                this.extended.put(string, string2);
            }
        }
    }

    public UnsignedInteger32 getUID() {
        if (this.uid != null) {
            return this.uid;
        }
        return new UnsignedInteger32(0L);
    }

    public UnsignedInteger32 getGID() {
        if (this.gid != null) {
            return this.gid;
        }
        return new UnsignedInteger32(0L);
    }

    public UnsignedInteger64 getSize() {
        if (this.size != null) {
            return this.size;
        }
        return new UnsignedInteger64("0");
    }

    public void setPermissions(UnsignedInteger32 unsignedInteger32) {
        this.permissions = unsignedInteger32;
        this.flags = unsignedInteger32 != null ? (this.flags |= 4L) : (this.flags ^= 4L);
    }

    public UnsignedInteger32 getPermissions() {
        return this.permissions;
    }

    public void setTimes(UnsignedInteger32 unsignedInteger32, UnsignedInteger32 unsignedInteger322) {
        this.atime = unsignedInteger32;
        this.mtime = unsignedInteger322;
        this.flags = unsignedInteger32 != null ? (this.flags |= 8L) : (this.flags ^= 8L);
    }

    public UnsignedInteger32 getAccessedTime() {
        return this.atime;
    }

    public UnsignedInteger32 getModifiedTime() {
        if (this.mtime != null) {
            return this.mtime;
        }
        return new UnsignedInteger32(0L);
    }

    public boolean isFlagSet(int n) {
        return (this.flags & (long)n) == (long)n;
    }

    public byte[] toByteArray() throws IOException {
        ByteArrayWriter byteArrayWriter = new ByteArrayWriter();
        if (this.extended.size() > 0) {
            this.flags |= 0x8000000L;
        }
        byteArrayWriter.writeInt(this.flags);
        if (this.isFlagSet(1)) {
            byteArrayWriter.writeUINT64(this.size);
        }
        if (this.isFlagSet(2)) {
            if (this.uid != null) {
                byteArrayWriter.writeUINT32(this.uid);
            } else {
                byteArrayWriter.writeInt(0);
            }
            if (this.gid != null) {
                byteArrayWriter.writeUINT32(this.gid);
            } else {
                byteArrayWriter.writeInt(0);
            }
        }
        if (this.isFlagSet(4)) {
            byteArrayWriter.writeUINT32(this.permissions);
        }
        if (this.isFlagSet(8)) {
            byteArrayWriter.writeUINT32(this.atime);
            byteArrayWriter.writeUINT32(this.mtime);
        }
        if (this.isFlagSet(0x8000000)) {
            byteArrayWriter.writeInt(this.extended.size());
            for (Map.Entry entry : this.extended.entrySet()) {
                byteArrayWriter.writeString((String)entry.getKey());
                byteArrayWriter.writeString((String)entry.getValue());
            }
        }
        return byteArrayWriter.toByteArray();
    }

    private String rwxString(int n, int n2) {
        String string = new StringBuffer().append(((n >>>= n2) & 4) != 0 ? "r" : "-").append((n & 2) != 0 ? "w" : "-").toString();
        string = n2 == 6 && (this.permissions.intValue() & 0x800) == 2048 || n2 == 3 && (this.permissions.intValue() & 0x400) == 1024 ? new StringBuffer().append(string).append((n & 1) != 0 ? "s" : "S").toString() : new StringBuffer().append(string).append((n & 1) != 0 ? "x" : "-").toString();
        return string;
    }

    public String getPermissionsString() {
        if (this.permissions != null) {
            StringBuffer stringBuffer = new StringBuffer();
            stringBuffer.append(this.types[(this.permissions.intValue() & 0xF000) >>> 13]);
            stringBuffer.append(this.rwxString(this.permissions.intValue(), 6));
            stringBuffer.append(this.rwxString(this.permissions.intValue(), 3));
            stringBuffer.append(this.rwxString(this.permissions.intValue(), 0));
            return stringBuffer.toString();
        }
        return "";
    }

    public String getModTimeString() {
        if (this.mtime == null) {
            return "";
        }
        long l = this.mtime.longValue() * 1000L;
        long l2 = System.currentTimeMillis();
        SimpleDateFormat simpleDateFormat = l2 - l > 15552000000L ? new SimpleDateFormat("MMM dd  yyyy") : new SimpleDateFormat("MMM dd hh:mm");
        return simpleDateFormat.format(new Date(l));
    }

    public boolean isDirectory() {
        if (this.permissions == null) {
            return false;
        }
        return (this.permissions.intValue() & 0xF000) == 16384;
    }

    public boolean isLink() {
        if (this.permissions == null) {
            return false;
        }
        return (this.permissions.intValue() & 0xF000) == 40960;
    }
}

