/*
 * Decompiled with CFR 0.152.
 */
package com.sshtools.j2ssh.sftp;

import com.sshtools.j2ssh.io.UnsignedInteger64;
import com.sshtools.j2ssh.sftp.SftpFile;
import java.io.IOException;
import java.io.InputStream;

public class SftpFileInputStream
extends InputStream {
    SftpFile file;
    UnsignedInteger64 position;

    public SftpFileInputStream(SftpFile sftpFile, long l) throws IOException {
        if (sftpFile.getHandle() == null) {
            throw new IOException("The file does not have a valid handle!");
        }
        if (sftpFile.getSFTPSubsystem() == null) {
            throw new IOException("The file is not attached to an SFTP subsystem!");
        }
        this.file = sftpFile;
        this.position = new UnsignedInteger64(new StringBuffer().append("").append(l).toString());
    }

    public long getPosition() {
        return this.position.longValue();
    }

    public void setPosition(long l) {
        this.position = new UnsignedInteger64(new StringBuffer().append("").append(l).toString());
    }

    public int read(byte[] byArray, int n, int n2) throws IOException {
        int n3 = this.file.getSFTPSubsystem().readFile(this.file.getHandle(), this.position, byArray, n, n2);
        if (n3 > 0) {
            this.position = UnsignedInteger64.add(this.position, n3);
        }
        return n3;
    }

    public int read() throws IOException {
        byte[] byArray = new byte[1];
        int n = this.file.getSFTPSubsystem().readFile(this.file.getHandle(), this.position, byArray, 0, 1);
        this.position = UnsignedInteger64.add(this.position, n);
        return byArray[0] & 0xFF;
    }

    public void close() throws IOException {
        this.file.close();
    }

    protected void finalize() throws IOException {
        if (this.file.getHandle() != null) {
            this.close();
        }
    }
}

