/*
 * Decompiled with CFR 0.152.
 */
package com.sshtools.j2ssh.transport;

import com.sshtools.j2ssh.transport.ServiceState;
import com.sshtools.j2ssh.transport.SshMessageStore;
import com.sshtools.j2ssh.transport.TransportProtocol;
import java.io.IOException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public abstract class Service {
    private static Log log = LogFactory.getLog(class$com$sshtools$j2ssh$transport$Service == null ? (class$com$sshtools$j2ssh$transport$Service = Service.class$("com.sshtools.j2ssh.transport.Service")) : class$com$sshtools$j2ssh$transport$Service);
    protected SshMessageStore messageStore = new SshMessageStore();
    protected TransportProtocol transport;
    protected Integer startMode = null;
    protected ServiceState state = new ServiceState();
    private String serviceName;
    static /* synthetic */ Class class$com$sshtools$j2ssh$transport$Service;

    public Service(String string) {
        this.serviceName = string;
    }

    public final String getServiceName() {
        return this.serviceName;
    }

    public final void start() throws IOException {
        if (this.startMode == null) {
            throw new IOException("Service must be initialized first!");
        }
        if (this.startMode == 1) {
            log.info(new StringBuffer().append(this.serviceName).append(" has been accepted").toString());
            this.onServiceAccept();
        } else {
            log.info(new StringBuffer().append(this.serviceName).append(" has been requested").toString());
            this.onServiceRequest();
        }
        this.onStart();
        this.state.setValue(2);
    }

    protected abstract void onStart() throws IOException;

    public ServiceState getState() {
        return this.state;
    }

    public void init(int n, TransportProtocol transportProtocol) throws IOException {
        if (n != 1 && n != 2) {
            throw new IOException("Invalid start mode!");
        }
        this.transport = transportProtocol;
        this.startMode = new Integer(n);
        this.onServiceInit(n);
        transportProtocol.addMessageStore(this.messageStore);
    }

    public final void stop() {
        this.messageStore.close();
        this.state.setValue(3);
    }

    protected abstract void onServiceAccept() throws IOException;

    protected abstract void onServiceInit(int var1) throws IOException;

    protected abstract void onServiceRequest() throws IOException;

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError().initCause(classNotFoundException);
        }
    }
}

