/*
 * Decompiled with CFR 0.152.
 */
package com.sshtools.j2ssh.transport.cipher;

import com.sshtools.j2ssh.configuration.ConfigurationLoader;
import com.sshtools.j2ssh.io.IOUtil;
import com.sshtools.j2ssh.transport.AlgorithmNotSupportedException;
import com.sshtools.j2ssh.transport.cipher.SshCipher;
import java.io.InputStream;
import java.net.URL;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.List;
import java.util.Properties;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class SshCipherFactory {
    private static HashMap ciphers;
    private static String defaultCipher;
    private static Log log;
    private static ArrayList supported;
    static /* synthetic */ Class class$com$sshtools$j2ssh$transport$cipher$SshCipherFactory;
    static /* synthetic */ Class class$com$sshtools$j2ssh$transport$cipher$TripleDesCbc;
    static /* synthetic */ Class class$com$sshtools$j2ssh$transport$cipher$BlowfishCbc;

    protected SshCipherFactory() {
    }

    public static String getDefaultCipher() {
        return defaultCipher;
    }

    public static List getSupportedCiphers() {
        return supported;
    }

    public static SshCipher newInstance(String string) throws AlgorithmNotSupportedException {
        log.info(new StringBuffer().append("Creating new ").append(string).append(" cipher instance").toString());
        try {
            return (SshCipher)((Class)ciphers.get(string)).newInstance();
        }
        catch (Throwable throwable) {
            throw new AlgorithmNotSupportedException(new StringBuffer().append(string).append(" is not supported!").toString());
        }
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError().initCause(classNotFoundException);
        }
    }

    static {
        log = LogFactory.getLog(class$com$sshtools$j2ssh$transport$cipher$SshCipherFactory == null ? (class$com$sshtools$j2ssh$transport$cipher$SshCipherFactory = SshCipherFactory.class$("com.sshtools.j2ssh.transport.cipher.SshCipherFactory")) : class$com$sshtools$j2ssh$transport$cipher$SshCipherFactory);
        ciphers = new HashMap();
        log.info("Loading supported cipher algorithms");
        ciphers.put("3des-cbc", class$com$sshtools$j2ssh$transport$cipher$TripleDesCbc == null ? (class$com$sshtools$j2ssh$transport$cipher$TripleDesCbc = SshCipherFactory.class$("com.sshtools.j2ssh.transport.cipher.TripleDesCbc")) : class$com$sshtools$j2ssh$transport$cipher$TripleDesCbc);
        ciphers.put("blowfish-cbc", class$com$sshtools$j2ssh$transport$cipher$BlowfishCbc == null ? (class$com$sshtools$j2ssh$transport$cipher$BlowfishCbc = SshCipherFactory.class$("com.sshtools.j2ssh.transport.cipher.BlowfishCbc")) : class$com$sshtools$j2ssh$transport$cipher$BlowfishCbc);
        defaultCipher = "blowfish-cbc";
        try {
            Enumeration<URL> enumeration = ConfigurationLoader.getExtensionClassLoader().getResources("j2ssh.cipher");
            Properties properties = new Properties();
            while (enumeration != null && enumeration.hasMoreElements()) {
                URL uRL = enumeration.nextElement();
                InputStream inputStream = uRL.openStream();
                properties.load(inputStream);
                IOUtil.closeStream(inputStream);
                int n = 1;
                String string = "";
                while (properties.getProperty(new StringBuffer().append("cipher.name.").append(String.valueOf(n)).toString()) != null) {
                    try {
                        string = properties.getProperty(new StringBuffer().append("cipher.name.").append(String.valueOf(n)).toString());
                        Class<?> clazz = ConfigurationLoader.getExtensionClassLoader().loadClass(properties.getProperty(new StringBuffer().append("cipher.class.").append(String.valueOf(n)).toString()));
                        clazz.newInstance();
                        ciphers.put(string, clazz);
                        log.info(new StringBuffer().append("Installed ").append(string).append(" cipher").toString());
                    }
                    catch (Throwable throwable) {
                        log.info(new StringBuffer().append("Could not install cipher class for ").append(string).toString(), throwable);
                    }
                    ++n;
                }
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        supported = new ArrayList(ciphers.keySet());
    }
}

