/*
 * Decompiled with CFR 0.152.
 */
package com.sshtools.j2ssh.transport.kex;

import com.sshtools.j2ssh.io.ByteArrayReader;
import com.sshtools.j2ssh.io.ByteArrayWriter;
import com.sshtools.j2ssh.transport.InvalidMessageException;
import com.sshtools.j2ssh.transport.SshMessage;
import java.io.IOException;
import java.math.BigInteger;

public class SshMsgKexDhReply
extends SshMessage {
    private BigInteger f;
    private byte[] hostKey;
    private byte[] signature;

    public SshMsgKexDhReply() {
        super(31);
    }

    public BigInteger getF() {
        return this.f;
    }

    public byte[] getHostKey() {
        return this.hostKey;
    }

    public String getMessageName() {
        return "SSH_MSG_KEXDH_REPLY";
    }

    public byte[] getSignature() {
        return this.signature;
    }

    protected void constructByteArray(ByteArrayWriter byteArrayWriter) throws InvalidMessageException {
        try {
            byteArrayWriter.writeBinaryString(this.hostKey);
            byteArrayWriter.writeBigInteger(this.f);
            byteArrayWriter.writeBinaryString(this.signature);
        }
        catch (IOException iOException) {
            throw new InvalidMessageException(new StringBuffer().append("Error writing message data: ").append(iOException.getMessage()).toString());
        }
    }

    protected void constructMessage(ByteArrayReader byteArrayReader) throws InvalidMessageException {
        try {
            this.hostKey = byteArrayReader.readBinaryString();
            this.f = byteArrayReader.readBigInteger();
            this.signature = byteArrayReader.readBinaryString();
        }
        catch (IOException iOException) {
            throw new InvalidMessageException(new StringBuffer().append("Error reading message data: ").append(iOException.getMessage()).toString());
        }
    }
}

