/*
 * Decompiled with CFR 0.152.
 */
package com.sshtools.j2ssh.transport.publickey;

import com.sshtools.j2ssh.configuration.ConfigurationException;
import com.sshtools.j2ssh.configuration.ConfigurationLoader;
import com.sshtools.j2ssh.configuration.ExtensionAlgorithm;
import com.sshtools.j2ssh.configuration.SshAPIConfiguration;
import com.sshtools.j2ssh.transport.AlgorithmNotSupportedException;
import com.sshtools.j2ssh.transport.publickey.SshKeyPair;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class SshKeyPairFactory {
    private static Map pks;
    private static String defaultAlgorithm;
    private static Log log;
    static /* synthetic */ Class class$com$sshtools$j2ssh$transport$publickey$SshKeyPairFactory;
    static /* synthetic */ Class class$com$sshtools$j2ssh$transport$publickey$dsa$SshDssKeyPair;
    static /* synthetic */ Class class$com$sshtools$j2ssh$transport$publickey$rsa$SshRsaKeyPair;
    static /* synthetic */ Class class$com$sshtools$j2ssh$configuration$SshAPIConfiguration;

    protected SshKeyPairFactory() {
    }

    public static String getDefaultPublicKey() {
        return defaultAlgorithm;
    }

    public static List getSupportedKeys() {
        return new ArrayList(pks.keySet());
    }

    public static SshKeyPair newInstance(String string) throws AlgorithmNotSupportedException {
        try {
            return (SshKeyPair)((Class)pks.get(string)).newInstance();
        }
        catch (Exception exception) {
            throw new AlgorithmNotSupportedException(new StringBuffer().append(string).append(" is not supported!").toString());
        }
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError().initCause(classNotFoundException);
        }
    }

    static {
        Object object;
        log = LogFactory.getLog(class$com$sshtools$j2ssh$transport$publickey$SshKeyPairFactory == null ? (class$com$sshtools$j2ssh$transport$publickey$SshKeyPairFactory = SshKeyPairFactory.class$("com.sshtools.j2ssh.transport.publickey.SshKeyPairFactory")) : class$com$sshtools$j2ssh$transport$publickey$SshKeyPairFactory);
        pks = new HashMap();
        log.info("Loading public key algorithms");
        pks.put("ssh-dss", class$com$sshtools$j2ssh$transport$publickey$dsa$SshDssKeyPair == null ? (class$com$sshtools$j2ssh$transport$publickey$dsa$SshDssKeyPair = SshKeyPairFactory.class$("com.sshtools.j2ssh.transport.publickey.dsa.SshDssKeyPair")) : class$com$sshtools$j2ssh$transport$publickey$dsa$SshDssKeyPair);
        pks.put("ssh-rsa", class$com$sshtools$j2ssh$transport$publickey$rsa$SshRsaKeyPair == null ? (class$com$sshtools$j2ssh$transport$publickey$rsa$SshRsaKeyPair = SshKeyPairFactory.class$("com.sshtools.j2ssh.transport.publickey.rsa.SshRsaKeyPair")) : class$com$sshtools$j2ssh$transport$publickey$rsa$SshRsaKeyPair);
        try {
            if (ConfigurationLoader.isConfigurationAvailable(class$com$sshtools$j2ssh$configuration$SshAPIConfiguration == null ? (class$com$sshtools$j2ssh$configuration$SshAPIConfiguration = SshKeyPairFactory.class$("com.sshtools.j2ssh.configuration.SshAPIConfiguration")) : class$com$sshtools$j2ssh$configuration$SshAPIConfiguration) && (object = (SshAPIConfiguration)ConfigurationLoader.getConfiguration(class$com$sshtools$j2ssh$configuration$SshAPIConfiguration == null ? (class$com$sshtools$j2ssh$configuration$SshAPIConfiguration = SshKeyPairFactory.class$("com.sshtools.j2ssh.configuration.SshAPIConfiguration")) : class$com$sshtools$j2ssh$configuration$SshAPIConfiguration)) != null) {
                List list = object.getPublicKeyExtensions();
                if (list != null) {
                    for (ExtensionAlgorithm extensionAlgorithm : list) {
                        String string = extensionAlgorithm.getAlgorithmName();
                        if (pks.containsKey(string)) {
                            log.debug(new StringBuffer().append("Standard public key ").append(string).append(" is being overidden by ").append(extensionAlgorithm.getImplementationClass()).toString());
                        } else {
                            log.debug(new StringBuffer().append(extensionAlgorithm.getAlgorithmName()).append(" public key is implemented by ").append(extensionAlgorithm.getImplementationClass()).toString());
                        }
                        try {
                            pks.put(extensionAlgorithm.getAlgorithmName(), ConfigurationLoader.getExtensionClass(extensionAlgorithm.getImplementationClass()));
                        }
                        catch (ClassNotFoundException classNotFoundException) {
                            log.error(new StringBuffer().append("Could not locate ").append(extensionAlgorithm.getImplementationClass()).toString());
                        }
                    }
                }
                defaultAlgorithm = object.getDefaultPublicKey();
            }
        }
        catch (ConfigurationException configurationException) {
            // empty catch block
        }
        if (defaultAlgorithm == null || !pks.containsKey(defaultAlgorithm)) {
            log.debug("The default public key is not set! using first in list");
            object = pks.keySet().iterator();
            defaultAlgorithm = (String)object.next();
        }
    }
}

