/*
 * Decompiled with CFR 0.152.
 */
package com.sshtools.j2ssh.transport.publickey;

import com.sshtools.j2ssh.io.ByteArrayReader;
import com.sshtools.j2ssh.transport.publickey.Base64EncodedFileFormat;
import com.sshtools.j2ssh.transport.publickey.InvalidSshKeyException;
import com.sshtools.j2ssh.transport.publickey.SshPrivateKeyFormat;
import com.sshtools.j2ssh.util.Hash;
import java.security.Key;
import java.security.NoSuchAlgorithmException;
import javax.crypto.Cipher;
import javax.crypto.SecretKey;
import javax.crypto.SecretKeyFactory;
import javax.crypto.spec.DESedeKeySpec;
import javax.crypto.spec.IvParameterSpec;

public class SshtoolsPrivateKeyFormat
extends Base64EncodedFileFormat
implements SshPrivateKeyFormat {
    private static String BEGIN = "---- BEGIN SSHTOOLS ENCRYPTED PRIVATE KEY ----";
    private static String END = "---- END SSHTOOLS ENCRYPTED PRIVATE KEY ----";
    private int cookie = 1391688382;

    public SshtoolsPrivateKeyFormat(String string, String string2) {
        super(BEGIN, END);
        this.setHeaderValue("Subject", string);
        this.setHeaderValue("Comment", string2);
    }

    public SshtoolsPrivateKeyFormat() {
        super(BEGIN, END);
    }

    public String getFormatType() {
        return new StringBuffer().append("SSHTools-PrivateKey-").append(super.getFormatType()).toString();
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public byte[] decryptKeyblob(byte[] byArray, String string) throws InvalidSshKeyException {
        try {
            byte[] byArray2 = this.getKeyBlob(byArray);
            ByteArrayReader byteArrayReader = new ByteArrayReader(byArray2);
            String string2 = byteArrayReader.readString();
            if (!string2.equalsIgnoreCase("3des-cbc")) return byteArrayReader.readBinaryString();
            byte[] byArray3 = this.makePassphraseKey(string);
            byte[] byArray4 = new byte[8];
            if (string2.equals("3DES-CBC")) {
                byteArrayReader.read(byArray4);
            }
            byArray2 = byteArrayReader.readBinaryString();
            Cipher cipher = Cipher.getInstance("DESede/CBC/PKCS5Padding");
            DESedeKeySpec dESedeKeySpec = new DESedeKeySpec(byArray3);
            SecretKey secretKey = SecretKeyFactory.getInstance("DESede").generateSecret(dESedeKeySpec);
            cipher.init(2, (Key)secretKey, new IvParameterSpec(byArray4, 0, cipher.getBlockSize()));
            ByteArrayReader byteArrayReader2 = new ByteArrayReader(cipher.doFinal(byArray2));
            if (byteArrayReader2.readInt() != (long)this.cookie) throw new InvalidSshKeyException("The host key is invalid, check the passphrase supplied");
            return byteArrayReader2.readBinaryString();
        }
        catch (Exception exception) {
            throw new InvalidSshKeyException("Failed to read host key");
        }
    }

    private byte[] makePassphraseKey(String string) {
        try {
            Hash hash = new Hash("MD5");
            hash.putBytes(string.getBytes());
            byte[] byArray = hash.doFinal();
            hash.reset();
            hash.putBytes(string.getBytes());
            hash.putBytes(byArray);
            byte[] byArray2 = hash.doFinal();
            byte[] byArray3 = new byte[32];
            System.arraycopy(byArray, 0, byArray3, 0, 16);
            System.arraycopy(byArray2, 0, byArray3, 16, 16);
            return byArray3;
        }
        catch (NoSuchAlgorithmException noSuchAlgorithmException) {
            return null;
        }
    }
}

