/*
 * Decompiled with CFR 0.152.
 */
package com.sshtools.j2ssh.transport.publickey.rsa;

import com.sshtools.j2ssh.io.ByteArrayReader;
import com.sshtools.j2ssh.io.ByteArrayWriter;
import com.sshtools.j2ssh.transport.publickey.InvalidSshKeyException;
import com.sshtools.j2ssh.transport.publickey.SshPrivateKey;
import com.sshtools.j2ssh.transport.publickey.SshPublicKey;
import com.sshtools.j2ssh.transport.publickey.rsa.SshRsaPublicKey;
import java.math.BigInteger;
import java.security.KeyFactory;
import java.security.Signature;
import java.security.interfaces.RSAPrivateKey;
import java.security.interfaces.RSAPublicKey;
import java.security.spec.RSAPrivateKeySpec;
import java.security.spec.RSAPublicKeySpec;

public class SshRsaPrivateKey
extends SshPrivateKey {
    RSAPrivateKey prvKey;
    RSAPublicKey pubKey;

    public SshRsaPrivateKey(byte[] byArray) throws InvalidSshKeyException {
        try {
            ByteArrayReader byteArrayReader = new ByteArrayReader(byArray);
            String string = byteArrayReader.readString();
            if (!string.equals(this.getAlgorithmName())) {
                throw new InvalidSshKeyException();
            }
            BigInteger bigInteger = byteArrayReader.readBigInteger();
            BigInteger bigInteger2 = byteArrayReader.readBigInteger();
            BigInteger bigInteger3 = byteArrayReader.readBigInteger();
            RSAPrivateKeySpec rSAPrivateKeySpec = new RSAPrivateKeySpec(bigInteger2, bigInteger3);
            RSAPublicKeySpec rSAPublicKeySpec = new RSAPublicKeySpec(bigInteger2, bigInteger);
            KeyFactory keyFactory = KeyFactory.getInstance("RSA");
            this.prvKey = (RSAPrivateKey)keyFactory.generatePrivate(rSAPrivateKeySpec);
            this.pubKey = (RSAPublicKey)keyFactory.generatePublic(rSAPublicKeySpec);
        }
        catch (Exception exception) {
            throw new InvalidSshKeyException();
        }
    }

    public boolean equals(Object object) {
        if (object instanceof SshRsaPrivateKey) {
            return this.prvKey.equals(((SshRsaPrivateKey)object).prvKey);
        }
        return false;
    }

    public int hashCode() {
        return this.prvKey.hashCode();
    }

    public String getAlgorithmName() {
        return "ssh-rsa";
    }

    public SshPublicKey getPublicKey() {
        return new SshRsaPublicKey(this.pubKey);
    }

    public byte[] generateSignature(byte[] byArray) {
        try {
            Signature signature = Signature.getInstance("SHA1withRSA");
            signature.initSign(this.prvKey);
            signature.update(byArray);
            ByteArrayWriter byteArrayWriter = new ByteArrayWriter();
            byteArrayWriter.writeString(this.getAlgorithmName());
            byteArrayWriter.writeBinaryString(signature.sign());
            return byteArrayWriter.toByteArray();
        }
        catch (Exception exception) {
            return null;
        }
    }
}

