/*
 * Decompiled with CFR 0.152.
 */
package com.sshtools.j2ssh.util;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.Set;
import java.util.Vector;
import java.util.zip.ZipEntry;
import java.util.zip.ZipException;
import java.util.zip.ZipFile;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class ExtensionClassLoader
extends ClassLoader {
    private static Log log = LogFactory.getLog(class$com$sshtools$j2ssh$util$ExtensionClassLoader == null ? (class$com$sshtools$j2ssh$util$ExtensionClassLoader = ExtensionClassLoader.class$("com.sshtools.j2ssh.util.ExtensionClassLoader")) : class$com$sshtools$j2ssh$util$ExtensionClassLoader);
    Vector classpath = new Vector();
    private Hashtable cache = new Hashtable();
    private HashMap packages = new HashMap();
    static /* synthetic */ Class class$com$sshtools$j2ssh$util$ExtensionClassLoader;

    public ExtensionClassLoader() {
    }

    public ExtensionClassLoader(ClassLoader classLoader) {
        super(classLoader);
    }

    public void add(File file) {
        if (!file.exists()) {
            throw new IllegalArgumentException(new StringBuffer().append("Classpath ").append(file.getAbsolutePath()).append(" doesn't exist!").toString());
        }
        if (!file.canRead()) {
            throw new IllegalArgumentException(new StringBuffer().append("Don't have read access for file ").append(file.getAbsolutePath()).toString());
        }
        if (!file.isDirectory() && !this.isJarArchive(file)) {
            throw new IllegalArgumentException(new StringBuffer().append(file.getAbsolutePath()).append(" is not a directory or jar file").append(" or if it's a jar file then it is corrupted.").toString());
        }
        log.info(new StringBuffer().append("Adding ").append(file.getAbsolutePath()).append(" to the extension classpath").toString());
        this.classpath.add(file);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isJarArchive(File file) {
        boolean bl = true;
        ZipFile zipFile = null;
        try {
            zipFile = new ZipFile(file);
        }
        catch (ZipException zipException) {
            bl = false;
        }
        catch (IOException iOException) {
            bl = false;
        }
        finally {
            if (zipFile != null) {
                try {
                    zipFile.close();
                }
                catch (IOException iOException) {}
            }
        }
        return bl;
    }

    protected URL findResource(String string) {
        URL uRL = null;
        for (File file : this.classpath) {
            uRL = file.isDirectory() ? this.findResourceInDirectory(file, string) : this.findResourceInZipfile(file, string);
            if (uRL != null) {
                if (log.isDebugEnabled()) {
                    log.debug(new StringBuffer().append("Found resource ").append(uRL.toExternalForm()).toString());
                }
                return uRL;
            }
            if (!log.isDebugEnabled()) continue;
            log.debug(new StringBuffer().append("Could not find resource ").append(string).toString());
        }
        return null;
    }

    protected Enumeration findResources(String string) {
        HashSet<URL> hashSet = new HashSet<URL>();
        URL uRL = null;
        for (File file : this.classpath) {
            uRL = file.isDirectory() ? this.findResourceInDirectory(file, string) : this.findResourceInZipfile(file, string);
            if (uRL == null) continue;
            if (log.isDebugEnabled()) {
                log.debug(new StringBuffer().append("Found resource ").append(uRL.toExternalForm()).toString());
            }
            hashSet.add(uRL);
        }
        return new ResourceEnumeration(hashSet);
    }

    public Class findClass(String string) throws ClassNotFoundException {
        Class<?> clazz = null;
        ClassCacheEntry classCacheEntry = (ClassCacheEntry)this.cache.get(string);
        if (classCacheEntry != null) {
            if (log.isDebugEnabled()) {
                log.debug(new StringBuffer().append("Loaded ").append(string).append(" from cache").toString());
            }
            clazz = classCacheEntry.loadedClass;
            this.resolveClass(clazz);
            return clazz;
        }
        Iterator iterator = this.classpath.iterator();
        ClassCacheEntry classCacheEntry2 = new ClassCacheEntry();
        while (iterator.hasNext()) {
            byte[] byArray;
            File file = (File)iterator.next();
            try {
                byArray = file.isDirectory() ? this.loadClassFromDirectory(file, string, classCacheEntry2) : this.loadClassFromZipfile(file, string, classCacheEntry2);
            }
            catch (IOException iOException) {
                byArray = null;
            }
            if (byArray == null) continue;
            String string2 = "";
            if (string.lastIndexOf(".") > 0) {
                string2 = string.substring(0, string.lastIndexOf("."));
            }
            if (!string2.equals("") && !this.packages.containsKey(string2)) {
                this.packages.put(string2, this.definePackage(string2, "", "", "", "", "", "", null));
            }
            classCacheEntry2.loadedClass = clazz = this.defineClass(string, byArray, 0, byArray.length);
            classCacheEntry2.lastModified = classCacheEntry2.origin.lastModified();
            this.cache.put(string, classCacheEntry2);
            this.resolveClass(clazz);
            if (log.isDebugEnabled()) {
                log.debug(new StringBuffer().append("Loaded ").append(string).append(" adding to cache and returning").toString());
            }
            return clazz;
        }
        throw new ClassNotFoundException(string);
    }

    private byte[] loadBytesFromStream(InputStream inputStream, int n) throws IOException {
        int n2;
        byte[] byArray = new byte[n];
        int n3 = 0;
        while (n > 0 && (n2 = inputStream.read(byArray, n3, n)) != -1) {
            n3 += n2;
            n -= n2;
        }
        return byArray;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private byte[] loadClassFromDirectory(File file, String string, ClassCacheEntry classCacheEntry) throws IOException {
        File file2;
        String string2 = new StringBuffer().append(string.replace('.', File.separatorChar)).append(".class").toString();
        if (!Character.isJavaIdentifierStart(string2.charAt(0))) {
            int n = 1;
            while (!Character.isJavaIdentifierStart(string2.charAt(n++))) {
            }
            string2 = string2.substring(n);
        }
        if ((file2 = new File(file, string2)).exists()) {
            if (classCacheEntry != null) {
                classCacheEntry.origin = file2;
            }
            FileInputStream fileInputStream = new FileInputStream(file2);
            try {
                byte[] byArray = this.loadBytesFromStream(fileInputStream, (int)file2.length());
                return byArray;
            }
            finally {
                ((InputStream)fileInputStream).close();
            }
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private byte[] loadClassFromZipfile(File file, String string, ClassCacheEntry classCacheEntry) throws IOException {
        String string2 = new StringBuffer().append(string.replace('.', '/')).append(".class").toString();
        ZipFile zipFile = new ZipFile(file);
        try {
            ZipEntry zipEntry = zipFile.getEntry(string2);
            if (zipEntry != null) {
                if (classCacheEntry != null) {
                    classCacheEntry.origin = file;
                }
                byte[] byArray = this.loadBytesFromStream(zipFile.getInputStream(zipEntry), (int)zipEntry.getSize());
                return byArray;
            }
            byte[] byArray = null;
            return byArray;
        }
        finally {
            zipFile.close();
        }
    }

    private URL findResourceInDirectory(File file, String string) {
        String string2 = string.replace('/', File.separatorChar);
        File file2 = new File(file, string2);
        if (file2.exists()) {
            try {
                return file2.toURL();
            }
            catch (MalformedURLException malformedURLException) {
                return null;
            }
        }
        return null;
    }

    private URL findResourceInZipfile(File file, String string) {
        try {
            ZipFile zipFile = new ZipFile(file);
            ZipEntry zipEntry = zipFile.getEntry(string);
            if (zipEntry != null) {
                return new URL(new StringBuffer().append("jar:").append(file.toURL()).append("!").append(string.startsWith("/") ? "" : "/").append(string).toString());
            }
            return null;
        }
        catch (IOException iOException) {
            return null;
        }
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError().initCause(classNotFoundException);
        }
    }

    private static class ClassCacheEntry {
        Class loadedClass;
        File origin;
        long lastModified;

        private ClassCacheEntry() {
        }
    }

    private class ResourceEnumeration
    implements Enumeration {
        Set resources;
        Iterator it;

        ResourceEnumeration(Set set) {
            this.resources = set;
            this.it = set.iterator();
        }

        public boolean hasMoreElements() {
            return this.it.hasNext();
        }

        public Object nextElement() {
            return this.it.next();
        }
    }
}

