/*
 * Decompiled with CFR 0.152.
 */
package com.sun.gssapi;

import com.sun.gssapi.GSSException;
import java.io.IOException;
import java.io.InputStream;
import java.util.Vector;

class DERParser {
    DERParser() {
    }

    static Vector decodeOid(InputStream inputStream) throws GSSException {
        try {
            if (inputStream.read() != 6) {
                throw new GSSException(10);
            }
        }
        catch (IOException iOException) {
            throw new GSSException(10);
        }
        return DERParser.decodeOidOctets(inputStream, DERParser.readLength(inputStream));
    }

    static Vector decodeOidOctets(InputStream inputStream, int n) throws GSSException {
        Vector<Integer> vector = new Vector<Integer>(9, 3);
        try {
            int n2 = inputStream.read();
            int n3 = n2 < 40 ? 0 : (n2 < 80 ? 1 : 2);
            vector.addElement(new Integer(n3));
            vector.addElement(new Integer(n2 - 40 * n3));
            int n4 = 1;
            while (n4 < n) {
                n3 = 0;
                int n5 = 0;
                while (n5 < 4) {
                    n3 <<= 7;
                    n2 = inputStream.read();
                    n3 |= n2 & 0x7F;
                    if ((n2 & 0x80) == 0) break;
                    ++n4;
                    ++n5;
                }
                vector.addElement(new Integer(n3));
                ++n4;
            }
        }
        catch (IOException iOException) {
            throw new GSSException(10);
        }
        return vector;
    }

    static int readLength(InputStream inputStream) throws GSSException {
        int n;
        try {
            int n2 = inputStream.read();
            if ((n2 & 0x80) == 0) {
                n = n2;
            } else {
                n2 &= 0x7F;
                n = 0;
                while (n2 > 0) {
                    n <<= 8;
                    n += 0xFF & inputStream.read();
                    --n2;
                }
            }
        }
        catch (IOException iOException) {
            throw new GSSException(10);
        }
        return n;
    }
}

