/*
 * Decompiled with CFR 0.152.
 */
package com.sun.gssapi;

import com.sun.gssapi.GSSCredSpi;
import com.sun.gssapi.GSSException;
import com.sun.gssapi.GSSName;
import com.sun.gssapi.Oid;
import java.util.Enumeration;
import java.util.Vector;

public class GSSCredential {
    Vector m_mechCreds;

    public boolean equals(Object object) {
        if (!(object instanceof GSSCredential)) {
            return false;
        }
        GSSCredential gSSCredential = (GSSCredential)object;
        if (gSSCredential.m_mechCreds.size() != this.m_mechCreds.size()) {
            return false;
        }
        try {
            Enumeration enumeration = this.m_mechCreds.elements();
            while (enumeration.hasMoreElements()) {
                GSSCredSpi gSSCredSpi = (GSSCredSpi)enumeration.nextElement();
                GSSCredSpi gSSCredSpi2 = gSSCredential.getMechCred(gSSCredSpi.getMechanism(), false);
                if (gSSCredSpi2 == null) {
                    return false;
                }
                if (gSSCredSpi.equals(gSSCredSpi2)) continue;
                return false;
            }
        }
        catch (GSSException gSSException) {
            return false;
        }
        return true;
    }

    public GSSName getGSSName() throws GSSException {
        if (this.m_mechCreds.size() < 1) {
            throw new GSSException(13);
        }
        GSSName gSSName = new GSSName();
        Enumeration enumeration = this.m_mechCreds.elements();
        while (enumeration.hasMoreElements()) {
            gSSName.addMechName(((GSSCredSpi)enumeration.nextElement()).getName());
        }
        return gSSName;
    }

    GSSCredSpi getMechCred(Oid oid, boolean bl) throws GSSException {
        Enumeration enumeration = this.m_mechCreds.elements();
        while (enumeration.hasMoreElements()) {
            GSSCredSpi gSSCredSpi = (GSSCredSpi)enumeration.nextElement();
            if (!gSSCredSpi.getMechanism().equals(oid)) continue;
            return gSSCredSpi;
        }
        if (bl) {
            throw new GSSException(2);
        }
        return null;
    }

    public Oid[] getMechs() throws GSSException {
        Oid[] oidArray = new Oid[this.m_mechCreds.size()];
        int n = 0;
        if (this.m_mechCreds.size() < 1) {
            throw new GSSException(13);
        }
        Enumeration enumeration = this.m_mechCreds.elements();
        while (enumeration.hasMoreElements()) {
            oidArray[n++] = ((GSSCredSpi)enumeration.nextElement()).getMechanism();
        }
        return oidArray;
    }

    public int getRemainingLifetime() throws GSSException {
        int n = Integer.MAX_VALUE;
        if (this.m_mechCreds.size() < 0) {
            throw new GSSException(13);
        }
        Enumeration enumeration = this.m_mechCreds.elements();
        while (enumeration.hasMoreElements()) {
            GSSCredSpi gSSCredSpi = (GSSCredSpi)enumeration.nextElement();
            if (gSSCredSpi.getLifetime() >= n) continue;
            n = gSSCredSpi.getLifetime();
        }
        return n;
    }

    public int getUsage() throws GSSException {
        boolean bl = false;
        boolean bl2 = false;
        if (this.m_mechCreds.size() < 0) {
            throw new GSSException(13);
        }
        Enumeration enumeration = this.m_mechCreds.elements();
        while (enumeration.hasMoreElements()) {
            GSSCredSpi gSSCredSpi = (GSSCredSpi)enumeration.nextElement();
            if (gSSCredSpi.getUsage() == 0) {
                return 0;
            }
            if (gSSCredSpi.getUsage() == 1) {
                bl = true;
            } else if (gSSCredSpi.getUsage() == 2) {
                bl2 = true;
            }
            if (!bl || !bl2) continue;
            return 0;
        }
        if (bl) {
            return 1;
        }
        return 2;
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer(150);
        stringBuffer.append(super.toString());
        stringBuffer.append("\nOver mechs:\t");
        try {
            Oid[] oidArray = this.getMechs();
            int n = 0;
            while (n < oidArray.length) {
                stringBuffer.append(new StringBuffer(String.valueOf(oidArray[n].toString())).append(" ").toString());
                ++n;
            }
            stringBuffer.append(new StringBuffer("\nFor principal:\t").append(this.getGSSName().toString()).toString());
            stringBuffer.append(new StringBuffer("\nUsage:\t").append(this.getUsage()).toString());
            if (this.getUsage() == 2) {
                stringBuffer.append(" (ACCEPT_ONLY)");
            } else if (this.getUsage() == 1) {
                stringBuffer.append(" (INITIATE_ONLY)");
            } else {
                stringBuffer.append(" (INITIATE and ACCEPT)");
            }
            stringBuffer.append(new StringBuffer("\nRemaining Lifetime:\t").append(this.getRemainingLifetime()).toString());
        }
        catch (GSSException gSSException) {
            stringBuffer.append(new StringBuffer("\n***ERROR getting info:\t").append(gSSException.toString()).toString());
        }
        return stringBuffer.toString();
    }
}

