/*
 * Decompiled with CFR 0.152.
 */
package com.sun.gssapi;

public class GSSException
extends Exception {
    private static String[] messages = new String[]{"channel binding mismatch", "unsupported mechanism requested", "invalid name provided", "name of unsupported type provided", "invalid input status selector", "token had invalid integrity check", "specified security context expired", "expired credentials detected", "defective credential detected", "defective token detected", "failure, unspecified at GSS-API level", "security context init/accept not yet called or context deleted", "no valid credentials provided", "unsupported QOP value", "operation unauthorized", "operation unavailable", "duplicate credential element requested", "name contains multi-mechanism elements", "the token was a duplicate of an earlier token", "the token's validity period has expired", "a later token has already been processed", "an expected per-message token was not received"};
    private int m_major;
    private int m_minor = 0;
    private String m_minorMessage = null;

    public GSSException(int n) {
        this.m_major = this.validateMajor(n) ? n : 5;
    }

    public GSSException(int n, int n2, String string) {
        this.m_major = this.validateMajor(n) ? n : 5;
        this.m_minor = n2;
        this.m_minorMessage = string;
    }

    public String getMajorString() {
        return messages[this.m_major - 1];
    }

    public String getMessage() {
        return this.toString();
    }

    public String getMinorString() {
        if (this.m_minorMessage == null) {
            this.m_minorMessage = "";
        }
        return this.m_minorMessage;
    }

    public String toString() {
        if (this.m_minor == 0) {
            return this.getMajorString();
        }
        return new StringBuffer(String.valueOf(this.getMajorString())).append("(").append(this.getMinorString()).append(")").toString();
    }

    private boolean validateMajor(int n) {
        return this.m_major > 0 && this.m_major <= messages.length;
    }
}

