/*
 * Decompiled with CFR 0.152.
 */
package com.sun.gssapi;

import com.sun.gssapi.GSSException;
import com.sun.gssapi.GSSManager;
import com.sun.gssapi.GSSNameSpi;
import com.sun.gssapi.Oid;
import java.util.Enumeration;
import java.util.Vector;

public class GSSName {
    public static final Oid NT_HOSTBASED_SERVICE;
    public static final Oid NT_USER_NAME;
    public static final Oid NT_MACHINE_UID_NAME;
    public static final Oid NT_STRING_UID_NAME;
    public static final Oid NT_ANONYMOUS;
    public static final Oid NT_EXPORT_NAME;
    Vector m_mechNames = new Vector(3, 2);
    Oid m_nameType;
    String m_nameStr;
    byte[] m_nameBytes;

    static {
        try {
            NT_HOSTBASED_SERVICE = new Oid("1.3.6.1.5.6.2");
            NT_USER_NAME = new Oid("1.2.840.113554.1.2.1.1");
            NT_MACHINE_UID_NAME = new Oid("1.2.840.113554.1.2.1.2");
            NT_STRING_UID_NAME = new Oid("1.2.840.113554.1.2.1.3");
            NT_ANONYMOUS = new Oid("1.3.6.1.5.6.3");
            NT_EXPORT_NAME = new Oid("1.3.6.1.5.6.4");
        }
        catch (GSSException gSSException) {
            throw new NumberFormatException();
        }
    }

    GSSName() {
    }

    public GSSName(String string, Oid oid) {
        this.m_nameStr = string;
        this.m_nameType = oid;
    }

    public GSSName(byte[] byArray, Oid oid) throws GSSException {
        this.m_nameType = oid;
        this.m_nameBytes = new byte[byArray.length];
        System.arraycopy(byArray, 0, this.m_nameBytes, 0, byArray.length);
        if (oid.equals(NT_EXPORT_NAME)) {
            if (byArray[0] != 4 && byArray[1] != 1) {
                throw new GSSException(3);
            }
            Oid oid2 = new Oid(byArray, 2);
            GSSNameSpi gSSNameSpi = GSSManager.getNameInstance(oid2);
            gSSNameSpi.init(byArray, oid);
            this.addMechName(gSSNameSpi);
        }
    }

    void addMechName(GSSNameSpi gSSNameSpi) {
        this.m_mechNames.addElement(gSSNameSpi);
    }

    GSSNameSpi canonicalizeInPlace(Oid oid) throws GSSException {
        GSSNameSpi gSSNameSpi = this.getMechName(oid);
        if (gSSNameSpi != null) {
            return gSSNameSpi;
        }
        gSSNameSpi = GSSManager.getNameInstance(oid);
        if (this.m_nameStr != null) {
            gSSNameSpi.init(this.m_nameStr, this.m_nameType);
        } else {
            gSSNameSpi.init(this.m_nameBytes, this.m_nameType);
        }
        this.addMechName(gSSNameSpi);
        return gSSNameSpi;
    }

    public Object clone() throws CloneNotSupportedException {
        GSSName gSSName;
        try {
            gSSName = this.m_nameStr != null ? new GSSName(this.m_nameStr, this.m_nameType) : (this.m_nameBytes != null ? new GSSName(this.m_nameBytes, this.m_nameType) : new GSSName());
            Enumeration enumeration = this.m_mechNames.elements();
            while (enumeration.hasMoreElements()) {
                gSSName.addMechName((GSSNameSpi)((GSSNameSpi)enumeration.nextElement()).clone());
            }
        }
        catch (Exception exception) {
            throw new CloneNotSupportedException();
        }
        return gSSName;
    }

    public boolean equals(GSSName gSSName) throws GSSException {
        if (this.isAnonymousName() || gSSName.isAnonymousName()) {
            return false;
        }
        if (this.m_mechNames.size() != gSSName.m_mechNames.size()) {
            return false;
        }
        if (this.m_mechNames.size() < 1) {
            if (!this.m_nameType.equals(gSSName.m_nameType)) {
                return false;
            }
            if (this.m_nameStr != null && gSSName.m_nameStr != null) {
                return this.m_nameStr.equals(gSSName.m_nameStr);
            }
            if (this.m_nameBytes != null && gSSName.m_nameBytes != null) {
                return this.m_nameBytes.equals(gSSName.m_nameBytes);
            }
            return false;
        }
        Enumeration enumeration = this.m_mechNames.elements();
        while (enumeration.hasMoreElements()) {
            GSSNameSpi gSSNameSpi = (GSSNameSpi)enumeration.nextElement();
            GSSNameSpi gSSNameSpi2 = gSSName.getMechName(gSSNameSpi.getMech());
            if (gSSNameSpi2 == null) {
                return false;
            }
            if (gSSNameSpi.equals(gSSNameSpi2)) continue;
            return false;
        }
        return true;
    }

    public boolean equals(Object object) {
        if (!(object instanceof GSSName)) {
            return false;
        }
        try {
            return this.equals((GSSName)object);
        }
        catch (GSSException gSSException) {
            return false;
        }
    }

    GSSNameSpi getMechName(Oid oid) {
        if (oid == null) {
            if (this.m_mechNames.size() < 1) {
                return null;
            }
            return (GSSNameSpi)this.m_mechNames.firstElement();
        }
        Enumeration enumeration = this.m_mechNames.elements();
        while (enumeration.hasMoreElements()) {
            GSSNameSpi gSSNameSpi = (GSSNameSpi)enumeration.nextElement();
            if (!gSSNameSpi.getMech().equals(oid)) continue;
            return gSSNameSpi;
        }
        return null;
    }

    public boolean isAnonymousName() {
        if (this.m_nameType.equals(NT_ANONYMOUS)) {
            return true;
        }
        if (this.m_mechNames.size() > 0) {
            return this.getMechName(null).isAnonymousName();
        }
        return false;
    }

    private boolean isMechName() {
        return this.m_mechNames.size() == 1;
    }

    public String toString() {
        if (this.isMechName()) {
            return this.getMechName(null).toString();
        }
        if (this.m_nameStr != null) {
            return this.m_nameStr;
        }
        if (this.m_mechNames.size() > 0) {
            return this.getMechName(null).toString();
        }
        return "Unknown name";
    }
}

