/*
 * Decompiled with CFR 0.152.
 */
package com.sun.gssapi;

import com.sun.gssapi.DERParser;
import com.sun.gssapi.GSSException;
import java.io.ByteArrayInputStream;
import java.util.Enumeration;
import java.util.StringTokenizer;
import java.util.Vector;

public class Oid {
    private Vector m_v;

    public Oid(String string) throws GSSException {
        this.m_v = new Vector(8, 3);
        this.parseFromStr(string);
    }

    public Oid(byte[] byArray, int n) throws GSSException {
        this.m_v = DERParser.decodeOid(new ByteArrayInputStream(byArray, n, byArray.length - n));
    }

    public boolean equals(Object object) {
        if (!(object instanceof Oid)) {
            return false;
        }
        if (this == object) {
            return true;
        }
        Oid oid = (Oid)object;
        if (this.m_v.size() != oid.m_v.size()) {
            return false;
        }
        Enumeration enumeration = this.m_v.elements();
        Enumeration enumeration2 = oid.m_v.elements();
        while (enumeration.hasMoreElements()) {
            if (enumeration.nextElement().equals(enumeration2.nextElement())) continue;
            return false;
        }
        return true;
    }

    private void parseFromStr(String string) throws GSSException {
        int n = string.indexOf("{");
        try {
            if (n != -1) {
                string = string.substring(n, string.lastIndexOf("}"));
            }
            StringTokenizer stringTokenizer = new StringTokenizer(string, " .");
            while (stringTokenizer.hasMoreTokens()) {
                this.m_v.addElement(new Integer(stringTokenizer.nextToken()));
            }
        }
        catch (Exception exception) {
            throw new GSSException(11);
        }
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer(50);
        if (this.m_v.size() < 1) {
            return new String("");
        }
        Enumeration enumeration = this.m_v.elements();
        while (enumeration.hasMoreElements()) {
            stringBuffer.append(enumeration.nextElement().toString());
            if (!enumeration.hasMoreElements()) continue;
            stringBuffer.append(".");
        }
        return stringBuffer.toString();
    }
}

