/*
 * Decompiled with CFR 0.152.
 */
package com.sun.jna;

import com.sun.jna.Pointer;
import com.sun.jna.Structure;
import com.sun.jna.TypeMapper;

public abstract class Union
extends Structure {
    private Structure.StructField activeField;
    Structure.StructField biggestField;
    static /* synthetic */ Class class$com$sun$jna$Structure;
    static /* synthetic */ Class class$java$lang$String;
    static /* synthetic */ Class class$com$sun$jna$WString;

    protected Union() {
    }

    protected Union(Pointer p) {
        super(p);
    }

    protected Union(Pointer p, int alignType) {
        super(p, alignType);
    }

    protected Union(TypeMapper mapper) {
        super(mapper);
    }

    protected Union(Pointer p, int alignType, TypeMapper mapper) {
        super(p, alignType, mapper);
    }

    public void setType(Class type) {
        this.ensureAllocated();
        for (Structure.StructField f : this.fields().values()) {
            if (f.type != type) continue;
            this.activeField = f;
            return;
        }
        throw new IllegalArgumentException(new StringBuffer().append("No field of type ").append(type).append(" in ").append(this).toString());
    }

    public Object readField(String name) {
        this.ensureAllocated();
        Structure.StructField f = (Structure.StructField)this.fields().get(name);
        if (f != null) {
            this.setType(f.type);
        }
        return super.readField(name);
    }

    public void writeField(String name) {
        this.ensureAllocated();
        Structure.StructField f = (Structure.StructField)this.fields().get(name);
        if (f != null) {
            this.setType(f.type);
        }
        super.writeField(name);
    }

    public void writeField(String name, Object value) {
        this.ensureAllocated();
        Structure.StructField f = (Structure.StructField)this.fields().get(name);
        if (f != null) {
            this.setType(f.type);
        }
        super.writeField(name, value);
    }

    public Object getTypedValue(Class type) {
        this.ensureAllocated();
        for (Structure.StructField f : this.fields().values()) {
            if (f.type != type) continue;
            this.activeField = f;
            this.read();
            return this.getField(this.activeField);
        }
        throw new IllegalArgumentException(new StringBuffer().append("No field of type ").append(type).append(" in ").append(this).toString());
    }

    public Object setTypedValue(Object object) {
        this.ensureAllocated();
        Structure.StructField f = this.findField(object.getClass());
        if (f != null) {
            this.activeField = f;
            this.setField(f, object);
            return this;
        }
        throw new IllegalArgumentException(new StringBuffer().append("No field of type ").append(object.getClass()).append(" in ").append(this).toString());
    }

    private Structure.StructField findField(Class type) {
        for (Structure.StructField f : this.fields().values()) {
            if (!f.type.isAssignableFrom(type)) continue;
            return f;
        }
        return null;
    }

    void writeField(Structure.StructField field) {
        if (field == this.activeField) {
            super.writeField(field);
        }
    }

    Object readField(Structure.StructField field) {
        if (field == this.activeField || !(class$com$sun$jna$Structure == null ? (class$com$sun$jna$Structure = Union.class$("com.sun.jna.Structure")) : class$com$sun$jna$Structure).isAssignableFrom(field.type) && !(class$java$lang$String == null ? (class$java$lang$String = Union.class$("java.lang.String")) : class$java$lang$String).isAssignableFrom(field.type) && !(class$com$sun$jna$WString == null ? (class$com$sun$jna$WString = Union.class$("com.sun.jna.WString")) : class$com$sun$jna$WString).isAssignableFrom(field.type)) {
            return super.readField(field);
        }
        return null;
    }

    int calculateSize(boolean force) {
        int size = super.calculateSize(force);
        if (size != -1) {
            int fsize = 0;
            for (Structure.StructField f : this.fields().values()) {
                f.offset = 0;
                if (f.size <= fsize && (f.size != fsize || !(class$com$sun$jna$Structure == null ? Union.class$("com.sun.jna.Structure") : class$com$sun$jna$Structure).isAssignableFrom(f.type))) continue;
                fsize = f.size;
                this.biggestField = f;
            }
            size = this.calculateAlignedSize(fsize);
            if (size > 0 && this instanceof Structure.ByValue) {
                this.getTypeInfo();
            }
        }
        return size;
    }

    protected int getNativeAlignment(Class type, Object value, boolean isFirstElement) {
        return super.getNativeAlignment(type, value, true);
    }

    Pointer getTypeInfo() {
        if (this.biggestField == null) {
            return null;
        }
        return super.getTypeInfo();
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError().initCause(x1);
        }
    }
}

