/*
 * Decompiled with CFR 0.152.
 */
package com.sun.nfs;

import com.sun.nfs.Fattr;
import com.sun.rpc.Xdr;
import java.util.Date;

class Fattr3
extends Fattr {
    int ftype;
    long mode;
    long nlink;
    long uid;
    long gid;
    long size;
    long used;
    long rdev;
    long fsid;
    long fileid;
    long atime;
    long mtime;
    long ctime;

    Fattr3() {
    }

    Fattr3(Xdr xdr) {
        this.getFattr(xdr);
    }

    void getFattr(Xdr xdr) {
        long l = this.mtime;
        this.ftype = xdr.xdr_int();
        this.mode = xdr.xdr_u_int();
        this.nlink = xdr.xdr_u_int();
        this.uid = xdr.xdr_u_int();
        if (this.uid == -2L) {
            this.uid = 60001L;
        }
        this.gid = xdr.xdr_u_int();
        if (this.gid == -2L) {
            this.gid = 60001L;
        }
        this.size = xdr.xdr_hyper();
        this.used = xdr.xdr_hyper();
        this.rdev = xdr.xdr_hyper();
        this.fsid = xdr.xdr_hyper();
        this.fileid = xdr.xdr_hyper();
        this.atime = xdr.xdr_u_int() * 1000L + xdr.xdr_u_int() / 1000000L;
        this.mtime = xdr.xdr_u_int() * 1000L + xdr.xdr_u_int() / 1000000L;
        this.ctime = xdr.xdr_u_int() * 1000L + xdr.xdr_u_int() / 1000000L;
        long l2 = this.mtime - l;
        if (l2 > 0L) {
            this.cachetime = l2;
            if (this.cachetime < 3000L) {
                this.cachetime = 3000L;
            } else if (this.cachetime > 60000L) {
                this.cachetime = 60000L;
            }
        }
        this.validtime = System.currentTimeMillis();
    }

    public String toString() {
        return new StringBuffer(" ftype = ").append(this.ftype).append("\n").append("  mode = 0").append(Long.toOctalString(this.mode)).append("\n").append(" nlink = ").append(this.nlink).append("\n").append("   uid = ").append(this.uid).append("\n").append("   gid = ").append(this.gid).append("\n").append("  size = ").append(this.size).append("\n").append("  used = ").append(this.used).append("\n").append("  rdev = 0x").append(Long.toHexString(this.rdev)).append("\n").append("  fsid = ").append(this.fsid).append("\n").append("fileid = ").append(this.fileid).append("\n").append(" atime = ").append(new Date(this.atime)).append("\n").append(" mtime = ").append(new Date(this.mtime)).append("\n").append(" ctime = ").append(new Date(this.ctime)).toString();
    }
}

