/*
 * Decompiled with CFR 0.152.
 */
package com.sun.nfs;

import java.io.IOException;

public class NfsException
extends IOException {
    int error;

    public NfsException(int n) {
        super(new StringBuffer("NFS error: ").append(n).toString());
        this.error = n;
    }

    public String toString() {
        switch (this.error) {
            case 0: {
                return "OK";
            }
            case 1: {
                return "Not owner";
            }
            case 2: {
                return "No such file or directory";
            }
            case 5: {
                return "I/O error";
            }
            case 6: {
                return "No such device or address";
            }
            case 13: {
                return "Permission denied";
            }
            case 17: {
                return "File exists";
            }
            case 18: {
                return "Attempted cross-device link";
            }
            case 19: {
                return "No such device";
            }
            case 20: {
                return "Not a directory";
            }
            case 21: {
                return "Is a directory";
            }
            case 22: {
                return "Invalid argument";
            }
            case 27: {
                return "File too large";
            }
            case 28: {
                return "No space left on device";
            }
            case 30: {
                return "Read-only file system";
            }
            case 31: {
                return "Too many links";
            }
            case 63: {
                return "File name too long";
            }
            case 66: {
                return "Directory not empty";
            }
            case 69: {
                return "Disk quota exceeded";
            }
            case 70: {
                return "Stale NFS file handle";
            }
            case 71: {
                return "Too many levels of remote in path";
            }
            case 10001: {
                return "Illegal NFS file handle";
            }
            case 10002: {
                return "Update sync mismatch";
            }
            case 10003: {
                return "Readdir cookie is stale";
            }
            case 10004: {
                return "Operation not supported";
            }
            case 10005: {
                return "Buffer/request too small";
            }
            case 10006: {
                return "Server fault";
            }
            case 10007: {
                return "Bad type";
            }
            case 10008: {
                return "Jukebox error: try later";
            }
        }
        return new StringBuffer("Unknown NFS error: ").append(this.error).toString();
    }
}

