/*
 * Decompiled with CFR 0.152.
 */
package com.sun.rpc;

import com.sun.rpc.Connection;
import com.sun.rpc.Xdr;
import java.io.IOException;
import java.io.InputStream;
import java.io.InterruptedIOException;
import java.io.OutputStream;
import java.net.Socket;
import java.net.UnknownHostException;

public class ConnectSocket
extends Connection {
    private OutputStream outs;
    private InputStream ins;
    private Socket sock;
    Xdr rcv_mark = new Xdr(4);

    public ConnectSocket(String string, int n, int n2) throws IOException {
        super(string, n, "tcp", n2);
        this.doConnect();
        this.start();
    }

    void checkConnection() {
        if (this.sock != null) {
            return;
        }
        this.reconnect();
    }

    private void doClose() throws IOException {
        if (this.ins != null) {
            this.ins.close();
            this.ins = null;
        }
        if (this.outs != null) {
            this.outs.close();
            this.outs = null;
        }
        if (this.sock != null) {
            this.sock.close();
            this.sock = null;
        }
    }

    private void doConnect() throws IOException {
        if (this.server == null) {
            throw new UnknownHostException("null host");
        }
        this.sock = new Socket(this.server, this.port);
        this.sock.setTcpNoDelay(true);
        this.ins = this.sock.getInputStream();
        this.outs = this.sock.getOutputStream();
    }

    void dropConnection() {
        try {
            this.doClose();
        }
        catch (IOException iOException) {}
    }

    protected void finalize() throws Throwable {
        this.doClose();
        super.finalize();
    }

    void receiveOne(Xdr xdr, int n) throws IOException {
        boolean bl = false;
        this.sock.setSoTimeout(n);
        try {
            int n2 = 0;
            while (!bl) {
                if (this.ins.read(this.rcv_mark.xdr_buf()) != 4) {
                    throw new IOException("TCP record mark: lost connection");
                }
                this.rcv_mark.xdr_offset(0);
                long l = this.rcv_mark.xdr_u_int();
                bl = (l & Integer.MIN_VALUE) != 0L;
                l &= Integer.MAX_VALUE;
                int n3 = 0;
                while ((long)n3 < l) {
                    int n4 = this.ins.read(xdr.xdr_buf(), n2 + n3, (int)l - n3);
                    if (n4 < 0) {
                        throw new IOException("TCP data: lost connection");
                    }
                    n3 += n4;
                }
                n2 = (int)((long)n2 + l);
            }
            xdr.xdr_size(n2);
        }
        catch (InterruptedIOException interruptedIOException) {
            throw interruptedIOException;
        }
        catch (IOException iOException) {
            this.reconnect();
            throw iOException;
        }
    }

    void reconnect() {
        System.err.println(new StringBuffer("Lost connection to ").append(this.server).append(" - attempting to reconnect").toString());
        ConnectSocket connectSocket = this;
        synchronized (connectSocket) {
            while (true) {
                try {
                    this.doClose();
                    this.doConnect();
                }
                catch (IOException iOException) {
                    try {
                        Thread.sleep(5000L);
                    }
                    catch (InterruptedException interruptedException) {}
                    continue;
                }
                break;
            }
        }
        System.err.println(new StringBuffer("Reconnected to ").append(this.server).toString());
    }

    void sendOne(Xdr xdr) throws IOException {
        int n = 0;
        int n2 = xdr.xdr_offset();
        ConnectSocket connectSocket = this;
        synchronized (connectSocket) {
            int n3 = 4;
            while (n3 < n2) {
                int n4 = n2 - n3;
                if (n4 > 1456) {
                    n4 = 1456;
                }
                if (n3 + n4 >= n2) {
                    n = Integer.MIN_VALUE;
                }
                xdr.xdr_offset(n3 - 4);
                int n5 = xdr.xdr_int();
                xdr.xdr_offset(n3 - 4);
                xdr.xdr_int(n | n4);
                this.outs.write(xdr.xdr_buf(), n3 - 4, n4 + 4);
                this.outs.flush();
                xdr.xdr_offset(n3 - 4);
                xdr.xdr_int(n5);
                n3 += n4;
            }
            xdr.xdr_offset(n2);
        }
    }
}

