/*
 * Decompiled with CFR 0.152.
 */
package com.sun.xfile;

import com.sun.xfile.XFileAccessor;
import com.sun.xfile.XFurl;
import java.io.File;
import java.util.Hashtable;
import java.util.StringTokenizer;

public class XFile {
    private XFileAccessor xfa;
    private XFurl url;
    private String urlStr;
    private File nativeFile;
    private boolean bound;
    static Hashtable cachedAccessors = new Hashtable();
    static Hashtable cachedExtensionAccessors = new Hashtable();

    public XFile(String string) {
        this.urlStr = string;
        if (string == null) {
            throw new NullPointerException();
        }
        try {
            this.url = new XFurl(string);
            this.xfa = this.loadAccessor(this.url);
        }
        catch (Exception exception) {
            if (string.startsWith(".:")) {
                string = string.substring(2);
            }
            this.nativeFile = new File(string);
            this.xfa = this.makeNative(this.nativeFile);
        }
    }

    private boolean bind() {
        if (this.bound) {
            return true;
        }
        this.bound = this.xfa.open(this, false, false);
        return this.bound;
    }

    public boolean canRead() {
        if (!this.bind()) {
            return false;
        }
        return this.xfa.canRead();
    }

    public boolean canWrite() {
        if (!this.bind()) {
            return false;
        }
        return this.xfa.canWrite();
    }

    public boolean delete() {
        if (!this.bind()) {
            return false;
        }
        boolean bl = this.xfa.delete();
        this.bound = bl ^ true;
        return bl;
    }

    public boolean equals(Object object) {
        if (object == null || !(object instanceof XFile)) {
            return false;
        }
        return this.url.toString().equals(((XFile)object).getURL().toString());
    }

    public boolean exists() {
        if (!this.bind()) {
            return false;
        }
        return this.xfa.exists();
    }

    public String getAbsolutePath() {
        if (this.nativeFile != null) {
            return this.nativeFile.getAbsolutePath();
        }
        return this.urlStr;
    }

    private XFileAccessor getAccessor() {
        return this.xfa;
    }

    private boolean getBound() {
        return this.bound;
    }

    public String getName() {
        if (this.nativeFile != null) {
            return this.nativeFile.getName();
        }
        return this.url.getName();
    }

    private File getNative() {
        return this.nativeFile;
    }

    public String getParent() {
        if (this.nativeFile != null) {
            return this.nativeFile.getParent();
        }
        return this.url.getParent();
    }

    private XFurl getURL() {
        return this.url;
    }

    public int hashCode() {
        return this.urlStr.hashCode() ^ 0x12D591;
    }

    public boolean isDirectory() {
        if (!this.bind()) {
            return false;
        }
        return this.xfa.isDirectory();
    }

    public long lastModified() {
        if (!this.bind()) {
            return 0L;
        }
        return this.xfa.lastModified();
    }

    public long length() {
        if (!this.bind()) {
            return 0L;
        }
        return this.xfa.exists() ? this.xfa.length() : 0L;
    }

    public String[] list() {
        if (!this.bind()) {
            return null;
        }
        return this.xfa.list();
    }

    private XFileAccessor loadAccessor(XFurl xFurl) throws ClassNotFoundException, IllegalAccessException, InstantiationException {
        Class clazz = this.loadClass(xFurl.getProtocol(), "XFileAccessor", cachedAccessors);
        if (clazz == null) {
            return null;
        }
        return (XFileAccessor)clazz.newInstance();
    }

    private Class loadClass(String string, String string2, Hashtable hashtable) throws ClassNotFoundException, IllegalAccessException {
        Class<?> clazz = (Class<?>)hashtable.get(string);
        if (clazz != null) {
            return clazz;
        }
        String string3 = System.getProperty("java.protocol.xfile");
        string3 = string3 == null ? "" : new StringBuffer(String.valueOf(string3)).append("|").toString();
        string3 = new StringBuffer(String.valueOf(string3)).append("com.sun").toString();
        StringTokenizer stringTokenizer = new StringTokenizer(string3, "|");
        while (clazz == null && stringTokenizer.hasMoreTokens()) {
            String string4 = stringTokenizer.nextToken().trim();
            String string5 = new StringBuffer(String.valueOf(string4)).append(".").append(string).append(".").append(string2).toString();
            try {
                clazz = Class.forName(string5);
            }
            catch (Exception exception) {}
        }
        if (clazz == null) {
            throw new ClassNotFoundException();
        }
        hashtable.put(string, clazz);
        return clazz;
    }

    private XFileAccessor makeNative(File file) {
        char c = File.separatorChar;
        try {
            this.url = new XFurl(new StringBuffer("file:///").append(file.getPath().replace(c, '/')).toString());
            return this.loadAccessor(this.url);
        }
        catch (Exception exception) {
            System.out.println(new StringBuffer("Error: makenative:").append(file.getPath()).toString());
            return null;
        }
    }

    public boolean mkdir() {
        this.bind();
        return this.xfa.mkdir();
    }

    protected XFileAccessor newAccessor() {
        try {
            return this.loadAccessor(this.url);
        }
        catch (Exception exception) {
            return this.makeNative(this.nativeFile);
        }
    }

    public boolean renameTo(XFile xFile) {
        if (xFile == null) {
            throw new NullPointerException();
        }
        if (!this.xfa.getClass().isInstance(xFile.getAccessor())) {
            return false;
        }
        if (!this.bind()) {
            return false;
        }
        boolean bl = this.xfa.renameTo(xFile);
        if (bl) {
            this.url = xFile.getURL();
            this.urlStr = xFile.getAbsolutePath();
            this.nativeFile = xFile.getNative();
            this.xfa = xFile.getAccessor();
            this.bound = xFile.getBound();
        }
        return bl;
    }

    public String toString() {
        if (this.nativeFile != null) {
            return this.nativeFile.toString();
        }
        return this.urlStr;
    }
}

