/*
 * Decompiled with CFR 0.152.
 */
package de.innosystec.unrar.io;

public class Raw {
    public static final int readIntBigEndian(byte[] array, int pos) {
        int temp = 0;
        temp |= array[pos] & 0xFF;
        temp <<= 8;
        temp |= array[pos + 1] & 0xFF;
        temp <<= 8;
        temp |= array[pos + 2] & 0xFF;
        temp <<= 8;
        return temp |= array[pos + 3] & 0xFF;
    }

    public static final short readShortLittleEndian(byte[] array, int pos) {
        short result = 0;
        result = (short)(result + (array[pos + 1] & 0xFF));
        result = (short)(result << 8);
        result = (short)(result + (array[pos] & 0xFF));
        return result;
    }

    public static final int readIntLittleEndian(byte[] array, int pos) {
        return (array[pos + 3] & 0xFF) << 24 | (array[pos + 2] & 0xFF) << 16 | (array[pos + 1] & 0xFF) << 8 | array[pos] & 0xFF;
    }

    public static final long readIntLittleEndianAsLong(byte[] array, int pos) {
        return ((long)array[pos + 3] & 0xFFL) << 24 | ((long)array[pos + 2] & 0xFFL) << 16 | ((long)array[pos + 1] & 0xFFL) << 8 | (long)array[pos] & 0xFFL;
    }

    public static final void writeIntBigEndian(byte[] array, int pos, int value) {
        array[pos] = (byte)(value >>> 24 & 0xFF);
        array[pos + 1] = (byte)(value >>> 16 & 0xFF);
        array[pos + 2] = (byte)(value >>> 8 & 0xFF);
        array[pos + 3] = (byte)(value & 0xFF);
    }

    public static final void writeShortLittleEndian(byte[] array, int pos, short value) {
        array[pos + 1] = (byte)(value >>> 8);
        array[pos] = (byte)(value & 0xFF);
    }

    public static final void incShortLittleEndian(byte[] array, int pos, int dv) {
        int c = (array[pos] & 0xFF) + (dv & 0xFF) >>> 8;
        int n = pos;
        array[n] = (byte)(array[n] + (dv & 0xFF));
        if (c > 0 || (dv & 0xFF00) != 0) {
            int n2 = pos + 1;
            array[n2] = (byte)(array[n2] + ((dv >>> 8 & 0xFF) + c));
        }
    }

    public static final void writeIntLittleEndian(byte[] array, int pos, int value) {
        array[pos + 3] = (byte)(value >>> 24);
        array[pos + 2] = (byte)(value >>> 16);
        array[pos + 1] = (byte)(value >>> 8);
        array[pos] = (byte)(value & 0xFF);
    }
}

