/*
 * Decompiled with CFR 0.152.
 */
package de.innosystec.unrar.rarfile;

import de.innosystec.unrar.io.Raw;
import de.innosystec.unrar.rarfile.UnrarHeadertype;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class BaseBlock {
    Log logger = LogFactory.getLog(BaseBlock.class.getName());
    protected long positionInFile;
    protected short headCRC = 0;
    protected byte headerType = 0;
    protected short flags = 0;
    protected short headerSize = 0;

    public BaseBlock() {
    }

    public BaseBlock(BaseBlock baseBlock) {
        this.flags = baseBlock.getFlags();
        this.headCRC = baseBlock.getHeadCRC();
        this.headerType = baseBlock.getHeaderType().getHeaderByte();
        this.headerSize = baseBlock.getHeaderSize();
        this.positionInFile = baseBlock.getPositionInFile();
    }

    public BaseBlock(byte[] byArray) {
        int n = 0;
        this.headCRC = Raw.readShortLittleEndian(byArray, n);
        this.headerType = (byte)(this.headerType | byArray[n += 2] & 0xFF);
        this.flags = Raw.readShortLittleEndian(byArray, ++n);
        this.headerSize = Raw.readShortLittleEndian(byArray, n += 2);
    }

    public boolean hasArchiveDataCRC() {
        return (this.flags & 2) != 0;
    }

    public boolean hasVolumeNumber() {
        return (this.flags & 8) != 0;
    }

    public boolean hasEncryptVersion() {
        return (this.flags & 0x200) != 0;
    }

    public boolean isSubBlock() {
        if (UnrarHeadertype.SubHeader.equals(this.headerType)) {
            return true;
        }
        return UnrarHeadertype.NewSubHeader.equals(this.headerType) && (this.flags & 0x10) != 0;
    }

    public long getPositionInFile() {
        return this.positionInFile;
    }

    public short getFlags() {
        return this.flags;
    }

    public short getHeadCRC() {
        return this.headCRC;
    }

    public short getHeaderSize() {
        return this.headerSize;
    }

    public UnrarHeadertype getHeaderType() {
        return UnrarHeadertype.findType(this.headerType);
    }

    public void setPositionInFile(long positionInFile) {
        this.positionInFile = positionInFile;
    }

    public void print() {
        StringBuilder str = new StringBuilder();
        str.append("HeaderType: " + (Object)((Object)this.getHeaderType()));
        str.append("\nHeadCRC: " + Integer.toHexString(this.getHeadCRC()));
        str.append("\nFlags: " + Integer.toHexString(this.getFlags()));
        str.append("\nHeaderSize: " + this.getHeaderSize());
        str.append("\nPosition in file: " + this.getPositionInFile());
        this.logger.info(str.toString());
    }
}

