/*
 * Decompiled with CFR 0.152.
 */
package de.innosystec.unrar.rarfile;

import de.innosystec.unrar.io.Raw;
import de.innosystec.unrar.rarfile.BlockHeader;
import de.innosystec.unrar.rarfile.FileNameDecoder;
import de.innosystec.unrar.rarfile.HostSystem;
import de.innosystec.unrar.rarfile.NewSubHeaderType;
import de.innosystec.unrar.rarfile.UnrarHeadertype;
import java.util.Calendar;
import java.util.Date;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class FileHeader
extends BlockHeader {
    private final Log logger = LogFactory.getLog(FileHeader.class.getName());
    private long unpSize;
    private final HostSystem hostOS;
    private final int fileCRC;
    private final int fileTime;
    private byte unpVersion;
    private byte unpMethod;
    private short nameSize;
    private int highPackSize;
    private int highUnpackSize;
    private final byte[] fileNameBytes;
    private String fileName;
    private String fileNameW;
    private byte[] subData;
    private final byte[] salt = new byte[8];
    private Date mTime;
    private long fullPackSize;
    private long fullUnpackSize;
    private int fileAttr;
    private int recoverySectors = -1;

    public FileHeader(BlockHeader blockHeader, byte[] byArray) {
        super(blockHeader);
        int n;
        int n2 = 0;
        this.unpSize = Raw.readIntLittleEndianAsLong(byArray, n2);
        n2 += 4;
        this.hostOS = HostSystem.findHostSystem(byArray[4]);
        this.fileCRC = Raw.readIntLittleEndian(byArray, ++n2);
        this.fileTime = Raw.readIntLittleEndian(byArray, n2 += 4);
        n2 += 4;
        this.unpVersion = (byte)(this.unpVersion | byArray[13] & 0xFF);
        ++n2;
        this.unpMethod = (byte)(this.unpMethod | byArray[14] & 0xFF);
        this.nameSize = Raw.readShortLittleEndian(byArray, ++n2);
        this.fileAttr = Raw.readIntLittleEndian(byArray, n2 += 2);
        n2 += 4;
        if (this.isLargeBlock()) {
            this.highPackSize = Raw.readIntLittleEndian(byArray, n2);
            this.highUnpackSize = Raw.readIntLittleEndian(byArray, n2 += 4);
            n2 += 4;
        } else {
            this.highPackSize = 0;
            this.highUnpackSize = 0;
            if (this.unpSize == -1L) {
                this.unpSize = -1L;
                this.highUnpackSize = Integer.MAX_VALUE;
            }
        }
        this.fullPackSize |= (long)this.highPackSize;
        this.fullPackSize <<= 32;
        this.fullPackSize |= (long)this.getPackSize();
        this.fullUnpackSize |= (long)this.highUnpackSize;
        this.fullUnpackSize <<= 32;
        this.fullUnpackSize += this.unpSize;
        this.nameSize = (short)(this.nameSize > 4096 ? 4096 : (int)this.nameSize);
        this.fileNameBytes = new byte[this.nameSize];
        for (n = 0; n < this.nameSize; ++n) {
            this.fileNameBytes[n] = byArray[n2];
            ++n2;
        }
        if (this.isFileHeader()) {
            if (this.isUnicode()) {
                this.fileName = "";
                this.fileNameW = "";
                for (n = 0; n < this.fileNameBytes.length && this.fileNameBytes[n] != 0; ++n) {
                }
                byte[] byArray2 = new byte[n];
                System.arraycopy(this.fileNameBytes, 0, byArray2, 0, byArray2.length);
                this.fileName = new String(byArray2);
                if (n != this.nameSize) {
                    this.fileNameW = FileNameDecoder.decode(this.fileNameBytes, ++n);
                }
            } else {
                this.fileName = new String(this.fileNameBytes);
                this.fileNameW = "";
            }
        }
        if (UnrarHeadertype.NewSubHeader.equals(this.headerType)) {
            n = this.headerSize - 32 - this.nameSize;
            if (this.hasSalt()) {
                n -= 8;
            }
            if (n > 0) {
                this.subData = new byte[n];
                for (int i = 0; i < n; ++i) {
                    this.subData[i] = byArray[n2];
                    ++n2;
                }
            }
            if (NewSubHeaderType.SUBHEAD_TYPE_RR.byteEquals(this.fileNameBytes)) {
                this.recoverySectors = this.subData[8] + (this.subData[9] << 8) + (this.subData[10] << 16) + (this.subData[11] << 24);
            }
        }
        if (this.hasSalt()) {
            for (n = 0; n < 8; ++n) {
                this.salt[n] = byArray[n2];
                ++n2;
            }
        }
        this.mTime = this.getDateDos(this.fileTime);
    }

    public void print() {
        super.print();
        StringBuilder str = new StringBuilder();
        str.append("unpSize: " + this.getUnpSize());
        str.append("\nHostOS: " + this.hostOS.name());
        str.append("\nMDate: " + this.mTime);
        str.append("\nFileName: " + this.getFileNameString());
        str.append("\nunpMethod: " + Integer.toHexString(this.getUnpMethod()));
        str.append("\nunpVersion: " + Integer.toHexString(this.getUnpVersion()));
        str.append("\nfullpackedsize: " + this.getFullPackSize());
        str.append("\nfullunpackedsize: " + this.getFullUnpackSize());
        str.append("\nisEncrypted: " + this.isEncrypted());
        str.append("\nisfileHeader: " + this.isFileHeader());
        str.append("\nisSolid: " + this.isSolid());
        str.append("\nisSplitafter: " + this.isSplitAfter());
        str.append("\nisSplitBefore:" + this.isSplitBefore());
        str.append("\nunpSize: " + this.getUnpSize());
        str.append("\ndataSize: " + this.getDataSize());
        str.append("\nisUnicode: " + this.isUnicode());
        str.append("\nhasVolumeNumber: " + this.hasVolumeNumber());
        str.append("\nhasArchiveDataCRC: " + this.hasArchiveDataCRC());
        str.append("\nhasSalt: " + this.hasSalt());
        str.append("\nhasEncryptVersions: " + this.hasEncryptVersion());
        str.append("\nisSubBlock: " + this.isSubBlock());
        this.logger.info(str.toString());
    }

    private Date getDateDos(int time) {
        Calendar cal = Calendar.getInstance();
        cal.set(1, (time >>> 25) + 1980);
        cal.set(2, (time >>> 21 & 0xF) - 1);
        cal.set(5, time >>> 16 & 0x1F);
        cal.set(11, time >>> 11 & 0x1F);
        cal.set(12, time >>> 5 & 0x3F);
        cal.set(13, (time & 0x1F) * 2);
        return cal.getTime();
    }

    public int getFileCRC() {
        return this.fileCRC;
    }

    public String getFileNameString() {
        return this.fileName;
    }

    public Date getMTime() {
        return this.mTime;
    }

    public byte getUnpMethod() {
        return this.unpMethod;
    }

    public long getUnpSize() {
        return this.unpSize;
    }

    public byte getUnpVersion() {
        return this.unpVersion;
    }

    public long getFullPackSize() {
        return this.fullPackSize;
    }

    public long getFullUnpackSize() {
        return this.fullUnpackSize;
    }

    public String toString() {
        return super.toString();
    }

    public boolean isSplitAfter() {
        return (this.flags & 2) != 0;
    }

    public boolean isSplitBefore() {
        return (this.flags & 1) != 0;
    }

    public boolean isSolid() {
        return (this.flags & 0x10) != 0;
    }

    public boolean isEncrypted() {
        return (this.flags & 4) != 0;
    }

    public boolean isUnicode() {
        return (this.flags & 0x200) != 0;
    }

    public boolean isFileHeader() {
        return UnrarHeadertype.FileHeader.equals(this.headerType);
    }

    public boolean hasSalt() {
        return (this.flags & 0x400) != 0;
    }

    public boolean isLargeBlock() {
        return (this.flags & 0x100) != 0;
    }

    public boolean isDirectory() {
        return (this.flags & 0xE0) == 224;
    }
}

