/*
 * Decompiled with CFR 0.152.
 */
package de.innosystec.unrar.rarfile;

import de.innosystec.unrar.io.Raw;
import de.innosystec.unrar.rarfile.BaseBlock;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class MainHeader
extends BaseBlock {
    private Log logger = LogFactory.getLog(MainHeader.class.getName());
    private short highPosAv;
    private int posAv;
    private byte encryptVersion;

    public MainHeader(BaseBlock baseBlock, byte[] byArray) {
        super(baseBlock);
        int n = 0;
        this.highPosAv = Raw.readShortLittleEndian(byArray, n);
        this.posAv = Raw.readIntLittleEndian(byArray, n += 2);
        n += 4;
        if (this.hasEncryptVersion()) {
            this.encryptVersion = (byte)(this.encryptVersion | byArray[n] & 0xFF);
        }
    }

    public boolean hasArchCmt() {
        return (this.flags & 2) != 0;
    }

    public byte getEncryptVersion() {
        return this.encryptVersion;
    }

    public short getHighPosAv() {
        return this.highPosAv;
    }

    public int getPosAv() {
        return this.posAv;
    }

    public boolean isEncrypted() {
        return (this.flags & 0x80) != 0;
    }

    public boolean isMultiVolume() {
        return (this.flags & 1) != 0;
    }

    public boolean isFirstVolume() {
        return (this.flags & 0x100) != 0;
    }

    public void print() {
        super.print();
        StringBuilder str = new StringBuilder();
        str.append("posav: " + this.getPosAv());
        str.append("\nhighposav: " + this.getHighPosAv());
        str.append("\nhasencversion: " + this.hasEncryptVersion() + (this.hasEncryptVersion() ? Byte.valueOf(this.getEncryptVersion()) : ""));
        str.append("\nhasarchcmt: " + this.hasArchCmt());
        str.append("\nisEncrypted: " + this.isEncrypted());
        str.append("\nisMultivolume: " + this.isMultiVolume());
        str.append("\nisFirstvolume: " + this.isFirstVolume());
        str.append("\nisSolid: " + this.isSolid());
        str.append("\nisLocked: " + this.isLocked());
        str.append("\nisProtected: " + this.isProtected());
        str.append("\nisAV: " + this.isAV());
        this.logger.info(str.toString());
    }

    public boolean isSolid() {
        return (this.flags & 8) != 0;
    }

    public boolean isLocked() {
        return (this.flags & 4) != 0;
    }

    public boolean isProtected() {
        return (this.flags & 0x40) != 0;
    }

    public boolean isAV() {
        return (this.flags & 0x20) != 0;
    }

    public boolean isNewNumbering() {
        return (this.flags & 0x10) != 0;
    }
}

