/*
 * Decompiled with CFR 0.152.
 */
package de.innosystec.unrar.rarfile;

import de.innosystec.unrar.io.Raw;
import de.innosystec.unrar.rarfile.SubBlockHeader;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class UnixOwnersHeader
extends SubBlockHeader {
    private Log logger = LogFactory.getLog(UnixOwnersHeader.class);
    private int ownerNameSize;
    private int groupNameSize;
    private String owner;
    private String group;

    public UnixOwnersHeader(SubBlockHeader subBlockHeader, byte[] byArray) {
        super(subBlockHeader);
        byte[] byArray2;
        int n = 0;
        this.ownerNameSize = Raw.readShortLittleEndian(byArray, n) & 0xFFFF;
        this.groupNameSize = Raw.readShortLittleEndian(byArray, n += 2) & 0xFFFF;
        if ((n += 2) + this.ownerNameSize < byArray.length) {
            byArray2 = new byte[this.ownerNameSize];
            System.arraycopy(byArray, n, byArray2, 0, this.ownerNameSize);
            this.owner = new String(byArray2);
        }
        if ((n += this.ownerNameSize) + this.groupNameSize < byArray.length) {
            byArray2 = new byte[this.groupNameSize];
            System.arraycopy(byArray, n, byArray2, 0, this.groupNameSize);
            this.group = new String(byArray2);
        }
    }

    public void print() {
        super.print();
        this.logger.info("ownerNameSize: " + this.ownerNameSize);
        this.logger.info("owner: " + this.owner);
        this.logger.info("groupNameSize: " + this.groupNameSize);
        this.logger.info("group: " + this.group);
    }
}

