/*
 * Decompiled with CFR 0.152.
 */
package de.innosystec.unrar.unpack.ppm;

import de.innosystec.unrar.exception.RarException;
import de.innosystec.unrar.unpack.Unpack;
import java.io.IOException;

public class RangeCoder {
    private long low;
    private long code;
    private long range;
    private final SubRange subRange = new SubRange();
    private Unpack unpackRead;

    public SubRange getSubRange() {
        return this.subRange;
    }

    public void initDecoder(Unpack unpackRead) throws IOException, RarException {
        this.unpackRead = unpackRead;
        this.code = 0L;
        this.low = 0L;
        this.range = 0xFFFFFFFFL;
        for (int i = 0; i < 4; ++i) {
            this.code = (this.code << 8 | (long)this.getChar()) & 0xFFFFFFFFL;
        }
    }

    public int getCurrentCount() {
        this.range = this.range / this.subRange.getScale() & 0xFFFFFFFFL;
        return (int)((this.code - this.low) / this.range);
    }

    public long getCurrentShiftCount(int SHIFT) {
        this.range >>>= SHIFT;
        return (this.code - this.low) / this.range & 0xFFFFFFFFL;
    }

    public void decode() {
        this.low = this.low + this.range * this.subRange.getLowCount() & 0xFFFFFFFFL;
        this.range = this.range * (this.subRange.getHighCount() - this.subRange.getLowCount()) & 0xFFFFFFFFL;
    }

    private int getChar() throws IOException, RarException {
        return this.unpackRead.getChar();
    }

    public void ariDecNormalize() throws IOException, RarException {
        boolean c2 = false;
        while ((this.low ^ this.low + this.range) < 0x1000000L || (c2 = this.range < 32768L)) {
            if (c2) {
                this.range = -this.low & 0x7FFFL & 0xFFFFFFFFL;
                c2 = false;
            }
            this.code = (this.code << 8 | (long)this.getChar()) & 0xFFFFFFFFL;
            this.range = this.range << 8 & 0xFFFFFFFFL;
            this.low = this.low << 8 & 0xFFFFFFFFL;
        }
    }

    public String toString() {
        StringBuilder buffer = new StringBuilder();
        buffer.append("RangeCoder[");
        buffer.append("\n  low=");
        buffer.append(this.low);
        buffer.append("\n  code=");
        buffer.append(this.code);
        buffer.append("\n  range=");
        buffer.append(this.range);
        buffer.append("\n  subrange=");
        buffer.append(this.subRange);
        buffer.append("]");
        return buffer.toString();
    }

    public static class SubRange {
        private long lowCount;
        private long highCount;
        private long scale;

        public long getHighCount() {
            return this.highCount;
        }

        public void setHighCount(long highCount) {
            this.highCount = highCount & 0xFFFFFFFFL;
        }

        public long getLowCount() {
            return this.lowCount & 0xFFFFFFFFL;
        }

        public void setLowCount(long lowCount) {
            this.lowCount = lowCount & 0xFFFFFFFFL;
        }

        public long getScale() {
            return this.scale;
        }

        public void setScale(long scale) {
            this.scale = scale & 0xFFFFFFFFL;
        }

        public void incScale(int dScale) {
            this.setScale(this.getScale() + (long)dScale);
        }

        public String toString() {
            StringBuilder buffer = new StringBuilder();
            buffer.append("SubRange[");
            buffer.append("\n  lowCount=");
            buffer.append(this.lowCount);
            buffer.append("\n  highCount=");
            buffer.append(this.highCount);
            buffer.append("\n  scale=");
            buffer.append(this.scale);
            buffer.append("]");
            return buffer.toString();
        }
    }
}

