/*
 * Decompiled with CFR 0.152.
 */
package de.innosystec.unrar.unpack.ppm;

import de.innosystec.unrar.io.Raw;
import de.innosystec.unrar.unpack.ppm.Pointer;

public class RarMemBlock
extends Pointer {
    private int stamp;
    private int NU;
    private int next;
    private int prev;

    public RarMemBlock(byte[] mem) {
        super(mem);
    }

    public void insertAt(RarMemBlock p) {
        RarMemBlock temp = new RarMemBlock(this.mem);
        this.setPrev(p.getAddress());
        temp.setAddress(this.getPrev());
        this.setNext(temp.getNext());
        temp.setNext(this);
        temp.setAddress(this.getNext());
        temp.setPrev(this);
    }

    public void remove() {
        RarMemBlock temp = new RarMemBlock(this.mem);
        temp.setAddress(this.getPrev());
        temp.setNext(this.getNext());
        temp.setAddress(this.getNext());
        temp.setPrev(this.getPrev());
    }

    public int getNext() {
        if (this.mem != null) {
            this.next = Raw.readIntLittleEndian(this.mem, this.pos + 4);
        }
        return this.next;
    }

    public void setNext(RarMemBlock next) {
        this.setNext(next.getAddress());
    }

    public void setNext(int next) {
        this.next = next;
        if (this.mem != null) {
            Raw.writeIntLittleEndian(this.mem, this.pos + 4, next);
        }
    }

    public int getNU() {
        if (this.mem != null) {
            this.NU = Raw.readShortLittleEndian(this.mem, this.pos + 2) & 0xFFFF;
        }
        return this.NU;
    }

    public void setNU(int nu) {
        this.NU = nu & 0xFFFF;
        if (this.mem != null) {
            Raw.writeShortLittleEndian(this.mem, this.pos + 2, (short)nu);
        }
    }

    public int getPrev() {
        if (this.mem != null) {
            this.prev = Raw.readIntLittleEndian(this.mem, this.pos + 8);
        }
        return this.prev;
    }

    public void setPrev(RarMemBlock prev) {
        this.setPrev(prev.getAddress());
    }

    public void setPrev(int prev) {
        this.prev = prev;
        if (this.mem != null) {
            Raw.writeIntLittleEndian(this.mem, this.pos + 8, prev);
        }
    }

    public int getStamp() {
        if (this.mem != null) {
            this.stamp = Raw.readShortLittleEndian(this.mem, this.pos) & 0xFFFF;
        }
        return this.stamp;
    }

    public void setStamp(int stamp) {
        this.stamp = stamp;
        if (this.mem != null) {
            Raw.writeShortLittleEndian(this.mem, this.pos, (short)stamp);
        }
    }
}

