/*
 * Decompiled with CFR 0.152.
 */
package javax.jmdns.impl.constants;

import java.util.logging.Level;
import java.util.logging.Logger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public enum DNSRecordClass {
    CLASS_UNKNOWN("?", 0),
    CLASS_IN("in", 1),
    CLASS_CS("cs", 2),
    CLASS_CH("ch", 3),
    CLASS_HS("hs", 4),
    CLASS_NONE("none", 254),
    CLASS_ANY("any", 255);

    private static Logger logger;
    private final String _externalName;
    private final int _index;

    private DNSRecordClass(String name, int index) {
        this._externalName = name;
        this._index = index;
    }

    public int indexValue() {
        return this._index;
    }

    public boolean isUnique() {
        return (this._index & 0x8000) != 0;
    }

    public static DNSRecordClass classForIndex(int index) {
        int maskedIndex = index & Short.MAX_VALUE;
        for (DNSRecordClass aClass : DNSRecordClass.values()) {
            if (aClass._index != maskedIndex) continue;
            return aClass;
        }
        logger.log(Level.WARNING, "Could not find record class for index: " + index);
        return CLASS_UNKNOWN;
    }

    public String toString() {
        return this.name() + " index " + this.indexValue();
    }

    static {
        logger = Logger.getLogger(DNSRecordClass.class.getName());
    }
}

