/*
 * Decompiled with CFR 0.152.
 */
package javax.jmdns.impl.tasks;

import java.net.InetAddress;
import java.util.HashSet;
import java.util.Iterator;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.jmdns.impl.DNSIncoming;
import javax.jmdns.impl.DNSOutgoing;
import javax.jmdns.impl.DNSQuestion;
import javax.jmdns.impl.DNSRecord;
import javax.jmdns.impl.JmDNSImpl;
import javax.jmdns.impl.ServiceInfoImpl;
import javax.jmdns.impl.constants.DNSRecordClass;
import javax.jmdns.impl.constants.DNSRecordType;
import javax.jmdns.impl.constants.DNSState;
import javax.jmdns.impl.tasks.DNSTask;

public class Responder
extends DNSTask {
    static Logger logger = Logger.getLogger(Responder.class.getName());
    private DNSIncoming _in;
    private InetAddress _addr;
    private int _port;

    public Responder(JmDNSImpl jmDNSImpl, DNSIncoming in, InetAddress addr, int port) {
        super(jmDNSImpl);
        this._in = in;
        this._addr = addr;
        this._port = port;
    }

    public void start() {
        int delay;
        boolean iAmTheOnlyOne = true;
        for (DNSQuestion dNSQuestion : this._in.getQuestions()) {
            logger.finest("start() question=" + dNSQuestion);
            if (iAmTheOnlyOne &= DNSRecordType.TYPE_SRV.equals((Object)dNSQuestion.getRecordType()) || DNSRecordType.TYPE_TXT.equals((Object)dNSQuestion.getRecordType()) || DNSRecordType.TYPE_A.equals((Object)dNSQuestion.getRecordType()) || DNSRecordType.TYPE_AAAA.equals((Object)dNSQuestion.getRecordType()) || this._jmDNSImpl.getLocalHost().getName().equalsIgnoreCase(dNSQuestion.getName()) || this._jmDNSImpl.getServices().containsKey(dNSQuestion.getName().toLowerCase())) continue;
            break;
        }
        int n = delay = iAmTheOnlyOne && !this._in.isTruncated() ? 0 : 20 + JmDNSImpl.getRandom().nextInt(96) - this._in.elapseSinceArrival();
        if (delay < 0) {
            delay = 0;
        }
        logger.finest("start() Responder chosen delay=" + delay);
        this._jmDNSImpl.schedule(this, delay);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void run() {
        Object object = this._jmDNSImpl.getIoLock();
        synchronized (object) {
            if (this._jmDNSImpl.getPlannedAnswer() == this._in) {
                this._jmDNSImpl.setPlannedAnswer(null);
            }
            HashSet<DNSQuestion> questions = new HashSet<DNSQuestion>();
            HashSet<DNSRecord> answers = new HashSet<DNSRecord>();
            if (this._jmDNSImpl.getState() == DNSState.ANNOUNCED) {
                try {
                    boolean isUnicast = this._port != 5353;
                    block11: for (DNSQuestion dNSQuestion : this._in.getQuestions()) {
                        DNSRecord.Address answer;
                        DNSRecordType type;
                        if (isUnicast) {
                            questions.add(dNSQuestion);
                        }
                        if (DNSRecordType.TYPE_ANY.equals((Object)(type = dNSQuestion.getRecordType())) || DNSRecordType.TYPE_SRV.equals((Object)type)) {
                            if (this._jmDNSImpl.getLocalHost().getName().equalsIgnoreCase(dNSQuestion.getName())) {
                                answer = this._jmDNSImpl.getLocalHost().getDNS4AddressRecord();
                                if (answer != null) {
                                    answers.add(answer);
                                }
                                if ((answer = this._jmDNSImpl.getLocalHost().getDNS6AddressRecord()) != null) {
                                    answers.add(answer);
                                }
                                type = DNSRecordType.TYPE_IGNORE;
                            } else if (this._jmDNSImpl.getServiceTypes().containsKey(dNSQuestion.getName().toLowerCase())) {
                                type = DNSRecordType.TYPE_PTR;
                            }
                        }
                        switch (type) {
                            case TYPE_A: {
                                answer = this._jmDNSImpl.getLocalHost().getDNS4AddressRecord();
                                if (answer == null) break;
                                answers.add(answer);
                                break;
                            }
                            case TYPE_AAAA: {
                                answer = this._jmDNSImpl.getLocalHost().getDNS6AddressRecord();
                                if (answer == null) break;
                                answers.add(answer);
                                break;
                            }
                            case TYPE_PTR: {
                                for (ServiceInfoImpl serviceInfoImpl : this._jmDNSImpl.getServices().values()) {
                                    if (serviceInfoImpl.getState() != DNSState.ANNOUNCED || !dNSQuestion.getName().equalsIgnoreCase(serviceInfoImpl.getType())) continue;
                                    DNSRecord.Address answer2 = this._jmDNSImpl.getLocalHost().getDNS4AddressRecord();
                                    if (answer2 != null) {
                                        answers.add(answer2);
                                    }
                                    if ((answer2 = this._jmDNSImpl.getLocalHost().getDNS6AddressRecord()) != null) {
                                        answers.add(answer2);
                                    }
                                    answers.add(new DNSRecord.Pointer(serviceInfoImpl.getType(), DNSRecordType.TYPE_PTR, DNSRecordClass.CLASS_IN, false, 3600, serviceInfoImpl.getQualifiedName()));
                                    answers.add(new DNSRecord.Service(serviceInfoImpl.getQualifiedName(), DNSRecordType.TYPE_SRV, DNSRecordClass.CLASS_IN, true, 3600, serviceInfoImpl.getPriority(), serviceInfoImpl.getWeight(), serviceInfoImpl.getPort(), this._jmDNSImpl.getLocalHost().getName()));
                                    answers.add(new DNSRecord.Text(serviceInfoImpl.getQualifiedName(), DNSRecordType.TYPE_TXT, DNSRecordClass.CLASS_IN, true, 3600, serviceInfoImpl.getText()));
                                }
                                if (!dNSQuestion.getName().equalsIgnoreCase("_services._mdns._udp.local.")) break;
                                Iterator<String> serviceTypeIterator = this._jmDNSImpl.getServiceTypes().values().iterator();
                                while (serviceTypeIterator.hasNext()) {
                                    answers.add(new DNSRecord.Pointer("_services._mdns._udp.local.", DNSRecordType.TYPE_PTR, DNSRecordClass.CLASS_IN, false, 3600, serviceTypeIterator.next()));
                                }
                                continue block11;
                            }
                            case TYPE_SRV: 
                            case TYPE_ANY: 
                            case TYPE_TXT: {
                                DNSRecord.Address address;
                                ServiceInfoImpl info = (ServiceInfoImpl)this._jmDNSImpl.getServices().get(dNSQuestion.getName().toLowerCase());
                                if (info == null || info.getState() != DNSState.ANNOUNCED) break;
                                DNSRecord.Address address2 = this._jmDNSImpl.getLocalHost().getDNS4AddressRecord();
                                if (address2 != null) {
                                    answers.add(address2);
                                }
                                if ((address = this._jmDNSImpl.getLocalHost().getDNS6AddressRecord()) != null) {
                                    answers.add(address);
                                }
                                answers.add(new DNSRecord.Pointer(info.getType(), DNSRecordType.TYPE_PTR, DNSRecordClass.CLASS_IN, false, 3600, info.getQualifiedName()));
                                answers.add(new DNSRecord.Service(info.getQualifiedName(), DNSRecordType.TYPE_SRV, DNSRecordClass.CLASS_IN, true, 3600, info.getPriority(), info.getWeight(), info.getPort(), this._jmDNSImpl.getLocalHost().getName()));
                                answers.add(new DNSRecord.Text(info.getQualifiedName(), DNSRecordType.TYPE_TXT, DNSRecordClass.CLASS_IN, true, 3600, info.getText()));
                                break;
                            }
                        }
                    }
                    for (DNSRecord dNSRecord : this._in.getAnswers()) {
                        if (dNSRecord.getTTL() <= 1800 || !answers.remove(dNSRecord)) continue;
                        logger.log(Level.FINER, "JmDNS Responder Known Answer Removed");
                    }
                    if (answers.size() != 0) {
                        logger.finer("run() JmDNS responding");
                        DNSOutgoing out = null;
                        if (isUnicast) {
                            out = new DNSOutgoing(33792, false);
                        }
                        if (out != null) {
                            for (DNSQuestion question : questions) {
                                out.addQuestion(question);
                            }
                            for (DNSRecord answer : answers) {
                                out = this._jmDNSImpl.addAnswer(this._in, this._addr, this._port, out, answer);
                            }
                            this._jmDNSImpl.send(out);
                        }
                    }
                    this.cancel();
                }
                catch (Throwable e) {
                    logger.log(Level.WARNING, "run() exception ", e);
                    this._jmDNSImpl.close();
                }
            }
        }
    }
}

