/*
 * Decompiled with CFR 0.152.
 */
package javax.jmdns.impl.tasks;

import java.io.IOException;
import java.util.Timer;
import java.util.TimerTask;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.jmdns.impl.DNSOutgoing;
import javax.jmdns.impl.DNSQuestion;
import javax.jmdns.impl.DNSRecord;
import javax.jmdns.impl.JmDNSImpl;
import javax.jmdns.impl.ServiceInfoImpl;
import javax.jmdns.impl.constants.DNSRecordClass;
import javax.jmdns.impl.constants.DNSRecordType;
import javax.jmdns.impl.constants.DNSState;
import javax.jmdns.impl.tasks.DNSTask;

public class ServiceResolver
extends DNSTask {
    static Logger logger = Logger.getLogger(ServiceResolver.class.getName());
    int _count = 0;
    private String _type;

    public ServiceResolver(JmDNSImpl jmDNSImpl, String type) {
        super(jmDNSImpl);
        this._type = type;
    }

    public void start(Timer timer) {
        timer.schedule((TimerTask)this, 225L, 225L);
    }

    public void run() {
        try {
            if (this._jmDNSImpl.getState() == DNSState.ANNOUNCED) {
                if (this._count++ < 3) {
                    logger.finer("run() JmDNS querying service");
                    long now = System.currentTimeMillis();
                    DNSOutgoing out = new DNSOutgoing(0);
                    out.addQuestion(new DNSQuestion(this._type, DNSRecordType.TYPE_PTR, DNSRecordClass.CLASS_IN, false));
                    for (ServiceInfoImpl serviceInfoImpl : this._jmDNSImpl.getServices().values()) {
                        try {
                            out.addAnswer(new DNSRecord.Pointer(serviceInfoImpl.getType(), DNSRecordType.TYPE_PTR, DNSRecordClass.CLASS_IN, false, 3600, serviceInfoImpl.getQualifiedName()), now);
                        }
                        catch (IOException ee) {
                            break;
                        }
                    }
                    this._jmDNSImpl.send(out);
                } else {
                    this.cancel();
                }
            } else if (this._jmDNSImpl.getState() == DNSState.CANCELED) {
                this.cancel();
            }
        }
        catch (Throwable e) {
            logger.log(Level.WARNING, "run() exception ", e);
            this._jmDNSImpl.recover();
        }
    }
}

